/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.stand;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.stand.ItemArmorStand;
import net.mcft.copy.betterstorage.tile.stand.TileEntityArmorStand;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileArmorStand
extends TileContainerBetterStorage {
    public TileArmorStand() {
        super(Material.rock);
        this.setHardness(2.5f);
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 2.0f, 0.875f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemArmorStand.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("stone_slab_top");
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemIconName() {
        return "betterstorage:armorStand";
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 0) {
            this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 2.0f, 0.875f);
        } else {
            this.setBlockBounds(0.125f, -1.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        }
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return ClientProxy.armorStandRenderId;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta == 0 ? 1 : 0;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBy(world, x, y, z, player, stack);
        world.setBlock(x, y + 1, z, (Block)this, 1, 3);
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
            hitY += 1.0f;
        }
        return super.onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (world.getBlockMetadata(x, y, z) > 0) {
            --y;
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return world.setBlockToAir(x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (meta > 0) {
            return;
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int targetMeta;
        int metadata = world.getBlockMetadata(x, y, z);
        int targetY = y + (metadata == 0 ? 1 : -1);
        int n = targetMeta = metadata == 0 ? 1 : 0;
        if (world.getBlock(x, targetY, z) == this && world.getBlockMetadata(x, targetY, z) == targetMeta) {
            return;
        }
        world.setBlockToAir(x, y, z);
        if (metadata == 0) {
            this.dropBlockAsItem(world, x, y, z, metadata, 0);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return metadata == 0 ? new TileEntityArmorStand() : null;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }
}

