/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.security.InvalidParameterException;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.attachment.LockAttachment;
import net.mcft.copy.betterstorage.tile.ContainerMaterial;
import net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityLockable
extends TileEntityConnectable
implements ILockable,
IHasAttachments {
    private boolean powered;
    public ContainerMaterial material;
    public LockAttachment lockAttachment;
    protected Attachments attachments = new Attachments(this);

    protected ItemStack getLockInternal() {
        return this.canHaveLock() ? this.lockAttachment.getItem() : null;
    }

    protected void setLockInternal(ItemStack lock) {
        this.lockAttachment.setItem(lock);
    }

    public TileEntityLockable() {
        if (!this.canHaveLock()) {
            return;
        }
        this.lockAttachment = this.attachments.add(LockAttachment.class);
        this.lockAttachment.setScale(0.5f, 1.5f);
        this.setAttachmentPosition();
    }

    public ContainerMaterial getMaterial() {
        if (!this.canHaveMaterial()) {
            return null;
        }
        if (this.material != null) {
            return this.material;
        }
        this.material = this.worldObj != null ? ContainerMaterial.get(this.getBlockMetadata()) : ContainerMaterial.iron;
        return this.material;
    }

    public boolean canHaveMaterial() {
        return true;
    }

    public boolean canHaveLock() {
        return true;
    }

    public abstract void setAttachmentPosition();

    @Override
    public Attachments getAttachments() {
        return ((TileEntityLockable)this.getMainTileEntity()).attachments;
    }

    @Override
    public void setOrientation(ForgeDirection orientation) {
        super.setOrientation(orientation);
        if (this.canHaveLock()) {
            this.lockAttachment.setDirection(orientation);
        }
    }

    @Override
    public void setConnected(ForgeDirection connected) {
        super.setConnected(connected);
        if (this.canHaveLock()) {
            this.setAttachmentPosition();
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.attachments.update();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.worldObj.isRemote && this.canHaveLock() && !this.canPlayerUseContainer(player)) {
            ((ILock)this.getLock().getItem()).applyEffects(this.getLock(), this, player, EnumLockInteraction.OPEN);
        }
        return super.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canPlayerUseContainer(EntityPlayer player) {
        return super.canPlayerUseContainer(player) && (this.getLock() == null || this.canUse(player));
    }

    @Override
    protected void onBlockPlacedBeforeCheckingConnections(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBeforeCheckingConnections(player, stack);
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.getMaterial(stack, ContainerMaterial.iron);
        }
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        if (!this.canHaveMaterial()) {
            return block;
        }
        return this.getMaterial().setMaterial(block);
    }

    @Override
    public void dropContents() {
        super.dropContents();
        if (!this.canHaveLock()) {
            return;
        }
        WorldUtils.dropStackFromBlock(this, this.getLock());
        this.setLock(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        super.onBlockRenderAsItem(stack);
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.getMaterial(stack, ContainerMaterial.iron);
        }
    }

    @Override
    protected boolean isAccessible() {
        return this.getLock() == null;
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        if (!(connectable instanceof TileEntityLockable)) {
            return false;
        }
        TileEntityLockable lockable = (TileEntityLockable)connectable;
        return super.canConnect(connectable) && this.material == lockable.material && this.getLock() == null && lockable.getLock() == null;
    }

    @Override
    public ItemStack getLock() {
        return ((TileEntityLockable)this.getMainTileEntity()).getLockInternal();
    }

    @Override
    public boolean isLockValid(ItemStack lock) {
        return lock == null || lock.getItem() instanceof ILock && this.canHaveLock();
    }

    @Override
    public void setLock(ItemStack lock) {
        if (!this.isLockValid(lock)) {
            throw new InvalidParameterException("Can't set lock to " + lock + ".");
        }
        TileEntityLockable main = (TileEntityLockable)this.getMainTileEntity();
        main.setLockInternal(lock);
        main.markForUpdate();
        this.markDirty();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return this.getMainTileEntity().getPlayersUsing() > 0;
    }

    @Override
    public void useUnlocked(EntityPlayer player) {
        this.openGui(player);
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    public boolean isPowered() {
        return ((TileEntityLockable)this.getMainTileEntity()).powered;
    }

    public void setPowered(boolean powered) {
        TileEntityLockable chest = (TileEntityLockable)this.getMainTileEntity();
        if (chest != this) {
            chest.setPowered(powered);
            return;
        }
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        Block block = this.getBlockType();
        if (powered) {
            this.worldObj.scheduleBlockUpdate(this.xCoord, this.yCoord, this.zCoord, block, 10);
        }
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, block);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 1, this.yCoord, this.zCoord, block);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord - 1, this.yCoord, this.zCoord, block);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord + 1, this.zCoord, block);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord, block);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord + 1, block);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord - 1, block);
        if (this.isConnected() && this.getConnected() == ForgeDirection.EAST) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 2, this.yCoord, this.zCoord, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 1, this.yCoord + 1, this.zCoord, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 1, this.yCoord - 1, this.zCoord, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 1, this.yCoord, this.zCoord + 1, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 1, this.yCoord, this.zCoord - 1, block);
        }
        if (this.isConnected() && this.getConnected() == ForgeDirection.SOUTH) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord + 2, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord + 1, this.yCoord, this.zCoord + 1, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord - 1, this.yCoord, this.zCoord + 1, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord + 1, this.zCoord + 1, block);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord - 1, this.zCoord + 1, block);
        }
    }

    @Override
    public NBTTagCompound getDescriptionPacketData(NBTTagCompound compound) {
        ItemStack lock;
        compound = super.getDescriptionPacketData(compound);
        if (this.canHaveMaterial()) {
            compound.setString("Material", this.getMaterial().name);
        }
        if (this.canHaveLock() && (lock = this.getLockInternal()) != null) {
            compound.setTag("lock", (NBTBase)lock.writeToNBT(new NBTTagCompound()));
        }
        return compound;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.func_148857_g();
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.get(compound.getString("Material"));
        }
        if (this.canHaveLock()) {
            if (!compound.hasKey("lock")) {
                this.setLockInternal(null);
            } else {
                this.setLockInternal(ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("lock")));
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (this.canHaveMaterial()) {
            this.material = ContainerMaterial.get(compound.getString("Material"));
        }
        if (this.canHaveLock() && compound.hasKey("lock")) {
            this.setLockInternal(ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("lock")));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        ItemStack lock;
        super.writeToNBT(compound);
        if (this.canHaveMaterial()) {
            compound.setString("Material", this.getMaterial().name);
        }
        if (this.canHaveLock() && (lock = this.getLockInternal()) != null) {
            compound.setTag("lock", (NBTBase)lock.writeToNBT(new NBTTagCompound()));
        }
    }
}

