/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.ContainerCraftingStation;
import net.mcft.copy.betterstorage.inventory.InventoryCraftingStation;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCraftingStation
extends TileEntityContainer
implements IInventory,
ISidedInventory {
    public ItemStack[] crafting;
    public ItemStack[] output;
    private InventoryCraftingStation stationInventory;
    private static int[] slotsAny = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static int[] slotsBottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    @Override
    protected int getSizeContents() {
        return 18;
    }

    @Override
    public String getName() {
        return "container.betterstorage.craftingStation";
    }

    @Override
    public InventoryTileEntity makePlayerInventory() {
        this.crafting = new ItemStack[9];
        this.output = new ItemStack[9];
        this.stationInventory = new InventoryCraftingStation(this);
        return new InventoryTileEntity((TileEntityContainer)this, this.stationInventory);
    }

    @Override
    public ContainerBetterStorage createContainer(EntityPlayer player) {
        return new ContainerCraftingStation(player, (IInventory)this.getPlayerInventory());
    }

    @Override
    public void updateEntity() {
        this.stationInventory.update();
    }

    @Override
    public void dropContents() {
        for (ItemStack stack : this.crafting) {
            WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, stack);
        }
        if (this.stationInventory.outputIsReal) {
            for (ItemStack stack : this.output) {
                WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, stack);
            }
        }
        super.dropContents();
    }

    @Override
    protected boolean acceptsRedstoneSignal() {
        return true;
    }

    @Override
    protected boolean requiresStrongSignal() {
        return true;
    }

    public String getInventoryName() {
        return this.getName();
    }

    public boolean hasCustomInventoryName() {
        return !this.shouldLocalizeTitle();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getSizeInventory() {
        return this.getPlayerInventory().getSizeInventory() - 9;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getPlayerInventory().getStackInSlot(slot + 9);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.getPlayerInventory().setInventorySlotContents(slot + 9, stack);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.getPlayerInventory().decrStackSize(slot + 9, amount);
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.getPlayerInventory().isItemValidForSlot(slot + 9, stack);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.getPlayerInventory().isUseableByPlayer(player);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    @Override
    public void markDirty() {
        this.stationInventory.markDirty();
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return side == 0 ? slotsBottom : slotsAny;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return side != 0;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return side != 0 || (Boolean)GlobalConfig.enableStationAutoCraftingSetting.getValue() != false && this.stationInventory.canTake(null);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NbtUtils.readItems(this.crafting, compound.getTagList("Crafting", 10));
        if (compound.hasKey("Output")) {
            NbtUtils.readItems(this.output, compound.getTagList("Output", 10));
        }
        this.stationInventory.progress = compound.getInteger("progress");
        this.stationInventory.outputIsReal = compound.hasKey("Output");
        this.stationInventory.inputChanged();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setTag("Crafting", (NBTBase)NbtUtils.writeItems(this.crafting));
        if (this.stationInventory.outputIsReal) {
            compound.setTag("Output", (NBTBase)NbtUtils.writeItems(this.output));
        }
        compound.setInteger("progress", this.stationInventory.progress);
    }
}

