/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityConnectable
extends TileEntityContainer
implements IInventory {
    private ForgeDirection orientation = ForgeDirection.UNKNOWN;
    private ForgeDirection connected = ForgeDirection.UNKNOWN;

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    public ForgeDirection getConnected() {
        return this.connected;
    }

    public void setConnected(ForgeDirection connected) {
        this.connected = connected;
    }

    public abstract ForgeDirection[] getPossibleNeighbors();

    public boolean isConnected() {
        return this.getConnected() != ForgeDirection.UNKNOWN;
    }

    public boolean isMain() {
        ForgeDirection connected = this.getConnected();
        return !this.isConnected() || connected.offsetX + connected.offsetY + connected.offsetZ > 0;
    }

    public TileEntityConnectable getMainTileEntity() {
        if (this.isMain()) {
            return this;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        if (connectable != null) {
            return connectable;
        }
        if (BetterStorage.globalConfig.getBoolean("general.enableWarningMessages")) {
            BetterStorage.log.warn("getConnectedTileEntity() returned null in getMainTileEntity(). Location: {},{},{}", new Object[]{this.xCoord, this.yCoord, this.zCoord});
        }
        return this;
    }

    public TileEntityConnectable getConnectedTileEntity() {
        if (!this.isConnected()) {
            return null;
        }
        ForgeDirection connected = this.getConnected();
        int x = this.xCoord + connected.offsetX;
        int y = this.yCoord + connected.offsetY;
        int z = this.zCoord + connected.offsetZ;
        return WorldUtils.get((IBlockAccess)this.worldObj, x, y, z, TileEntityConnectable.class);
    }

    public boolean canConnect(TileEntityConnectable connectable) {
        return connectable != null && this.getBlockType() == connectable.getBlockType() && this.getOrientation() == connectable.getOrientation() && !this.isConnected() && !connectable.isConnected();
    }

    public void checkForConnections() {
        if (this.worldObj.isRemote) {
            return;
        }
        TileEntityConnectable connectableFound = null;
        ForgeDirection dirFound = ForgeDirection.UNKNOWN;
        for (ForgeDirection dir : this.getPossibleNeighbors()) {
            int x = this.xCoord + dir.offsetX;
            int y = this.yCoord + dir.offsetY;
            int z = this.zCoord + dir.offsetZ;
            TileEntityConnectable connectable = WorldUtils.get((IBlockAccess)this.worldObj, x, y, z, TileEntityConnectable.class);
            if (!this.canConnect(connectable)) continue;
            if (connectableFound != null) {
                return;
            }
            connectableFound = connectable;
            dirFound = dir;
        }
        if (connectableFound == null) {
            return;
        }
        this.setConnected(dirFound);
        connectableFound.setConnected(dirFound.getOpposite());
        this.markForUpdate();
        connectableFound.markForUpdate();
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        this.setConnected(ForgeDirection.UNKNOWN);
        if (connectable != null) {
            connectable.setConnected(ForgeDirection.UNKNOWN);
            connectable.markForUpdate();
        } else if (BetterStorage.globalConfig.getBoolean("general.enableWarningMessages")) {
            BetterStorage.log.warn("getConnectedTileEntity() returned null in disconnect(). Location: {},{},{}", new Object[]{this.xCoord, this.yCoord, this.zCoord});
        }
    }

    protected abstract String getConnectableName();

    @Override
    public final String getName() {
        return this.getConnectableName() + (this.isConnected() ? "Large" : "");
    }

    @Override
    protected boolean doesSyncPlayers() {
        return true;
    }

    @Override
    public InventoryTileEntity getPlayerInventory() {
        TileEntityConnectable connected = this.getConnectedTileEntity();
        if (connected != null) {
            return new InventoryTileEntity((TileEntityContainer)this, this.isMain() ? this : connected, this.isMain() ? connected : this);
        }
        return super.getPlayerInventory();
    }

    @Override
    public final void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.onBlockPlacedBeforeCheckingConnections(player, stack);
        this.checkForConnections();
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        this.disconnect();
    }

    protected void onBlockPlacedBeforeCheckingConnections(EntityLivingBase player, ItemStack stack) {
        this.setOrientation(DirectionUtils.getOrientation((Entity)player).getOpposite());
    }

    protected boolean isAccessible() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        double x = (double)this.xCoord + 0.5;
        double y = (double)this.yCoord + 0.5;
        double z = (double)this.zCoord + 0.5;
        if (this.isConnected()) {
            if (!this.isMain()) {
                return;
            }
            TileEntityConnectable connectable = this.getConnectedTileEntity();
            if (connectable != null) {
                x = (x + (double)connectable.xCoord + 0.5) / 2.0;
                z = (z + (double)connectable.zCoord + 0.5) / 2.0;
                this.lidAngle = Math.max(this.lidAngle, connectable.lidAngle);
            }
        }
        float pitch = this.worldObj.rand.nextFloat() * 0.1f + 0.9f;
        if (this.lidAngle > 0.0f && this.prevLidAngle == 0.0f) {
            this.worldObj.playSoundEffect(x, y, z, "random.chestopen", 0.5f, pitch);
        }
        if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
            this.worldObj.playSoundEffect(x, y, z, "random.chestclosed", 0.5f, pitch);
        }
    }

    public String getInventoryName() {
        return this.getName();
    }

    public boolean hasCustomInventoryName() {
        return !this.shouldLocalizeTitle();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getSizeInventory() {
        return this.isAccessible() ? this.getPlayerInventory().getSizeInventory() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.isAccessible() ? this.getPlayerInventory().getStackInSlot(slot) : null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (this.isAccessible()) {
            this.getPlayerInventory().setInventorySlotContents(slot, stack);
        }
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.isAccessible() ? this.getPlayerInventory().decrStackSize(slot, amount) : null;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.isAccessible() ? this.getPlayerInventory().isItemValidForSlot(slot, stack) : false;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.isAccessible() ? this.getPlayerInventory().isUseableByPlayer(player) : false;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void openInventory() {
        if (this.isAccessible()) {
            this.getPlayerInventory().openInventory();
        }
    }

    public void closeInventory() {
        if (this.isAccessible()) {
            this.getPlayerInventory().closeInventory();
        }
    }

    @Override
    public void markDirty() {
        if (this.isAccessible()) {
            this.getPlayerInventory().markDirty();
        }
    }

    public NBTTagCompound getDescriptionPacketData(NBTTagCompound compound) {
        compound.setByte("orientation", (byte)this.getOrientation().ordinal());
        compound.setByte("connected", (byte)this.getConnected().ordinal());
        return compound;
    }

    public Packet getDescriptionPacket() {
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, this.getDescriptionPacketData(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.setOrientation(ForgeDirection.getOrientation((int)compound.getByte("orientation")));
        this.setConnected(ForgeDirection.getOrientation((int)compound.getByte("connected")));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.setOrientation(ForgeDirection.getOrientation((int)compound.getByte("orientation")));
        this.setConnected(ForgeDirection.getOrientation((int)compound.getByte("connected")));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setByte("orientation", (byte)this.getOrientation().ordinal());
        compound.setByte("connected", (byte)this.getConnected().ordinal());
    }
}

