/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.inventory.InventoryCardboardBox;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityCardboardBox
extends TileEntityContainer {
    public int uses = 1;
    public int color = -1;
    public boolean destroyed = false;

    protected boolean canPickUp() {
        return this.uses >= 0;
    }

    protected ItemStack getItemDropped() {
        return new ItemStack((Block)BetterStorageTiles.cardboardBox);
    }

    protected void onItemDropped(ItemStack stack) {
        if (ItemCardboardBox.getUses() > 0) {
            StackUtils.set(stack, this.uses, "uses");
        }
        if (this.color >= 0) {
            StackUtils.set(stack, this.color, "display", "color");
        }
        if (this.getCustomTitle() != null) {
            stack.setStackDisplayName(this.getCustomTitle());
        }
    }

    @Override
    public String getName() {
        return "container.betterstorage.cardboardBox";
    }

    @Override
    public int getRows() {
        return ItemCardboardBox.getRows();
    }

    @Override
    public InventoryTileEntity makePlayerInventory() {
        return new InventoryTileEntity((TileEntityContainer)this, new InventoryCardboardBox(this.contents));
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        int maxUses;
        super.onBlockPlaced(player, stack);
        if (StackUtils.has(stack, "Items")) {
            ItemStack[] itemContents = StackUtils.getStackContents(stack, this.contents.length);
            System.arraycopy(itemContents, 0, this.contents, 0, itemContents.length);
        }
        if ((maxUses = ItemCardboardBox.getUses()) > 0) {
            this.uses = StackUtils.get(stack, maxUses, "uses");
        }
        this.color = StackUtils.get(stack, -1, "display", "color");
    }

    @Override
    public void onBlockDestroyed() {
        if (!this.canPickUp() || this.destroyed) {
            return;
        }
        boolean empty = StackUtils.isEmpty(this.contents);
        if (!empty) {
            --this.uses;
            if (!this.canPickUp()) {
                this.destroyed = true;
                this.dropContents();
                return;
            }
        }
        ItemStack stack = this.getItemDropped();
        if (!empty) {
            StackUtils.setStackContents(stack, this.contents);
        }
        this.onItemDropped(stack);
        if (!empty || !this.brokenInCreative) {
            WorldUtils.dropStackFromBlock(this, stack);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.color >= 0) {
            compound.setInteger("color", this.color);
        }
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.color = compound.hasKey("color") ? compound.getInteger("color") : -1;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.uses = compound.hasKey("uses") ? compound.getInteger("uses") : ItemCardboardBox.getUses();
        this.color = compound.hasKey("color") ? compound.getInteger("color") : -1;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (ItemCardboardBox.getUses() > 0) {
            compound.setInteger("uses", this.uses);
        }
        if (this.color >= 0) {
            compound.setInteger("color", this.color);
        }
    }
}

