/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MovingObjectPosition;

public class TileEntityBackpack
extends TileEntityContainer {
    private int despawnTime = -1;
    public ItemStack stack;
    public boolean equipped = false;

    public void equip(EntityLivingBase carrier) {
        this.equipped = true;
        ItemBackpack.setBackpack(carrier, this.stack, this.contents);
    }

    public void unequip(EntityLivingBase carrier, boolean despawn) {
        if (this.worldObj.isRemote) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(carrier);
        if (backpackData.contents != null) {
            System.arraycopy(backpackData.contents, 0, this.contents, 0, Math.min(this.contents.length, backpackData.contents.length));
            backpackData.contents = null;
        }
        if (despawn) {
            this.despawnTime = 0;
        }
    }

    @Override
    public String getName() {
        return "container.betterstorage.backpack";
    }

    @Override
    public int getRows() {
        return BetterStorage.globalConfig.getInteger("general.backpackRows");
    }

    @Override
    protected boolean doesSyncPlayers() {
        return true;
    }

    @Override
    public boolean onBlockBreak(EntityPlayer player) {
        if (!this.worldObj.isRemote && player.isSneaking() && ItemBackpack.canEquipBackpack(player)) {
            this.equip((EntityLivingBase)player);
        }
        return super.onBlockBreak(player);
    }

    @Override
    public void dropContents() {
        if (this.equipped) {
            return;
        }
        if (!this.brokenInCreative) {
            WorldUtils.dropStackFromBlock(this, this.stack);
        }
        super.dropContents();
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        return ItemStack.copyItemStack((ItemStack)this.stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    protected float getLidSpeed() {
        return 0.2f;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        double x = (double)this.xCoord + 0.5;
        double y = (double)this.yCoord + 0.5;
        double z = (double)this.zCoord + 0.5;
        String sound = Block.soundTypeSnow.getStepResourcePath();
        if (this.lidAngle > 0.0f && this.prevLidAngle <= 0.0f) {
            this.worldObj.playSoundEffect(x, y, z, sound, 1.0f, 0.6f);
        }
        if (this.lidAngle < 0.2f && this.prevLidAngle >= 0.2f) {
            this.worldObj.playSoundEffect(x, y, z, sound, 0.8f, 0.4f);
        }
        if (this.despawnTime < 0) {
            return;
        }
        if (this.despawnTime++ > 6000) {
            this.equipped = true;
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
        } else if (this.despawnTime % 40 == 0 && this.worldObj.getClosestPlayer(x, y, z, 24.0) != null) {
            this.despawnTime = -1;
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("stack"));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("stack"));
        this.despawnTime = compound.getInteger("despawnTime");
        if (this.despawnTime == 0) {
            this.despawnTime = -1;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setTag("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
        compound.setInteger("despawnTime", this.despawnTime);
    }
}

