/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.mcft.copy.betterstorage.api.crate.ICrateStorage;
import net.mcft.copy.betterstorage.api.crate.ICrateWatcher;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.ContainerCrate;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.inventory.InventoryCratePlayerView;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrate
extends TileEntityContainer
implements IInventory,
ICrateStorage,
ICrateWatcher {
    private static final ForgeDirection[] sideDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final int slotsPerCrate = 18;
    private CratePileData data;
    private int id = -1;
    private boolean watcherRegistered = false;

    public int getID() {
        return this.id;
    }

    public CratePileData getPileData() {
        if (this.worldObj.isRemote) {
            throw new IllegalStateException("Can't be called client-side.");
        }
        if (this.data == null) {
            CratePileCollection collection = CratePileCollection.getCollection(this.worldObj);
            if (this.id == -1) {
                this.setPileData(collection.createCratePile(), true);
            } else {
                this.setPileData(collection.getCratePile(this.id), false);
            }
        }
        return this.data;
    }

    private void setPileData(CratePileData data, boolean addCrate) {
        if (this.data != null) {
            this.data.removeCrate(this);
        }
        this.data = data;
        if (data != null) {
            this.id = data.id;
            this.markForUpdate();
            if (addCrate) {
                data.addCrate(this);
            }
        } else {
            this.id = -1;
        }
    }

    private void checkPileConnections(CratePileData data) {
        int x = this.xCoord;
        int y = this.yCoord;
        int z = this.zCoord;
        TileEntityCrate crateAbove = WorldUtils.get((IBlockAccess)this.worldObj, x, y + 1, z, TileEntityCrate.class);
        if (crateAbove != null && crateAbove.data == data) {
            this.worldObj.setBlockToAir(x, y + 1, z);
            crateAbove.dropItem(new ItemStack((Block)BetterStorageTiles.crate));
        }
        if (data.getNumCrates() <= 0 || y != data.getRegion().minY) {
            return;
        }
        List<HashSet<TileEntityCrate>> crateSets = this.getCrateSets(x, y, z, data);
        if (crateSets.size() <= 1) {
            return;
        }
        for (int i = 1; i < crateSets.size(); ++i) {
            HashSet<TileEntityCrate> set = crateSets.get(i);
            CratePileData newPileData = data.collection.createCratePile();
            int numCrates = set.size();
            for (TileEntityCrate newPileCrate : set) {
                newPileCrate.setPileData(newPileData, true);
                while ((newPileCrate = WorldUtils.get((IBlockAccess)this.worldObj, newPileCrate.xCoord, newPileCrate.yCoord + 1, newPileCrate.zCoord, TileEntityCrate.class)) != null) {
                    newPileCrate.setPileData(newPileData, true);
                    ++numCrates;
                }
            }
            int count = numCrates * data.getOccupiedSlots() / (data.getNumCrates() + numCrates);
            for (ItemStack stack : data.getContents().getRandomStacks(count)) {
                data.removeItems(stack);
                newPileData.addItems(stack);
            }
        }
        data.trimMap();
    }

    private List<HashSet<TileEntityCrate>> getCrateSets(int x, int y, int z, CratePileData data) {
        ArrayList<HashSet<TileEntityCrate>> crateSets = new ArrayList<HashSet<TileEntityCrate>>();
        int checkedCrates = 0;
        block0: for (ForgeDirection dir : sideDirections) {
            int nx = x + dir.offsetX;
            int nz = z + dir.offsetZ;
            TileEntityCrate neighborCrate = WorldUtils.get((IBlockAccess)this.worldObj, nx, y, nz, TileEntityCrate.class);
            if (neighborCrate == null || neighborCrate.data != data) continue;
            for (HashSet hashSet : crateSets) {
                if (!hashSet.contains(neighborCrate)) continue;
                continue block0;
            }
            HashSet<TileEntityCrate> set = new HashSet<TileEntityCrate>();
            set.add(neighborCrate);
            for (ForgeDirection ndir : sideDirections) {
                this.checkConnections(nx + ndir.offsetX, y, nz + ndir.offsetZ, data, set);
            }
            crateSets.add(set);
            if ((checkedCrates += set.size()) >= data.getNumCrates()) break;
        }
        return crateSets;
    }

    private void checkConnections(int x, int y, int z, CratePileData data, HashSet<TileEntityCrate> set) {
        TileEntityCrate crate = WorldUtils.get((IBlockAccess)this.worldObj, x, y, z, TileEntityCrate.class);
        if (crate == null || data != crate.data || set.contains(crate)) {
            return;
        }
        set.add(crate);
        for (ForgeDirection ndir : sideDirections) {
            this.checkConnections(x + ndir.offsetX, y, z + ndir.offsetZ, data, set);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote || this.data != null) {
            return;
        }
        if (!this.isInvalid()) {
            this.getPileData();
        }
    }

    public void attemptConnect(ForgeDirection side) {
        if (this.worldObj.isRemote || side == ForgeDirection.UP) {
            return;
        }
        int x = this.xCoord + side.offsetX;
        int y = this.yCoord + side.offsetY;
        int z = this.zCoord + side.offsetZ;
        TileEntityCrate crateClicked = WorldUtils.get((IBlockAccess)this.worldObj, x, y, z, TileEntityCrate.class);
        if (crateClicked == null) {
            return;
        }
        CratePileData pileData = crateClicked.getPileData();
        if (pileData.canAdd(this)) {
            this.setPileData(pileData, true);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.worldObj.isRemote) {
            return;
        }
        CratePileData data = this.getPileData();
        if (this.watcherRegistered) {
            data.removeWatcher(this);
        }
        this.setPileData(null, false);
        this.dropOverflowContents(data);
        this.checkPileConnections(data);
    }

    private void dropItem(ItemStack stack) {
        WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, stack);
    }

    private void dropItems(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            this.dropItem(stack);
        }
    }

    private void dropOverflowContents(CratePileData data) {
        int amount = -data.getFreeSlots();
        if (amount <= 0) {
            return;
        }
        List<ItemStack> items = data.getContents().getRandomStacks(amount);
        for (ItemStack stack : items) {
            data.removeItems(stack);
        }
        this.dropItems(items);
    }

    @Override
    protected int getSizeContents() {
        return 0;
    }

    @Override
    public String getName() {
        return "container.betterstorage.crate";
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (!this.canPlayerUseContainer(player)) {
            return;
        }
        PlayerUtils.openGui(player, this.getName(), this.getColumns(), 2 * Math.min(this.data.getNumCrates(), 3), this.getContainerTitle(), this.createContainer(player));
    }

    @Override
    public ContainerBetterStorage createContainer(EntityPlayer player) {
        return new ContainerCrate(player, new InventoryCratePlayerView(this));
    }

    @Override
    protected int getComparatorSignalStengthInternal() {
        if (this.worldObj.isRemote) {
            return 0;
        }
        CratePileData data = this.getPileData();
        return data.getOccupiedSlots() > 0 ? 1 + data.getOccupiedSlots() * 14 / data.getCapacity() : 0;
    }

    @Override
    protected void markComparatorAccessed() {
        super.markComparatorAccessed();
        if (!this.watcherRegistered && !this.worldObj.isRemote) {
            this.getPileData().addWatcher(this);
            this.watcherRegistered = true;
        }
    }

    @Override
    protected void comparatorUpdateAndReset() {
        super.comparatorUpdateAndReset();
        if (this.watcherRegistered && !this.hasComparatorAccessed()) {
            this.getPileData().removeWatcher(this);
            this.watcherRegistered = false;
        }
    }

    @Override
    public void onCrateItemsModified(ItemStack stack) {
        this.markContentsChanged();
    }

    public String getInventoryName() {
        return this.getName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getSizeInventory() {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return 0;
        }
        if (this.worldObj.isRemote) {
            return 1;
        }
        return this.getPileData().blockView.getSizeInventory();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return false;
        }
        return this.getPileData().blockView.isItemValidForSlot(slot, stack);
    }

    public ItemStack getStackInSlot(int slot) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        return this.getPileData().blockView.getStackInSlot(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            this.getPileData().blockView.setInventorySlotContents(slot, stack);
            this.markDirty();
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        return this.getPileData().blockView.getStackInSlotOnClosing(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        this.markDirty();
        return this.getPileData().blockView.decrStackSize(slot, amount);
    }

    @Override
    public void markDirty() {
        if (((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            this.getPileData().blockView.markDirty();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return false;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
        this.getPileData().blockView.openInventory();
    }

    public void closeInventory() {
        this.getPileData().blockView.closeInventory();
    }

    private static boolean isEnabled() {
        return (Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue();
    }

    @Override
    public Object getCrateIdentifier() {
        return this.getPileData();
    }

    @Override
    public int getCapacity() {
        return TileEntityCrate.isEnabled() ? this.getPileData().getCapacity() : 0;
    }

    @Override
    public int getOccupiedSlots() {
        return TileEntityCrate.isEnabled() ? this.getPileData().getOccupiedSlots() : 0;
    }

    @Override
    public int getUniqueItems() {
        return TileEntityCrate.isEnabled() ? this.getPileData().getUniqueItems() : 0;
    }

    @Override
    public Iterable<ItemStack> getContents() {
        return TileEntityCrate.isEnabled() ? this.getPileData().getContents().getItems() : Collections.EMPTY_LIST;
    }

    @Override
    public Iterable<ItemStack> getRandomStacks() {
        return TileEntityCrate.isEnabled() ? this.getPileData().getContents().getRandomStacks() : Collections.EMPTY_LIST;
    }

    @Override
    public int getItemCount(ItemStack identifier) {
        return TileEntityCrate.isEnabled() ? this.getPileData().getContents().get(new ItemIdentifier(identifier)) : 0;
    }

    @Override
    public int getSpaceForItem(ItemStack identifier) {
        return TileEntityCrate.isEnabled() ? this.getPileData().getSpaceForItem(identifier) : 0;
    }

    @Override
    public ItemStack insertItems(ItemStack stack) {
        return TileEntityCrate.isEnabled() ? this.getPileData().addItems(stack) : stack;
    }

    @Override
    public ItemStack extractItems(ItemStack identifier, int amount) {
        return TileEntityCrate.isEnabled() ? this.getPileData().removeItems(new ItemIdentifier(identifier), amount) : null;
    }

    @Override
    public void registerCrateWatcher(ICrateWatcher watcher) {
        if (TileEntityCrate.isEnabled()) {
            this.getPileData().addWatcher(watcher);
        }
    }

    @Override
    public void unregisterCrateWatcher(ICrateWatcher watcher) {
        if (TileEntityCrate.isEnabled()) {
            this.getPileData().removeWatcher(watcher);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setInteger("crateId", this.id);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.id = packet.func_148857_g().getInteger("crateId");
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.id = compound.getInteger("crateId");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("crateId", this.id);
        this.getPileData().save();
    }
}

