/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.util.HashSet;
import java.util.Set;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.crate.ICrateWatcher;
import net.mcft.copy.betterstorage.inventory.InventoryCrateBlockView;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.misc.Region;
import net.mcft.copy.betterstorage.tile.crate.CrateItems;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.tile.crate.CratePileMap;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CratePileData {
    private static final int maxCratePileSize = 8192;
    public final CratePileCollection collection;
    public final int id;
    private CrateItems contents = new CrateItems();
    private int numCrates = 0;
    private boolean destroyed = false;
    private boolean dirty = false;
    private CratePileMap map;
    private Set<ICrateWatcher> watchers = new HashSet<ICrateWatcher>();
    public final InventoryCrateBlockView blockView = new InventoryCrateBlockView(this);

    public CrateItems getContents() {
        return this.contents;
    }

    public int getNumCrates() {
        return this.numCrates;
    }

    public int getCapacity() {
        return this.numCrates * 18;
    }

    public int getUniqueItems() {
        return this.contents.getUniqueItems();
    }

    public int getOccupiedSlots() {
        return this.contents.getTotalStacks();
    }

    public int getFreeSlots() {
        return this.getCapacity() - this.getOccupiedSlots();
    }

    public Region getRegion() {
        return this.map.region;
    }

    public int getCenterX() {
        return (this.map.region.minX + this.map.region.maxX) / 2;
    }

    public int getCenterY() {
        return (this.map.region.minY + this.map.region.maxY) / 2;
    }

    public int getCenterZ() {
        return (this.map.region.minZ + this.map.region.maxZ) / 2;
    }

    public CratePileData(CratePileCollection collection, int id, int numCrates) {
        this.collection = collection;
        this.id = id;
        this.numCrates = numCrates;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        if (this.isDirty() || this.destroyed) {
            return;
        }
        this.dirty = true;
        if (BetterStorage.globalConfig.getBoolean("general.crateDebugMessages")) {
            BetterStorage.log.info(String.format("[CRATE DEBUG] Marked crate pile at [%s,%s,%s] as dirty.", this.getCenterX(), this.getCenterY(), this.getCenterZ()));
        }
    }

    public void save() {
        if (!this.isDirty()) {
            return;
        }
        this.collection.save(this);
        this.dirty = false;
        if (BetterStorage.globalConfig.getBoolean("general.crateDebugMessages")) {
            BetterStorage.log.info(String.format("[CRATE DEBUG] Saved crate pile at [%s,%s,%s].", this.getCenterX(), this.getCenterY(), this.getCenterZ()));
        }
    }

    public void remove() {
        this.destroyed = true;
        this.collection.removeCratePile(this);
        if (BetterStorage.globalConfig.getBoolean("general.crateDebugMessages")) {
            BetterStorage.log.info(String.format("[CRATE DEBUG] Removed empty crate pile at [%s,%s,%s].", this.getCenterX(), this.getCenterY(), this.getCenterZ()));
        }
    }

    public boolean canAdd(TileEntityCrate crate) {
        return !(this.map == null || this.numCrates >= 8192 || !this.map.region.contains(crate) && !this.canExpand(crate) || !this.map.get(crate.xCoord, crate.yCoord - 1, crate.zCoord) && crate.yCoord != this.map.region.minY);
    }

    private boolean canExpand(TileEntityCrate crate) {
        int volume = this.map.region.volume();
        if (this.numCrates < Math.min((int)((double)volume * 0.8), volume - 5)) {
            return false;
        }
        if (crate.xCoord < this.map.region.minX || crate.xCoord > this.map.region.maxX) {
            int maxDiff;
            int n = maxDiff = this.map.region.height() == 1 ? 1 : 3;
            if (this.map.region.width() >= maxDiff + Math.min(this.map.region.height(), this.map.region.depth())) {
                return false;
            }
        } else if (crate.zCoord < this.map.region.minZ || crate.zCoord > this.map.region.maxZ) {
            int maxDiff;
            int n = maxDiff = this.map.region.width() == 1 ? 1 : 3;
            if (this.map.region.height() >= maxDiff + Math.min(this.map.region.width(), this.map.region.depth())) {
                return false;
            }
        } else if (crate.yCoord < this.map.region.minY || crate.yCoord > this.map.region.maxY) {
            int maxDiff;
            int n = maxDiff = this.map.region.width() == 1 || this.map.region.height() == 1 ? 1 : 4;
            if (this.map.region.depth() >= maxDiff + Math.min(this.map.region.width(), this.map.region.height())) {
                return false;
            }
        }
        return true;
    }

    public void trimMap() {
        if (this.map != null) {
            this.map.trim();
        }
    }

    public void addCrate(TileEntityCrate crate) {
        if (this.numCrates == 0) {
            this.map = new CratePileMap(crate);
        }
        this.map.add(crate);
        ++this.numCrates;
        this.markDirty();
    }

    public void removeCrate(TileEntityCrate crate) {
        if (--this.numCrates > 0) {
            if (this.map != null) {
                this.map.remove(crate);
            }
            this.markDirty();
        } else {
            this.remove();
        }
    }

    public boolean hasCrate(int x, int y, int z) {
        return this.map.get(x, y, z);
    }

    public ItemStack addItems(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack overflow = null;
        int space = this.getSpaceForItem(stack);
        if (space > 0) {
            if (space < stack.stackSize) {
                overflow = stack.splitStack(stack.stackSize - space);
            }
            ItemIdentifier item = new ItemIdentifier(stack);
            this.getContents().set(item, this.getContents().get(item) + stack.stackSize);
            for (ICrateWatcher watcher : this.watchers) {
                watcher.onCrateItemsModified(stack);
            }
        } else {
            overflow = stack;
        }
        this.markDirty();
        return overflow;
    }

    public ItemStack removeItems(ItemIdentifier item, int amount) {
        int currentAmount = this.getContents().get(item);
        if ((amount = Math.min(amount, currentAmount)) <= 0) {
            return null;
        }
        this.getContents().set(item, currentAmount - amount);
        ItemStack removedStack = item.createStack(-amount);
        for (ICrateWatcher watcher : this.watchers) {
            watcher.onCrateItemsModified(removedStack);
        }
        this.markDirty();
        return item.createStack(amount);
    }

    public ItemStack removeItems(ItemStack stack) {
        return this.removeItems(new ItemIdentifier(stack), stack.stackSize);
    }

    public int getSpaceForItem(ItemIdentifier item) {
        if (item == null) {
            return 0;
        }
        int amount = this.getContents().get(item);
        ItemStack testStack = item.createStack(amount);
        int maxStackSize = testStack.getMaxStackSize();
        int space = this.getFreeSlots() * maxStackSize;
        if (amount > 0) {
            space += StackUtils.calcNumStacks(testStack) * maxStackSize - testStack.stackSize;
        }
        return space;
    }

    public int getSpaceForItem(ItemStack item) {
        if (item == null) {
            return 0;
        }
        return this.getSpaceForItem(new ItemIdentifier(item));
    }

    public void addWatcher(ICrateWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void removeWatcher(ICrateWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setShort("numCrates", (short)this.getNumCrates());
        NBTTagList stacks = new NBTTagList();
        for (ItemStack stack : this.getContents().getItems()) {
            NBTTagCompound stackCompound = new NBTTagCompound();
            stackCompound.setShort("id", (short)Item.getIdFromItem((Item)stack.getItem()));
            stackCompound.setInteger("Count", stack.stackSize);
            stackCompound.setShort("Damage", (short)StackUtils.getRealItemDamage(stack));
            if (stack.hasTagCompound()) {
                stackCompound.setTag("tag", (NBTBase)stack.getTagCompound());
            }
            stacks.appendTag((NBTBase)stackCompound);
        }
        compound.setTag("stacks", (NBTBase)stacks);
        if (this.map != null) {
            compound.setTag("map", (NBTBase)this.map.toCompound());
        }
        return compound;
    }

    public static CratePileData fromCompound(CratePileCollection collection, int crateId, NBTTagCompound compound) {
        short numCrates = compound.getShort("numCrates");
        CratePileData pileData = new CratePileData(collection, crateId, numCrates);
        NBTTagList stacks = compound.getTagList("stacks", 10);
        for (int j = 0; j < stacks.tagCount(); ++j) {
            NBTTagCompound stackCompound = stacks.getCompoundTagAt(j);
            Item item = Item.getItemById((int)stackCompound.getShort("id"));
            int count = stackCompound.getInteger("Count");
            short damage = stackCompound.getShort("Damage");
            ItemStack stack = new ItemStack(item, count, (int)damage);
            if (stackCompound.hasKey("tag")) {
                stack.stackTagCompound = stackCompound.getCompoundTag("tag");
            }
            if (stack.getItem() == null) continue;
            pileData.getContents().set(new ItemIdentifier(stack), stack.stackSize);
        }
        if (compound.hasKey("map")) {
            pileData.map = CratePileMap.fromCompound(compound.getCompoundTag("map"));
        }
        return pileData;
    }
}

