/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityCardboardBox;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileCardboardBox
extends TileContainerBetterStorage {
    private IIcon sideIcon;

    public TileCardboardBox() {
        super(Material.wood);
        this.setHardness(0.8f);
        this.setStepSound(soundTypeWood);
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemCardboardBox.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("betterstorage:" + this.getTileName());
        this.sideIcon = iconRegister.registerIcon("betterstorage:" + this.getTileName() + "_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return side < 2 ? this.blockIcon : this.sideIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        TileEntityCardboardBox box = WorldUtils.get(world, x, y, z, TileEntityCardboardBox.class);
        return box != null && box.color >= 0 ? box.color : 7360560;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityCardboardBox();
    }
}

