/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.addon.Addon;
import net.mcft.copy.betterstorage.api.stand.ArmorStandEquipHandler;
import net.mcft.copy.betterstorage.api.stand.BetterStorageArmorStand;
import net.mcft.copy.betterstorage.api.stand.EnumArmorStandRegion;
import net.mcft.copy.betterstorage.attachment.Attachment;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.client.model.ModelBackpackArmor;
import net.mcft.copy.betterstorage.client.model.ModelCluckington;
import net.mcft.copy.betterstorage.client.renderer.BetterStorageRenderingHandler;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererBackpack;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererCardboardBox;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererContainer;
import net.mcft.copy.betterstorage.client.renderer.RenderFrienderman;
import net.mcft.copy.betterstorage.client.renderer.TileEntityArmorStandRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityBackpackRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityLockableDoorRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityLockerRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityPresentRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityReinforcedChestRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileLockableDoorRenderingHandler;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.entity.EntityCluckington;
import net.mcft.copy.betterstorage.entity.EntityFrienderman;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.misc.handlers.KeyBindingHandler;
import net.mcft.copy.betterstorage.proxy.CommonProxy;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockableDoor;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLocker;
import net.mcft.copy.betterstorage.tile.entity.TileEntityPresent;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedChest;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedLocker;
import net.mcft.copy.betterstorage.tile.stand.TileArmorStand;
import net.mcft.copy.betterstorage.tile.stand.TileEntityArmorStand;
import net.mcft.copy.betterstorage.tile.stand.VanillaArmorStandRenderHandler;
import net.mcft.copy.betterstorage.utils.ReflectionUtils;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderChicken;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static int reinforcedChestRenderId;
    public static int lockerRenderId;
    public static int armorStandRenderId;
    public static int backpackRenderId;
    public static int reinforcedLockerRenderId;
    public static int lockableDoorRenderId;
    public static int presentRenderId;
    public static final Map<Class<? extends TileEntity>, BetterStorageRenderingHandler> renderingHandlers;

    @Override
    public void initialize() {
        super.initialize();
        new KeyBindingHandler();
        this.registerRenderers();
    }

    @Override
    protected void registerArmorStandHandlers() {
        super.registerArmorStandHandlers();
        BetterStorageArmorStand.registerRenderHandler(new VanillaArmorStandRenderHandler());
    }

    private void registerRenderers() {
        ClientProxy.registerItemRenderer((Item)BetterStorageItems.itemBackpack, (IItemRenderer)new ItemRendererBackpack(TileEntityBackpack.class));
        ClientProxy.registerItemRenderer((Item)BetterStorageItems.itemEnderBackpack, (IItemRenderer)new ItemRendererBackpack(TileEntityBackpack.class));
        ClientProxy.registerItemRenderer(BetterStorageTiles.reinforcedChest, (IItemRenderer)new ItemRendererContainer(TileEntityReinforcedChest.class));
        ClientProxy.registerItemRenderer(BetterStorageTiles.reinforcedLocker, (IItemRenderer)new ItemRendererContainer(TileEntityReinforcedLocker.class));
        ClientProxy.registerItemRenderer(BetterStorageTiles.cardboardBox, (IItemRenderer)new ItemRendererCardboardBox(BetterStorageTiles.cardboardBox));
        ClientProxy.registerItemRenderer(BetterStorageTiles.present, (IItemRenderer)new ItemRendererContainer(TileEntityPresent.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityFrienderman.class, (Render)new RenderFrienderman());
        RenderingRegistry.registerEntityRenderingHandler(EntityCluckington.class, (Render)new RenderChicken((ModelBase)new ModelCluckington(), 0.4f));
        reinforcedChestRenderId = ClientProxy.registerTileEntityRenderer(TileEntityReinforcedChest.class, new TileEntityReinforcedChestRenderer());
        lockerRenderId = ClientProxy.registerTileEntityRenderer(TileEntityLocker.class, new TileEntityLockerRenderer());
        armorStandRenderId = ClientProxy.registerTileEntityRenderer(TileEntityArmorStand.class, new TileEntityArmorStandRenderer(), false, 0.0f, 1.0f, 0.0f);
        backpackRenderId = ClientProxy.registerTileEntityRenderer(TileEntityBackpack.class, new TileEntityBackpackRenderer(), true, -160.0f, 1.5f, 0.14f);
        reinforcedLockerRenderId = ClientProxy.registerTileEntityRenderer(TileEntityReinforcedLocker.class, new TileEntityLockerRenderer());
        lockableDoorRenderId = ClientProxy.registerTileEntityRenderer(TileEntityLockableDoor.class, new TileEntityLockableDoorRenderer());
        presentRenderId = ClientProxy.registerTileEntityRenderer(TileEntityPresent.class, new TileEntityPresentRenderer());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new TileLockableDoorRenderingHandler());
        Addon.registerRenderersAll();
    }

    public static void registerItemRenderer(Block block, IItemRenderer renderer) {
        if (block != null) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.getItemFromBlock((Block)block), (IItemRenderer)renderer);
        }
    }

    public static void registerItemRenderer(Item item, IItemRenderer renderer) {
        if (item != null) {
            MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)renderer);
        }
    }

    public static int registerTileEntityRenderer(Class<? extends TileEntity> tileEntityClass, TileEntitySpecialRenderer renderer, boolean render3dInInventory, float rotation, float scale, float yOffset) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileEntityClass, (TileEntitySpecialRenderer)renderer);
        BetterStorageRenderingHandler renderingHandler = new BetterStorageRenderingHandler(tileEntityClass, renderer, render3dInInventory, rotation, scale, yOffset);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderingHandler);
        renderingHandlers.put(tileEntityClass, renderingHandler);
        return renderingHandler.getRenderId();
    }

    public static int registerTileEntityRenderer(Class<? extends TileEntity> tileEntityClass, TileEntitySpecialRenderer renderer) {
        return ClientProxy.registerTileEntityRenderer(tileEntityClass, renderer, true, 90.0f, 1.0f, 0.0f);
    }

    @SubscribeEvent
    public void drawBlockHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.player;
        World world = player.worldObj;
        MovingObjectPosition target = WorldUtils.rayTrace(player, event.partialTicks);
        if (target == null || target.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        int x = target.blockX;
        int y = target.blockY;
        int z = target.blockZ;
        AxisAlignedBB box = null;
        Block block = world.getBlock(x, y, z);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (block instanceof TileArmorStand) {
            box = this.getArmorStandHighlightBox(player, world, x, y, z, target.hitVec);
        } else if (block == Blocks.iron_door) {
            box = this.getIronDoorHightlightBox(player, world, x, y, z, target.hitVec, block);
        } else if (tileEntity instanceof IHasAttachments) {
            box = this.getAttachmentPointsHighlightBox(player, tileEntity, target);
        }
        if (box == null) {
            return;
        }
        double xOff = player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)event.partialTicks;
        double yOff = player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)event.partialTicks;
        double zOff = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)event.partialTicks;
        box.offset(-xOff, -yOff, -zOff);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        RenderGlobal.drawOutlinedBoundingBox((AxisAlignedBB)box, (int)-1);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        event.setCanceled(true);
    }

    private AxisAlignedBB getArmorStandHighlightBox(EntityPlayer player, World world, int x, int y, int z, Vec3 hitVec) {
        TileEntityArmorStand armorStand;
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata > 0) {
            --y;
        }
        if ((armorStand = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityArmorStand.class)) == null) {
            return null;
        }
        int slot = Math.max(0, Math.min(3, (int)((hitVec.yCoord - (double)y) * 2.0)));
        double minX = (double)x + 0.125;
        double minY = (double)y + (double)slot / 2.0;
        double minZ = (double)z + 0.125;
        double maxX = (double)x + 0.875;
        double maxY = (double)y + (double)slot / 2.0 + 0.5;
        double maxZ = (double)z + 0.875;
        EnumArmorStandRegion region = EnumArmorStandRegion.values()[slot];
        for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
            ItemStack item = armorStand.getItem(handler);
            if (player.isSneaking()) {
                ItemStack equipped = handler.getEquipment(player);
                if (item == null && equipped == null || item != null && !handler.isValidItem(player, item) || equipped != null && !handler.isValidItem(player, equipped) || !handler.canSetEquipment(player, item)) continue;
                return AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            }
            ItemStack holding = player.getCurrentEquippedItem();
            if (item == null && holding == null || holding != null && !handler.isValidItem(player, holding)) continue;
            return AxisAlignedBB.getBoundingBox((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        return AxisAlignedBB.getBoundingBox((double)minX, (double)y, (double)minZ, (double)maxX, (double)(y + 2), (double)maxZ);
    }

    private AxisAlignedBB getAttachmentPointsHighlightBox(EntityPlayer player, TileEntity tileEntity, MovingObjectPosition target) {
        Attachments attachments = ((IHasAttachments)tileEntity).getAttachments();
        Attachment attachment = attachments.get(target.subHit);
        if (attachment == null) {
            return null;
        }
        return attachment.getHighlightBox();
    }

    @SubscribeEvent
    public void onRenderPlayerSpecialsPre(RenderPlayerEvent.Specials.Pre event) {
        ItemStack backpack = ItemBackpack.getBackpackData((EntityLivingBase)event.entityPlayer).backpack;
        if (backpack != null) {
            EntityPlayer player = event.entityPlayer;
            float partial = event.partialRenderTick;
            ItemBackpack backpackType = (ItemBackpack)backpack.getItem();
            int color = backpackType.getColor(backpack);
            ModelBackpackArmor model = (ModelBackpackArmor)backpackType.getArmorModel((EntityLivingBase)player, backpack, 0);
            model.onGround = ((Float)ReflectionUtils.invoke(RendererLivingEntity.class, event.renderer, "func_77040_d", "renderSwingProgress", EntityLivingBase.class, Float.TYPE, player, Float.valueOf(partial))).floatValue();
            model.setLivingAnimations((EntityLivingBase)player, 0.0f, 0.0f, partial);
            RenderUtils.bindTexture(new ResourceLocation(backpackType.getArmorTexture(backpack, (Entity)player, 0, null)));
            RenderUtils.setColorFromInt(color >= 0 ? color : 0xFFFFFF);
            model.render((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (color >= 0) {
                RenderUtils.bindTexture(new ResourceLocation(backpackType.getArmorTexture(backpack, (Entity)player, 0, "overlay")));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                model.render((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (backpack.isItemEnchanted()) {
                float f9 = (float)player.ticksExisted + partial;
                RenderUtils.bindTexture(Resources.enchantedEffect);
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                GL11.glDepthFunc((int)514);
                GL11.glDepthMask((boolean)false);
                for (int k = 0; k < 2; ++k) {
                    GL11.glDisable((int)2896);
                    float f11 = 0.76f;
                    GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
                    GL11.glBlendFunc((int)768, (int)1);
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    float f12 = f9 * (0.001f + (float)k * 0.003f) * 20.0f;
                    float f13 = 0.33333334f;
                    GL11.glScalef((float)f13, (float)f13, (float)f13);
                    GL11.glRotatef((float)(30.0f - (float)k * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)f12, (float)0.0f);
                    GL11.glMatrixMode((int)5888);
                    model.render((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glDepthMask((boolean)true);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
                GL11.glDepthFunc((int)515);
            }
        } else {
            backpack = ItemBackpack.getBackpack((EntityLivingBase)event.entityPlayer);
        }
        if (backpack != null) {
            event.renderCape = false;
        }
    }

    static {
        renderingHandlers = new HashMap<Class<? extends TileEntity>, BetterStorageRenderingHandler>();
    }
}

