/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.network.packet;

import java.io.IOException;
import net.mcft.copy.betterstorage.network.AbstractPacket;
import net.mcft.copy.betterstorage.tile.entity.TileEntityPresent;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockAccess;

public class PacketPresentOpen
extends AbstractPacket<PacketPresentOpen> {
    public int x;
    public int y;
    public int z;
    public boolean destroy;

    public PacketPresentOpen() {
    }

    public PacketPresentOpen(int x, int y, int z, boolean destroy) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.destroy = destroy;
    }

    @Override
    public void encode(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.destroy);
    }

    @Override
    public void decode(PacketBuffer buffer) throws IOException {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.destroy = buffer.readBoolean();
    }

    @Override
    public void handle(EntityPlayer player) {
        TileEntityPresent present = WorldUtils.get((IBlockAccess)player.worldObj, this.x, this.y, this.z, TileEntityPresent.class);
        EffectRenderer effRender = Minecraft.getMinecraft().effectRenderer;
        if (present != null) {
            for (int side = 0; side < 6; ++side) {
                for (int i = 0; i < (this.destroy ? 2 : 20); ++i) {
                    if (this.destroy) {
                        effRender.addBlockDestroyEffects(this.x, this.y, this.z, present.getBlockType(), present.getBlockMetadata());
                        continue;
                    }
                    effRender.addBlockHitEffects(this.x, this.y, this.z, side);
                }
            }
        }
    }
}

