/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.network.packet;

import java.io.IOException;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.network.AbstractPacket;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockAccess;

public class PacketLockHit
extends AbstractPacket<PacketLockHit> {
    public int x;
    public int y;
    public int z;
    public boolean damage;

    public PacketLockHit() {
    }

    public PacketLockHit(int x, int y, int z, boolean damage) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.damage = damage;
    }

    @Override
    public void encode(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.damage);
    }

    @Override
    public void decode(PacketBuffer buffer) throws IOException {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.damage = buffer.readBoolean();
    }

    @Override
    public void handle(EntityPlayer player) {
        TileEntityLockable lockable = WorldUtils.get((IBlockAccess)player.worldObj, this.x, this.y, this.z, TileEntityLockable.class);
        this.damage &= BetterStorage.globalConfig.getBoolean("general.lockBreakable");
        if (lockable != null) {
            lockable.lockAttachment.hit(this.damage);
        }
    }
}

