/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.network.packet;

import java.io.IOException;
import net.mcft.copy.betterstorage.network.AbstractPacket;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketBackpackTeleport
extends AbstractPacket<PacketBackpackTeleport> {
    public double sourceX;
    public double sourceY;
    public double sourceZ;
    public int targetX;
    public int targetY;
    public int targetZ;

    public PacketBackpackTeleport() {
    }

    public PacketBackpackTeleport(double sourceX, double sourceY, double sourceZ, int targetX, int targetY, int targetZ) {
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.sourceZ = sourceZ;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
    }

    @Override
    public void encode(PacketBuffer buffer) throws IOException {
        buffer.writeDouble(this.sourceX);
        buffer.writeDouble(this.sourceY);
        buffer.writeDouble(this.sourceZ);
        buffer.writeInt(this.targetX);
        buffer.writeInt(this.targetY);
        buffer.writeInt(this.targetZ);
    }

    @Override
    public void decode(PacketBuffer buffer) throws IOException {
        this.sourceX = buffer.readDouble();
        this.sourceY = buffer.readDouble();
        this.sourceZ = buffer.readDouble();
        this.targetX = buffer.readInt();
        this.targetY = buffer.readInt();
        this.targetZ = buffer.readInt();
    }

    @Override
    public void handle(EntityPlayer player) {
        int amount = 128;
        for (int i = 0; i < amount; ++i) {
            double a = (double)i / (double)(amount - 1);
            double vX = RandomUtils.getDouble(-0.3, 0.3);
            double vY = RandomUtils.getDouble(-0.3, 0.3);
            double vZ = RandomUtils.getDouble(-0.3, 0.3);
            double pX = this.sourceX + ((double)this.targetX - this.sourceX) * a + RandomUtils.getDouble(0.3, 0.7);
            double pY = this.sourceY + ((double)this.targetY - this.sourceY) * a + RandomUtils.getDouble(-0.5, 0.0) + a / 2.0;
            double pZ = this.sourceZ + ((double)this.targetZ - this.sourceZ) * a + RandomUtils.getDouble(0.3, 0.7);
            player.worldObj.spawnParticle("portal", pX, pY, pZ, vX, vY, vZ);
        }
    }
}

