/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.network.packet;

import java.io.IOException;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.network.AbstractPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class PacketBackpackStack
extends AbstractPacket<PacketBackpackStack> {
    public int entityID;
    public ItemStack stack;

    public PacketBackpackStack() {
    }

    public PacketBackpackStack(int entityID, ItemStack stack) {
        this.entityID = entityID;
        this.stack = stack;
    }

    @Override
    public void encode(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.entityID);
        buffer.writeItemStackToBuffer(this.stack);
    }

    @Override
    public void decode(PacketBuffer buffer) throws IOException {
        this.entityID = buffer.readInt();
        this.stack = buffer.readItemStackFromBuffer();
    }

    @Override
    public void handle(EntityPlayer player) {
        Entity entity = player.worldObj.getEntityByID(this.entityID);
        if (entity != null && entity instanceof EntityLivingBase) {
            ItemBackpack.getBackpackData((EntityLivingBase)((EntityLivingBase)entity)).backpack = this.stack;
        }
    }
}

