/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc.handlers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.BetterStorageBackpack;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.entity.EntityFrienderman;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.item.ItemEnderBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.network.packet.PacketSyncSetting;
import net.mcft.copy.betterstorage.tile.TileEnderBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.EntityUtils;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.ReflectionUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BackpackHandler {
    private static final WeightedRandomChestContent[] randomBackpackItems = new WeightedRandomChestContent[]{BackpackHandler.makeWeightedContent(Items.stick, 8, 20, 100), BackpackHandler.makeWeightedContent(Blocks.planks, 2, 10, 100), BackpackHandler.makeWeightedContent(Blocks.log, 1, 8, 40), BackpackHandler.makeWeightedContent(Blocks.cobblestone, 6, 16, 80), BackpackHandler.makeWeightedContent(Items.wooden_pickaxe, 50, 35), BackpackHandler.makeWeightedContent(Items.wooden_pickaxe, 20, 10), BackpackHandler.makeWeightedContent(Items.stone_pickaxe, 120, 10), BackpackHandler.makeWeightedContent(Items.stone_pickaxe, 80, 5), BackpackHandler.makeWeightedContent(Items.iron_pickaxe, 220, 2), BackpackHandler.makeWeightedContent(Items.wooden_sword, 40, 30), BackpackHandler.makeWeightedContent(Items.stone_sword, 60, 5), BackpackHandler.makeWeightedContent((Item)Items.bow, 200, 1, 1, 10), BackpackHandler.makeWeightedContent((Item)Items.bow, 50, 1, 1, 3), BackpackHandler.makeWeightedContent((Item)Items.fishing_rod, 20, 1, 1, 4), BackpackHandler.makeWeightedContent(Items.compass, 1, 1, 6), BackpackHandler.makeWeightedContent(Items.clock, 1, 1, 5), BackpackHandler.makeWeightedContent(Blocks.torch, 6, 24, 30), BackpackHandler.makeWeightedContent(Items.arrow, 2, 12, 10), BackpackHandler.makeWeightedContent(Items.rotten_flesh, 0, 3, 6, 15), BackpackHandler.makeWeightedContent(Items.bone, 2, 5, 20), BackpackHandler.makeWeightedContent(Items.string, 3, 10, 15), BackpackHandler.makeWeightedContent(Items.apple, 2, 5, 15), BackpackHandler.makeWeightedContent(Items.bread, 2, 4, 10), BackpackHandler.makeWeightedContent(Items.wheat, 3, 6, 10), BackpackHandler.makeWeightedContent(Items.carrot, 1, 2, 8), BackpackHandler.makeWeightedContent(Items.potato, 1, 2, 5), BackpackHandler.makeWeightedContent(Items.fish, 1, 4, 5), BackpackHandler.makeWeightedContent(Items.cooked_fished, 1, 2, 4), BackpackHandler.makeWeightedContent(Items.coal, 3, 9, 20), BackpackHandler.makeWeightedContent(Items.coal, 20, 32, 5), BackpackHandler.makeWeightedContent(Blocks.iron_ore, 2, 5, 15), BackpackHandler.makeWeightedContent(Blocks.iron_ore, 10, 20, 2), BackpackHandler.makeWeightedContent(Blocks.gold_ore, 2, 7, 8), BackpackHandler.makeWeightedContent(Items.diamond, 1, 2, 1), BackpackHandler.makeWeightedContent(Items.emerald, 1, 1, 1)};
    private static Comparator<BlockCoordinate> blockDistanceComparator = new Comparator<BlockCoordinate>(){

        @Override
        public int compare(BlockCoordinate o1, BlockCoordinate o2) {
            if (o1.distance < o2.distance) {
                return -1;
            }
            if (o1.distance > o2.distance) {
                return 1;
            }
            return 0;
        }
    };

    private static WeightedRandomChestContent makeWeightedContent(Item item, int damage, int min, int max, int weight) {
        return new WeightedRandomChestContent(item, damage, min, max, weight);
    }

    private static WeightedRandomChestContent makeWeightedContent(Item item, int min, int max, int weight) {
        return BackpackHandler.makeWeightedContent(item, 0, min, max, weight);
    }

    private static WeightedRandomChestContent makeWeightedContent(Item item, int damage, int weight) {
        return BackpackHandler.makeWeightedContent(item, damage, 1, 1, weight);
    }

    private static WeightedRandomChestContent makeWeightedContent(Block block, int min, int max, int weight) {
        return BackpackHandler.makeWeightedContent(Item.getItemFromBlock((Block)block), min, max, weight);
    }

    public BackpackHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        BetterStorageBackpack.spawnWithBackpack(EntityZombie.class, 0.00125);
        BetterStorageBackpack.spawnWithBackpack(EntitySkeleton.class, 8.333333333333334E-4);
        BetterStorageBackpack.spawnWithBackpack(EntityPigZombie.class, 0.001);
        BetterStorageBackpack.spawnWithBackpack(EntityEnderman.class, 0.0125);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase) {
            ItemBackpack.initBackpackData((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && ItemBackpack.onPlaceBackpack(event.entityPlayer, event.x, event.y, event.z, event.face)) {
            event.useBlock = Event.Result.DENY;
            event.useItem = Event.Result.DENY;
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.worldObj.isRemote || !(event.entity instanceof EntityPlayerMP) || !(event.target instanceof EntityLivingBase) || ((EntityPlayerMP)event.entity).playerNetServerHandler == null || event.target instanceof EntityPlayer && !BetterStorage.globalConfig.getBoolean("general.enableBackpackInteraction")) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entity;
        EntityLivingBase target = (EntityLivingBase)event.target;
        if (ItemBackpack.openBackpack((EntityPlayer)player, target)) {
            player.swingItem();
        }
    }

    @SubscribeEvent
    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase entity = event.entityLiving;
        World world = entity.worldObj;
        double probability = 0.0;
        for (BetterStorageBackpack.BackpackSpawnEntry entry : BetterStorageBackpack.spawnWithBackpack) {
            if (!entity.getClass().equals(entry.entityClass)) continue;
            probability = entry.probability;
            break;
        }
        if (!RandomUtils.getBoolean(probability) || entity.isChild()) {
            return;
        }
        if (entity.getClass().equals(EntityEnderman.class)) {
            if (BetterStorageTiles.enderBackpack != null && world.provider.dimensionId != 1 && world.getBiomeGenForCoords((int)entity.posX, (int)entity.posZ) != BiomeGenBase.sky) {
                EntityFrienderman frienderman = new EntityFrienderman(world);
                frienderman.setPositionAndRotation(entity.posX, entity.posY, entity.posZ, entity.rotationYaw, 0.0f);
                world.spawnEntityInWorld((Entity)frienderman);
                ItemBackpack.getBackpackData((EntityLivingBase)frienderman).spawnsWithBackpack = true;
                entity.setDead();
            }
        } else if (BetterStorageTiles.backpack != null) {
            ItemBackpack.getBackpackData((EntityLivingBase)entity).spawnsWithBackpack = true;
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityLivingBase) {
            ItemBackpack.getBackpackData((EntityLivingBase)event.target).sendDataToPlayer((EntityLivingBase)event.target, event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ItemBackpack.getBackpackData((EntityLivingBase)event.player).sendDataToPlayer((EntityLivingBase)event.player, event.player);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        if (backpack == null) {
            PropertiesBackpack backpackData = EntityUtils.getProperties((Entity)entity, PropertiesBackpack.class);
            if (backpackData == null) {
                return;
            }
            if (backpackData.spawnsWithBackpack) {
                ItemStack[] contents = null;
                if (entity instanceof EntityFrienderman) {
                    backpack = new ItemStack((Item)BetterStorageItems.itemEnderBackpack);
                    ((EntityLiving)entity).setEquipmentDropChance(3, 0.0f);
                } else {
                    backpack = new ItemStack((Item)BetterStorageItems.itemBackpack, 1, RandomUtils.getInt(120, 240));
                    ItemBackpack backpackType = (ItemBackpack)backpack.getItem();
                    if (RandomUtils.getBoolean(0.15)) {
                        int r = RandomUtils.getInt(32, 224);
                        int g = RandomUtils.getInt(32, 224);
                        int b = RandomUtils.getInt(32, 224);
                        int color = r << 16 | g << 8 | b;
                        StackUtils.set(backpack, color, "display", "color");
                    }
                    contents = new ItemStack[backpackType.getBackpackColumns() * backpackType.getBackpackRows()];
                    ((EntityLiving)entity).setEquipmentDropChance(3, 1.0f);
                }
                ItemStack armor = entity.getEquipmentInSlot(3);
                if (armor != null && armor.isItemEnchanted()) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.setTag("ench", armor.getTagCompound().getTag("ench"));
                    backpack.setTagCompound(compound);
                }
                if (contents != null) {
                    InventoryStacks inventory = new InventoryStacks(new ItemStack[][]{contents});
                    WeightedRandomChestContent.generateChestContents((Random)RandomUtils.random, (WeightedRandomChestContent[])randomBackpackItems, (IInventory)inventory, (int)20);
                    if (RandomUtils.getDouble() < 0.1) {
                        ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                        WeightedRandomChestContent.generateChestContents((Random)RandomUtils.random, (WeightedRandomChestContent[])info.getItems(RandomUtils.random), (IInventory)inventory, (int)5);
                    }
                }
                ItemBackpack.setBackpack(entity, backpack, contents);
                backpackData.spawnsWithBackpack = false;
            } else if (backpackData.contents != null) {
                for (ItemStack stack : backpackData.contents) {
                    WorldUtils.dropStackFromEntity((Entity)entity, stack, 1.5f);
                }
                backpackData.contents = null;
            }
        }
        ItemBackpack.getBackpackData(entity).update(entity);
        if (backpack != null) {
            ((ItemBackpack)backpack.getItem()).onEquippedUpdate(entity, backpack);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.worldObj.isRemote) {
            return;
        }
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        if (backpack == null) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (backpackData.contents == null) {
            return;
        }
        boolean keepInventory = entity.worldObj.getGameRules().getGameRuleBooleanValue("keepInventory");
        if (player != null && keepInventory) {
            NBTTagCompound persistent;
            NBTTagCompound compound = player.getEntityData();
            if (!compound.hasKey("PlayerPersisted")) {
                persistent = new NBTTagCompound();
                compound.setTag("PlayerPersisted", (NBTBase)persistent);
            } else {
                persistent = compound.getCompoundTag("PlayerPersisted");
            }
            NBTTagCompound backpackCompound = new NBTTagCompound();
            backpackCompound.setInteger("count", backpackData.contents.length);
            backpackCompound.setTag("Items", (NBTBase)NbtUtils.writeItems(backpackData.contents));
            if (!ItemBackpack.hasChestplateBackpackEquipped(entity)) {
                backpackCompound.setTag("Stack", (NBTBase)backpack.writeToNBT(new NBTTagCompound()));
            }
            persistent.setTag("Backpack", (NBTBase)backpackCompound);
        } else {
            if (BetterStorage.globalConfig.getBoolean("general.dropBackpackOnDeath")) {
                ForgeDirection orientation = DirectionUtils.getOrientation((Entity)entity);
                int recentlyHit = (Integer)ReflectionUtils.get(EntityLivingBase.class, entity, "field_70718_bc", "recentlyHit");
                boolean despawn = player == null && recentlyHit <= 0;
                ArrayList<BlockCoordinate> coords = new ArrayList<BlockCoordinate>();
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        coords.add(new BlockCoordinate(entity.posX, entity.posY, entity.posZ, x, 0, z));
                    }
                }
                Collections.sort(coords, blockDistanceComparator);
                while (!coords.isEmpty()) {
                    Iterator iter = coords.iterator();
                    while (iter.hasNext()) {
                        BlockCoordinate coord = (BlockCoordinate)iter.next();
                        if (ItemBackpack.placeBackpack(entity, player, backpack, coord.x, coord.y, coord.z, 1, orientation, despawn, true)) {
                            ItemBackpack.setBackpack(entity, null, null);
                            return;
                        }
                        boolean replacable = entity.worldObj.getBlock(coord.x, coord.y, coord.z).isReplaceable((IBlockAccess)entity.worldObj, coord.x, coord.y, coord.z);
                        coord.y = coord.y + (replacable ? -1 : 1);
                        coord.moved = coord.moved + (replacable ? 1 : 5);
                        if (coord.y > 0 && coord.y <= entity.worldObj.getHeight() && !((double)coord.moved > 24.0 - coord.distance * 4.0)) continue;
                        iter.remove();
                    }
                }
                if (backpackData.backpack != null) {
                    WorldUtils.dropStackFromEntity((Entity)entity, backpack, 4.0f);
                }
            }
            for (ItemStack stack : backpackData.contents) {
                WorldUtils.dropStackFromEntity((Entity)entity, stack, 4.0f);
            }
            backpackData.contents = null;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.world.isRemote) {
            return;
        }
        if (!(event.entity instanceof EntityItem)) {
            return;
        }
        EntityItem entity = (EntityItem)event.entity;
        ItemStack stack = entity.getDataWatcher().getWatchableObjectItemStack(10);
        if (stack == null || !(stack.getItem() instanceof ItemEnderBackpack)) {
            return;
        }
        event.setCanceled(true);
        for (int i = 0; i < 64 && !TileEnderBackpack.teleportRandomly(entity.worldObj, entity.posX, entity.posY, entity.posZ, i > 48, stack); ++i) {
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        BetterStorage.networkChannel.sendTo(new PacketSyncSetting(BetterStorage.globalConfig), event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        NBTTagCompound entityData = event.player.getEntityData();
        if (!entityData.hasKey("PlayerPersisted")) {
            return;
        }
        NBTTagCompound persistent = entityData.getCompoundTag("PlayerPersisted");
        if (!persistent.hasKey("Backpack")) {
            return;
        }
        NBTTagCompound compound = persistent.getCompoundTag("Backpack");
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData((EntityLivingBase)event.player);
        int size = compound.getInteger("count");
        ItemStack[] contents = new ItemStack[size];
        NbtUtils.readItems(contents, compound.getTagList("Items", 10));
        backpackData.contents = contents;
        if (compound.hasKey("Stack")) {
            backpackData.backpack = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("Stack"));
        }
        persistent.removeTag("Backpack");
        if (persistent.hasNoTags()) {
            entityData.removeTag("PlayerPersisted");
        }
    }

    private static class BlockCoordinate {
        public int x;
        public int y;
        public int z;
        public double distance;
        public int moved = 0;

        public BlockCoordinate(double ex, double ey, double ez, int x, int y, int z) {
            this.x = (int)ex + x;
            this.y = (int)ey + y;
            this.z = (int)ez + z;
            this.distance = Math.sqrt(Math.pow((double)this.x + 0.5 - ex, 2.0) + Math.pow((double)this.y + 0.5 - ey, 2.0) + Math.pow((double)this.z + 0.5 - ez, 2.0));
        }
    }
}

