/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public class SmallPotionEffect
extends PotionEffect {
    public SmallPotionEffect(int potionID, int duration, int amplifier) {
        super(potionID, Math.max(1, duration / 12), amplifier);
    }

    public SmallPotionEffect(PotionEffect effect, PotionEffect active) {
        super(effect.getPotionID(), SmallPotionEffect.getDuration(effect, active), effect.getAmplifier());
    }

    private static int getDuration(PotionEffect effect, PotionEffect active) {
        return effect.getDuration() / 12 + (active != null ? active.getDuration() : 0);
    }

    public void performEffect(EntityLivingBase entity) {
        int smallEffect = 6 * (this.getAmplifier() + 1) / 12;
        Potion potion = Potion.potionTypes[this.getPotionID()];
        if (entity.isEntityUndead() ? potion == Potion.heal : potion == Potion.harm) {
            entity.attackEntityFrom(DamageSource.magic, (float)smallEffect);
        } else if (potion == Potion.heal) {
            entity.heal((float)smallEffect);
        } else {
            super.performEffect(entity);
        }
    }
}

