/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemIdentifier {
    private final Item item;
    private final int damage;
    private final NBTTagCompound data;
    private int hashCode;
    private boolean calculatedHashCode = false;

    public ItemIdentifier(Item item, int damage, NBTTagCompound data) {
        this.item = item;
        this.damage = damage;
        this.data = data;
    }

    public ItemIdentifier(ItemStack stack) {
        this(stack.getItem(), StackUtils.getRealItemDamage(stack), stack.hasTagCompound() ? (NBTTagCompound)stack.getTagCompound().copy() : null);
    }

    public ItemStack createStack(int size) {
        ItemStack stack = new ItemStack(this.item, size, this.damage);
        if (this.data != null) {
            stack.stackTagCompound = (NBTTagCompound)this.data.copy();
        }
        return stack;
    }

    public boolean matches(Item item, int damage, NBTTagCompound data) {
        return StackUtils.matches(this.item, this.damage, this.data, item, damage, data);
    }

    public boolean matches(ItemStack stack) {
        return this.matches(stack.getItem(), StackUtils.getRealItemDamage(stack), stack.stackTagCompound);
    }

    public int hashCode() {
        if (!this.calculatedHashCode) {
            this.hashCode = Item.getIdFromItem((Item)this.item) << 16 | this.damage;
            if (this.data != null) {
                this.hashCode ^= this.data.hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier other = (ItemIdentifier)obj;
        return this.matches(other.item, other.damage, other.data);
    }

    public String toString() {
        return this.item.getUnlocalizedName() + ":" + this.damage;
    }
}

