/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.item.ItemDrinkingHelmet;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.utils.DyeUtils;
import net.mcft.copy.betterstorage.utils.EntityUtils;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class ChristmasEventHandler {
    private static final int DAYS_BEFORE_CHRISTMAS = 14;
    private static final int DAYS_AFTER_CHRISTMAS = 2;

    public ChristmasEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        List<ItemStack> items = ChristmasEventHandler.getItemsForYear(ChristmasEventHandler.getYear(), event.player);
        BetterChristmasProperties properties = EntityUtils.getProperties((Entity)event.player, BetterChristmasProperties.class);
        if (items == null) {
            return;
        }
        if (ChristmasEventHandler.isBeforeChristmas() && properties.year < ChristmasEventHandler.getYear()) {
            ItemStack book = new ItemStack((Item)BetterStorageItems.presentBook);
            StackUtils.set(book, ChristmasEventHandler.getYear(), "year");
            StackUtils.set(book, event.player.getUniqueID().toString(), "uuid");
            StackUtils.set(book, event.player.getCommandSenderName(), "name");
            event.player.inventory.addItemStackToInventory(book);
            properties.year = ChristmasEventHandler.getYear();
            properties.gotPresent = false;
        }
        if (ChristmasEventHandler.isPresentTime() && !properties.gotPresent) {
            InventoryPlayer inv = event.player.inventory;
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack == null || stack.getItem() != BetterStorageItems.presentBook || StackUtils.get(stack, 9001, "year") != ChristmasEventHandler.getYear() || !event.player.getUniqueID().toString().equals(StackUtils.get(stack, null, "uuid"))) continue;
                ItemStack present = new ItemStack((Block)BetterStorageTiles.present);
                present.setStackDisplayName("Christmas Present " + ChristmasEventHandler.getYear());
                StackUtils.set(present, event.player.getCommandSenderName(), "nameTag");
                int color = DyeUtils.getDyeColor(new ItemStack(Items.dye, 1, 1));
                StackUtils.set(present, color, "color");
                StackUtils.set(present, (byte)14, "presentColorInner");
                StackUtils.set(present, (byte)16, "presentColorOuter");
                ItemStack[] contents = new ItemStack[ItemCardboardBox.getRows() * 9];
                for (int j = 0; j < contents.length && !items.isEmpty(); ++j) {
                    if (!RandomUtils.getBoolean((double)items.size() / (double)(contents.length - j))) continue;
                    contents[j] = items.remove(RandomUtils.getInt(items.size()));
                }
                StackUtils.setStackContents(present, contents);
                if (event.player.getCommandSenderName().equalsIgnoreCase("xXxCJxXx")) {
                    StackUtils.set(present, (byte)1, "skojanzaMode");
                    StackUtils.set(present, (NBTBase)NbtUtils.createList("Just for you!", "skojanzaMode = true"), "display", "Lore");
                }
                inv.setInventorySlotContents(i, present);
                properties.gotPresent = true;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayerMP) {
            EntityUtils.createProperties(event.entity, BetterChristmasProperties.class);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!(event.entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        BetterChristmasProperties properties = EntityUtils.getProperties((Entity)player, BetterChristmasProperties.class);
        NBTTagCompound entityData = player.getEntityData();
        NBTTagCompound persistent = entityData.getCompoundTag("PlayerPersisted");
        entityData.setTag("PlayerPersisted", (NBTBase)persistent);
        NBTTagCompound propertiesCompound = new NBTTagCompound();
        properties.saveNBTData(propertiesCompound);
        persistent.setTag("betterstorage.betterChristmas", (NBTBase)propertiesCompound);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        BetterChristmasProperties properties = EntityUtils.getProperties((Entity)player, BetterChristmasProperties.class);
        NBTTagCompound entityData = player.getEntityData();
        NBTTagCompound persistent = entityData.getCompoundTag("PlayerPersisted");
        NBTTagCompound propertiesCompound = persistent.getCompoundTag("betterstorage.betterChristmas");
        if (propertiesCompound.hasNoTags()) {
            return;
        }
        properties.loadNBTData(propertiesCompound);
        persistent.removeTag("betterstorage.betterChristmas");
        if (persistent.hasNoTags()) {
            entityData.removeTag("PlayerPersisted");
        }
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getMonth() {
        return Calendar.getInstance().get(2);
    }

    public static int getDay() {
        return Calendar.getInstance().get(5);
    }

    public static boolean isBeforeChristmas() {
        return ChristmasEventHandler.getMonth() == 11 && ChristmasEventHandler.getDay() >= 10 && ChristmasEventHandler.getDay() < 24;
    }

    public static boolean isPresentTime() {
        return ChristmasEventHandler.getMonth() == 11 && ChristmasEventHandler.getDay() >= 24 && ChristmasEventHandler.getDay() <= 26;
    }

    private static List<ItemStack> getItemsForYear(int year, EntityPlayer player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        switch (year) {
            case 2014: {
                ChristmasEventHandler.getItemsFor2014(items, player);
                break;
            }
            default: {
                return null;
            }
        }
        return items;
    }

    private static void getItemsFor2014(List<ItemStack> items, EntityPlayer player) {
        boolean vouchers = false;
        ItemStack sword = new ItemStack((Item)(BetterStorageItems.cardboardSword != null ? BetterStorageItems.cardboardSword : Items.wooden_sword));
        sword.addEnchantment(Enchantment.looting, 4);
        sword.addEnchantment(Enchantment.knockback, 3);
        if (BetterStorageItems.cardboardSword != null) {
            sword.setStackDisplayName(player.getCommandSenderName() + "'s Magical Sword");
            sword.addEnchantment(Enchantment.unbreaking, 2);
            int color = DyeUtils.getDyeColor(new ItemStack(Items.dye, 1, 5));
            StackUtils.set(sword, color, "display", "color");
            StackUtils.set(sword, (NBTBase)NbtUtils.createList("True strength is not in power,", "but in overcoming challenges."), "display", "Lore");
        } else {
            sword.setStackDisplayName("Fake Cardboard Sword");
            StackUtils.set(sword, (NBTBase)NbtUtils.createList("Not made of actual cardboard,", "because some douche disabled it."), "display", "Lore");
        }
        items.add(sword);
        ItemStack chestplate = new ItemStack((Item)(BetterStorageItems.cardboardChestplate != null ? BetterStorageItems.cardboardChestplate : Items.leather_chestplate));
        chestplate.addEnchantment(Enchantment.protection, 4);
        chestplate.addEnchantment(Enchantment.thorns, 3);
        if (BetterStorageItems.cardboardChestplate != null) {
            chestplate.setStackDisplayName(player.getCommandSenderName() + "'s Magical Chestpiece");
            chestplate.addEnchantment(Enchantment.unbreaking, 2);
            int color = DyeUtils.getDyeColor(new ItemStack(Items.dye, 1, 5));
            StackUtils.set(chestplate, color, "display", "color");
            StackUtils.set(chestplate, (NBTBase)NbtUtils.createList("True strength is not in power,", "but in overcoming challenges."), "display", "Lore");
        } else {
            chestplate.setStackDisplayName("Fake Cardboard Chestplate");
            StackUtils.set(chestplate, (NBTBase)NbtUtils.createList("Not made of actual cardboard,", "because some douche disabled it."), "display", "Lore");
        }
        items.add(chestplate);
        if (BetterStorageItems.drinkingHelmet != null) {
            ItemStack drinkingHelmet = new ItemStack((Item)BetterStorageItems.drinkingHelmet);
            drinkingHelmet.setStackDisplayName("Splash Drinking Helmet");
            drinkingHelmet.addEnchantment(Enchantment.protection, 5);
            drinkingHelmet.addEnchantment(Enchantment.respiration, 4);
            ItemStack speedPotion = new ItemStack((Item)Items.potionitem, 1, 16418);
            StackUtils.set(speedPotion, (NBTBase)NbtUtils.createList(NbtUtils.createCompound("Id", 1, "Amplifier", 3, "Duration", 2000), NbtUtils.createCompound("Id", 9, "Amplifier", 1, "Duration", 1600)), "CustomPotionEffects");
            ItemStack weaknessPotion = new ItemStack((Item)Items.potionitem, 1, 16424);
            StackUtils.set(weaknessPotion, (NBTBase)NbtUtils.createList(NbtUtils.createCompound("Id", 18, "Amplifier", 2, "Duration", 2000)), "CustomPotionEffects");
            ItemDrinkingHelmet.setPotions(drinkingHelmet, new ItemStack[]{speedPotion, weaknessPotion});
            StackUtils.set(drinkingHelmet, 24, "uses");
            items.add(drinkingHelmet);
        } else {
            vouchers = ChristmasEventHandler.createVoucher(items, "Drinking Helmet");
        }
        ItemStack shears = new ItemStack((Item)Items.shears);
        shears.setStackDisplayName("Shears of Destiny");
        shears.addEnchantment(Enchantment.silkTouch, 2);
        StackUtils.set(shears, (NBTBase)NbtUtils.createList("\"Destinyyy!\" -Guude"), "display", "Lore");
        items.add(shears);
        if (BetterStorageItems.slimeBucket != null) {
            ItemStack slime = new ItemStack((Item)BetterStorageItems.slimeBucket);
            StackUtils.set(slime, "Magma King", "Slime", "name");
            StackUtils.set(slime, "LavaSlime", "Slime", "id");
            StackUtils.set(slime, (NBTBase)NbtUtils.createList(new PotionEffect(Potion.regeneration.id, 6000, 0).writeCustomPotionEffectToNBT(new NBTTagCompound()), new PotionEffect(Potion.resistance.id, 6000, 1).writeCustomPotionEffectToNBT(new NBTTagCompound()), new PotionEffect(Potion.fireResistance.id, 6000, 2).writeCustomPotionEffectToNBT(new NBTTagCompound()), new PotionEffect(Potion.waterBreathing.id, 6000, 3).writeCustomPotionEffectToNBT(new NBTTagCompound()), new PotionEffect(Potion.nightVision.id, 6000, 3).writeCustomPotionEffectToNBT(new NBTTagCompound())), "Effects");
            StackUtils.set(slime, (NBTBase)NbtUtils.createList("Sneak and use to consume.", "Don't accidentially release it!"), "display", "Lore");
            items.add(slime);
        } else {
            vouchers = ChristmasEventHandler.createVoucher(items, "Slime in a Bucket");
        }
        if (BetterStorageTiles.craftingStation != null) {
            items.add(new ItemStack((Block)BetterStorageTiles.craftingStation));
        } else {
            vouchers = ChristmasEventHandler.createVoucher(items, "Crafting Station");
        }
        items.add(new ItemStack(Items.diamond, 8));
        items.add(new ItemStack(Items.emerald, 16));
        if (vouchers) {
            ItemStack book = new ItemStack(Items.written_book);
            StackUtils.set(book, "Voucher Information", "title");
            StackUtils.set(book, "copygirl", "author");
            StackUtils.set(book, 3, "generation");
            StackUtils.set(book, (NBTBase)NbtUtils.createList("If you received this book, it means whoever is in charge of configs decided some items are not worth existing.\n\nThis, of course, is unacceptable. Now it is your job to bug them about it and demand a way to turn your voucher(s) into the christmas present items you deserve!"), "pages");
            items.add(book);
        }
    }

    private static boolean createVoucher(List<ItemStack> items, String itemName) {
        ItemStack voucher = new ItemStack(Items.paper);
        voucher.setStackDisplayName(itemName + " Voucher");
        StackUtils.set(voucher, (NBTBase)NbtUtils.createList("Item: " + itemName, "Redeem at server owner / modpack author."), "display", "Lore");
        items.add(voucher);
        return true;
    }

    public static class BetterChristmasProperties
    implements IExtendedEntityProperties {
        public static final String identifier = "betterstorage.betterChristmas";
        public int year = 2013;
        public boolean gotPresent = false;

        public void init(Entity entity, World world) {
        }

        public void saveNBTData(NBTTagCompound compound) {
            NBTTagCompound data = new NBTTagCompound();
            data.setShort("year", (short)this.year);
            data.setBoolean("gotPresent", this.gotPresent);
            compound.setTag(identifier, (NBTBase)data);
        }

        public void loadNBTData(NBTTagCompound compound) {
            NBTTagCompound data = compound.getCompoundTag(identifier);
            if (!data.hasNoTags()) {
                this.year = data.getShort("year");
                this.gotPresent = data.getBoolean("gotPresent");
            } else {
                this.year = compound.getInteger("betterChristmasYear");
            }
        }
    }
}

