/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import java.util.ArrayList;
import net.mcft.copy.betterstorage.item.IDyeableItem;
import net.mcft.copy.betterstorage.utils.DyeUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class DyeRecipe
implements IRecipe {
    public int getRecipeSize() {
        return 10;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public boolean matches(InventoryCrafting crafting, World world) {
        boolean hasArmor = false;
        boolean hasDyes = false;
        for (int i = 0; i < crafting.getSizeInventory(); ++i) {
            IDyeableItem dyeable;
            ItemStack stack = crafting.getStackInSlot(i);
            if (stack == null) continue;
            IDyeableItem iDyeableItem = dyeable = stack.getItem() instanceof IDyeableItem ? (IDyeableItem)stack.getItem() : null;
            if (dyeable != null && dyeable.canDye(stack)) {
                if (hasArmor) {
                    return false;
                }
                hasArmor = true;
                continue;
            }
            if (DyeUtils.isDye(stack)) {
                hasDyes = true;
                continue;
            }
            return false;
        }
        return hasArmor && hasDyes;
    }

    public ItemStack getCraftingResult(InventoryCrafting crafting) {
        ItemStack armor = null;
        IDyeableItem dyeable = null;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < crafting.getSizeInventory(); ++i) {
            ItemStack stack = crafting.getStackInSlot(i);
            if (stack == null) continue;
            IDyeableItem iDyeableItem = dyeable = stack.getItem() instanceof IDyeableItem ? (IDyeableItem)stack.getItem() : null;
            if (dyeable != null && dyeable.canDye(stack)) {
                if (armor != null) {
                    return null;
                }
                armor = stack.copy();
                continue;
            }
            if (DyeUtils.isDye(stack)) {
                dyes.add(stack);
                continue;
            }
            return null;
        }
        if (dyes.isEmpty()) {
            return null;
        }
        int oldColor = StackUtils.get(armor, -1, "display", "color");
        int newColor = DyeUtils.getColorFromDyes(oldColor, dyes);
        StackUtils.set(armor, newColor, "display", "color");
        return armor;
    }
}

