/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.cardboard;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeBounds;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputItemStack;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.cardboard.CardboardRecipeHelper;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.item.cardboard.RecipeInputCardboard;
import net.mcft.copy.betterstorage.item.cardboard.RecipeInputEnchantedBook;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;

public class CardboardEnchantmentRecipe
implements IStationRecipe {
    @Override
    public StationCrafting checkMatch(ItemStack[] input, RecipeBounds bounds) {
        boolean hasCardboardItems = false;
        int bookIndex = -1;
        ItemStack book = null;
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null) continue;
            if (stack.getItem() instanceof ICardboardItem) {
                hasCardboardItems = true;
                continue;
            }
            if (book == null && stack.getItem() == Items.enchanted_book) {
                bookIndex = i;
                book = stack;
                continue;
            }
            return null;
        }
        if (book == null || !hasCardboardItems) {
            return null;
        }
        ItemStack[] output = new ItemStack[9];
        int experienceCost = 0;
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        Collection<StackUtils.StackEnchantment> bookEnchantments = StackUtils.getEnchantments(book).values();
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null || !(stack.getItem() instanceof ICardboardItem)) continue;
            ItemStack outputStack = stack.copy();
            boolean canApply = false;
            Map<Integer, StackUtils.StackEnchantment> stackEnchants = StackUtils.getEnchantments(outputStack);
            int numEnchants = stackEnchants.size();
            for (StackUtils.StackEnchantment bookEnch : bookEnchantments) {
                if (!StackUtils.isEnchantmentCompatible(outputStack, stackEnchants.values(), bookEnch)) continue;
                StackUtils.StackEnchantment stackEnch = stackEnchants.get(bookEnch.ench.effectId);
                int level = bookEnch.getLevel() - (stackEnch != null ? stackEnch.getLevel() : 0);
                experienceCost += this.calculateCost(bookEnch, stackEnch == null, numEnchants);
                if (stackEnch != null) {
                    stackEnch.setLevel(bookEnch.getLevel());
                } else {
                    outputStack.addEnchantment(bookEnch.ench, bookEnch.getLevel());
                }
                canApply = true;
            }
            if (!canApply) {
                return null;
            }
            output[i] = outputStack;
            requiredInput[i] = new RecipeInputItemStack(StackUtils.copyStack(stack, 1), true);
        }
        requiredInput[bookIndex] = new RecipeInputItemStack(StackUtils.copyStack(book, 0, false));
        return new StationCrafting(output, requiredInput, experienceCost);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IRecipeInput[]> getSampleInputs() {
        ArrayList<IRecipeInput[]> sampleInputs = new ArrayList<IRecipeInput[]>();
        this.makeInput(sampleInputs, BetterStorageItems.cardboardHelmet, BetterStorageItems.cardboardChestplate, null, BetterStorageItems.cardboardLeggings, BetterStorageItems.cardboardBoots, this.makeEnchantedBook(Enchantment.protection, 4));
        this.makeInput(sampleInputs, null, BetterStorageItems.cardboardPickaxe, null, null, BetterStorageItems.cardboardShovel, this.makeEnchantedBook(Enchantment.efficiency, 5), null, BetterStorageItems.cardboardAxe);
        this.makeInput(sampleInputs, null, null, null, BetterStorageItems.cardboardSword, BetterStorageItems.cardboardAxe, this.makeEnchantedBook(Enchantment.sharpness, 5));
        this.makeInput(sampleInputs, BetterStorageItems.cardboardChestplate, BetterStorageItems.cardboardLeggings, null, BetterStorageItems.cardboardSword, BetterStorageItems.cardboardPickaxe, this.makeEnchantedBook(Enchantment.unbreaking, 3), BetterStorageItems.cardboardShovel, BetterStorageItems.cardboardHoe);
        return sampleInputs;
    }

    private void makeInput(List<IRecipeInput[]> sampleInputs, Object ... obj) {
        IRecipeInput[] input = new IRecipeInput[9];
        boolean hasCardboardItem = false;
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            input[i] = BetterStorageCrafting.makeInput(obj[i]);
            if (!(obj[i] instanceof ICardboardItem)) continue;
            hasCardboardItem = true;
        }
        if (hasCardboardItem) {
            sampleInputs.add(input);
        }
    }

    private ItemStack makeEnchantedBook(Enchantment ench, int level) {
        ItemStack book = new ItemStack((Item)Items.enchanted_book);
        ((ItemEnchantedBook)book.getItem()).addEnchantment(book, new EnchantmentData(ench, level));
        return book;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IRecipeInput> getPossibleInputs() {
        return Arrays.asList(RecipeInputCardboard.instance, RecipeInputEnchantedBook.instance);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getPossibleOutputs() {
        return Collections.emptyList();
    }

    private int calculateCost(StackUtils.StackEnchantment ench, boolean hasEnchantment, int numEnchants) {
        int weight = ench.ench.getWeight();
        int costPerLevel = weight > 8 ? 1 : (weight > 6 ? 2 : (weight > 3 ? 3 : (weight > 1 ? 4 : 6)));
        int cost = costPerLevel * ench.getLevel() - 1;
        cost += CardboardRecipeHelper.getAdditionalEnchantmentCost(ench);
        if (hasEnchantment) {
            cost += (numEnchants + 1) / 2;
        }
        return cost;
    }
}

