/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class ItemBucketSlime
extends ItemBetterStorage {
    private static Map<String, Handler> handlers = new HashMap<String, Handler>();
    private IIcon empty;

    public ItemBucketSlime() {
        this.setContainerItem(Items.bucket);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.empty = iconRegister.registerIcon("betterstorage:bucketSlime_empty");
        for (Handler handler : handlers.values()) {
            handler.registerIcon(iconRegister);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            Handler handler = ItemBucketSlime.getHandler(stack);
            return handler != null ? handler.icon : this.empty;
        }
        return this.empty;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconIndex(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return stack.isItemEnchanted() || pass == 0 && StackUtils.has(stack, "Effects");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        NBTTagList effectList;
        String id = ItemBucketSlime.getSlimeId(stack);
        Handler handler = ItemBucketSlime.getHandler(id);
        String name = StackUtils.get(stack, null, "Slime", "name");
        if (name != null || advancedTooltips) {
            list.add("Contains: " + (name != null ? "\"" + name + "\"" + (advancedTooltips ? " (" + id + ")" : "") : id));
        }
        if ((effectList = (NBTTagList)StackUtils.getTag(stack, "Effects")) != null && handler != null) {
            int max = advancedTooltips || GuiScreen.isShiftKeyDown() ? 6 : 3;
            for (int i = 0; i < Math.min(effectList.tagCount(), max); ++i) {
                PotionEffect effect = PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)effectList.getCompoundTagAt(i));
                Potion potion = Potion.potionTypes[effect.getPotionID()];
                int duration = (int)((float)effect.getDuration() * handler.durationMultiplier());
                StringBuilder str = new StringBuilder().append(potion.isBadEffect() ? EnumChatFormatting.RED : EnumChatFormatting.GRAY).append(StatCollector.translateToLocal((String)effect.getEffectName()));
                if (effect.getAmplifier() > 0) {
                    str.append(" ").append(StatCollector.translateToLocal((String)("potion.potency." + effect.getAmplifier())));
                }
                str.append(" (").append(StringUtils.ticksToElapsedTime((int)duration)).append(")");
                list.add(str.toString());
            }
            int more = effectList.tagCount() - max;
            if (more > 0) {
                list.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + LanguageUtils.translateTooltip("bucketSlime.more." + (more == 1 ? "1" : "x"), "%X%", Integer.toString(more)));
            }
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        x += Facing.offsetsXForSide[side];
        y += Facing.offsetsYForSide[side];
        z += Facing.offsetsZForSide[side];
        String id = ItemBucketSlime.getSlimeId(stack);
        String name = StackUtils.get(stack, null, "Slime", "name");
        Entity entity = EntityList.createEntityByName((String)id, (World)world);
        Handler handler = ItemBucketSlime.getHandler(id);
        if (entity != null && handler != null && entity instanceof EntityLiving) {
            EntityLiving slime = (EntityLiving)entity;
            float rotation = MathHelper.wrapAngleTo180_float((float)(world.rand.nextFloat() * 360.0f));
            slime.setLocationAndAngles((double)x + 0.5, (double)y, (double)z + 0.5, rotation, 0.0f);
            slime.rotationYawHead = slime.renderYawOffset = rotation;
            if (name != null) {
                slime.setCustomNameTag(name);
            }
            handler.setSize(slime, 1);
            NBTTagList effectList = (NBTTagList)StackUtils.getTag(stack, "Effects");
            if (effectList != null) {
                for (int i = 0; i < effectList.tagCount(); ++i) {
                    slime.addPotionEffect(PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)effectList.getCompoundTagAt(i)));
                }
            }
            world.spawnEntityInWorld((Entity)slime);
            slime.playSound("mob.slime.big", 1.2f, 0.6f);
            player.setCurrentItemOrArmor(0, new ItemStack(Items.bucket));
        }
        return true;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.drink;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 48;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        Handler handler = ItemBucketSlime.getHandler(stack);
        if (handler != null) {
            player.getFoodStats().addStats(handler.foodAmount(), handler.saturationAmount());
            NBTTagList effectList = (NBTTagList)StackUtils.getTag(stack, "Effects");
            if (effectList != null) {
                for (int i = 0; i < effectList.tagCount(); ++i) {
                    PotionEffect effect = PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)effectList.getCompoundTagAt(i));
                    int duration = (int)((float)effect.getDuration() * handler.durationMultiplier());
                    effect = new PotionEffect(effect.getPotionID(), duration, effect.getAmplifier());
                    player.addPotionEffect(effect);
                }
            }
            handler.onEaten(player, false);
        }
        return new ItemStack(Items.bucket);
    }

    public static void pickUpSlime(EntityPlayer player, EntityLiving slime) {
        Collection effects;
        Handler handler = ItemBucketSlime.getHandler(slime);
        if (slime.isDead || handler == null || handler.getSize(slime) != 1) {
            return;
        }
        ItemStack stack = new ItemStack((Item)BetterStorageItems.slimeBucket);
        String entityId = EntityList.getEntityString((Entity)slime);
        if (!entityId.equals("Slime")) {
            StackUtils.set(stack, entityId, "Slime", "id");
        }
        if (slime.hasCustomNameTag()) {
            StackUtils.set(stack, slime.getCustomNameTag(), "Slime", "name");
        }
        if (!(effects = slime.getActivePotionEffects()).isEmpty()) {
            NBTTagList effectList = new NBTTagList();
            for (PotionEffect effect : effects) {
                effectList.appendTag((NBTBase)effect.writeCustomPotionEffectToNBT(new NBTTagCompound()));
            }
            StackUtils.set(stack, (NBTBase)effectList, "Effects");
        }
        if (--player.getCurrentEquippedItem().stackSize <= 0) {
            player.setCurrentItemOrArmor(0, stack);
        } else if (!player.inventory.addItemStackToInventory(stack)) {
            player.dropPlayerItemWithRandomChoice(stack, true);
        } else {
            ((EntityPlayerMP)player).inventoryContainer.detectAndSendChanges();
        }
        slime.playSound("mob.slime.big", 1.2f, 0.8f);
        slime.isDead = true;
    }

    public static String getSlimeId(ItemStack stack) {
        return StackUtils.get(stack, "Slime", "Slime", "id");
    }

    public static void registerHandler(Handler handler) {
        handlers.put(handler.entityName, handler);
    }

    public static Handler getHandler(String id) {
        return handlers.get(id);
    }

    public static Handler getHandler(EntityLiving slime) {
        return ItemBucketSlime.getHandler(EntityList.getEntityString((Entity)slime));
    }

    public static Handler getHandler(ItemStack stack) {
        return ItemBucketSlime.getHandler(ItemBucketSlime.getSlimeId(stack));
    }

    static {
        ItemBucketSlime.registerHandler(new Handler("slime", "Slime"){

            @Override
            public int foodAmount() {
                return 3;
            }

            @Override
            public float saturationAmount() {
                return 0.2f;
            }
        });
        ItemBucketSlime.registerHandler(new Handler("magmaCube", "LavaSlime"){

            @Override
            public float durationMultiplier() {
                return 0.4f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                player.setFire(2);
                player.addPotionEffect(new PotionEffect(Potion.jump.id, (potionEffects ? 10 : 20) * 20, potionEffects ? 2 : 3));
                player.addPotionEffect(new PotionEffect(Potion.damageBoost.id, (potionEffects ? 24 : 32) * 20, 0));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("mazeSlime", "TwilightForest.Maze Slime"){

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                player.attackEntityFrom(DamageSource.magic, 3.0f);
                player.addPotionEffect(new PotionEffect(Potion.jump.id, (potionEffects ? 4 : 8) * 20, 0));
                player.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, (potionEffects ? 4 : 8) * 20, 1));
                player.addPotionEffect(new PotionEffect(Potion.resistance.id, 600, 1));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("pinkSlime", "MineFactoryReloaded.mfrEntityPinkSlime"){

            @Override
            public int foodAmount() {
                return 6;
            }

            @Override
            public float saturationAmount() {
                return 0.75f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                super.onEaten(player, potionEffects);
                player.addPotionEffect(new PotionEffect(Potion.field_76434_w.id, (potionEffects ? 40 : 60) * 20, 4));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("thaumicSlime", "Thaumcraft.ThaumSlime"){
            private int potionFluxId = -1;

            @Override
            public float durationMultiplier() {
                return 1.0f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                if (this.potionFluxId == -1) {
                    for (Potion potion : Potion.potionTypes) {
                        if (potion == null || potion.getName() != "potion.fluxtaint") continue;
                        this.potionFluxId = potion.id;
                        break;
                    }
                    if (this.potionFluxId == -1) {
                        this.potionFluxId = Potion.wither.id;
                    }
                }
                super.onEaten(player, potionEffects);
                player.addPotionEffect(new PotionEffect(this.potionFluxId, 160, 0));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("blueSlime", "TConstruct.EdibleSlime"){

            @Override
            public float durationMultiplier() {
                return 0.2f;
            }
        });
    }

    public static class Handler {
        public final String name;
        public final String entityName;
        public IIcon icon;

        public Handler(String name, String entityName) {
            this.name = name;
            this.entityName = entityName;
        }

        public void registerIcon(IIconRegister iconRegister) {
            this.icon = iconRegister.registerIcon("betterstorage:bucketSlime_" + this.name);
        }

        public int getSize(EntityLiving slime) {
            return slime.getDataWatcher().getWatchableObjectByte(16);
        }

        public void setSize(EntityLiving slime, int size) {
            NBTTagCompound compound = new NBTTagCompound();
            slime.writeToNBT(compound);
            compound.setInteger("Size", size - 1);
            slime.readFromNBT(compound);
        }

        public int foodAmount() {
            return 4;
        }

        public float saturationAmount() {
            return 0.3f;
        }

        public float durationMultiplier() {
            return 0.25f;
        }

        public void onEaten(EntityPlayer player, boolean potionEffects) {
            player.addPotionEffect(new PotionEffect(Potion.jump.id, (potionEffects ? 6 : 16) * 20, 1));
        }
    }
}

