/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.mcft.copy.betterstorage.api.crate.ICrateWatcher;
import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryCratePlayerView
extends InventoryBetterStorage
implements ICrateWatcher {
    private static final int inventoryMaxSize = 54;
    public final CratePileData data;
    public final TileEntityCrate crate;
    private ItemStack[] tempContents;
    private Map<ItemIdentifier, MapData> countData = new HashMap<ItemIdentifier, MapData>();
    private boolean ignoreModifiedItems = false;

    public InventoryCratePlayerView(TileEntityCrate crate) {
        super("container.betterstorage.crate");
        this.data = crate.getPileData();
        this.crate = crate;
        int size = Math.min(this.data.getCapacity(), 54);
        this.tempContents = new ItemStack[size];
        ArrayList<Integer> slotAccess = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            slotAccess.add(i);
        }
        if (this.data.getOccupiedSlots() < size) {
            Collections.shuffle(slotAccess);
        }
        Iterator<ItemStack> iter = this.data.getContents().getRandomStacks().iterator();
        for (int slot = 0; slot < size && iter.hasNext(); ++slot) {
            ItemStack stack = iter.next();
            this.getMapData((ItemStack)stack).itemCount += stack.stackSize;
            this.tempContents[((Integer)slotAccess.get((int)slot)).intValue()] = stack;
        }
    }

    private MapData getMapData(ItemIdentifier item) {
        MapData data = this.countData.get(item);
        if (data != null) {
            return data;
        }
        data = new MapData();
        this.countData.put(item, data);
        return data;
    }

    private MapData getMapData(ItemStack item) {
        return this.getMapData(new ItemIdentifier(item));
    }

    public int getSizeInventory() {
        return this.tempContents.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.getSizeInventory()) {
            return null;
        }
        return this.tempContents[slot];
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.getSizeInventory()) {
            return;
        }
        ItemStack oldStack = this.getStackInSlot(slot);
        this.ignoreModifiedItems = true;
        if (oldStack != null) {
            ItemIdentifier item = new ItemIdentifier(oldStack);
            this.getMapData((ItemIdentifier)item).itemCount -= oldStack.stackSize;
            this.data.removeItems(item, oldStack.stackSize);
        }
        if (stack != null) {
            int amount = Math.min(stack.stackSize, Math.min(this.data.getSpaceForItem(stack), stack.getMaxStackSize()));
            if (amount <= 0) {
                return;
            }
            stack = StackUtils.copyStack(stack.copy(), amount);
            this.getMapData((ItemStack)stack).itemCount += amount;
            this.data.addItems(stack);
        }
        this.ignoreModifiedItems = false;
        this.tempContents[slot] = stack;
        if (stack == null) {
            this.onSlotEmptied(slot);
        }
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack == null) {
            return null;
        }
        amount = Math.min(amount, stack.stackSize);
        ItemIdentifier item = new ItemIdentifier(stack);
        this.getMapData((ItemIdentifier)item).itemCount -= amount;
        stack.stackSize -= amount;
        if (stack.stackSize <= 0) {
            this.tempContents[slot] = null;
        }
        this.ignoreModifiedItems = true;
        ItemStack result = this.data.removeItems(item, amount);
        this.ignoreModifiedItems = false;
        if (this.tempContents[slot] == null) {
            this.onSlotEmptied(slot);
        }
        return result;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int x = this.crate.xCoord;
        int y = this.crate.yCoord;
        int z = this.crate.zCoord;
        return player.worldObj.getTileEntity(x, y, z) == this.crate && player.getDistanceSq((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && this.getSizeInventory() <= this.data.getCapacity();
    }

    public void markDirty() {
    }

    public void openInventory() {
        this.data.addWatcher(this);
    }

    public void closeInventory() {
        this.data.removeWatcher(this);
    }

    @Override
    public void onCrateItemsModified(ItemStack changed) {
        if (this.ignoreModifiedItems) {
            return;
        }
        ItemIdentifier item = new ItemIdentifier(changed);
        int amount = changed.stackSize;
        MapData itemData = this.getMapData(item);
        LinkedList<Integer> emptySlots = new LinkedList<Integer>();
        for (int slot = 0; slot < this.tempContents.length; ++slot) {
            ItemStack stack = this.tempContents[slot];
            if (stack == null) {
                emptySlots.add(slot);
                continue;
            }
            if (!item.matches(stack) || (amount -= this.modifyItemsInSlot(slot, stack, itemData, amount)) != 0) continue;
            return;
        }
        while (amount > 0 && emptySlots.size() > 0) {
            amount -= this.setItemsInSlot((Integer)emptySlots.poll(), item, itemData, amount);
        }
    }

    public boolean canFitSome(ItemStack item) {
        for (ItemStack stack : this.tempContents) {
            if (stack != null && (!StackUtils.matches(stack, item) || stack.stackSize >= stack.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    private void onSlotEmptied(int slot) {
        int emptySlots = 0;
        for (int s = 0; s < this.tempContents.length; ++s) {
            if (this.tempContents[s] != null) continue;
            ++emptySlots;
        }
        if (emptySlots <= this.data.getFreeSlots()) {
            return;
        }
        for (ItemStack stack : this.data.getContents().getItems()) {
            ItemIdentifier item = new ItemIdentifier(stack);
            MapData itemData = this.getMapData(item);
            int count = stack.stackSize - itemData.itemCount;
            if (count <= 0) continue;
            this.setItemsInSlot(slot, item, itemData, count);
        }
    }

    private int modifyItemsInSlot(int slot, ItemStack stack, MapData itemData, int amount) {
        int count = Math.max(-stack.stackSize, Math.min(amount, stack.getMaxStackSize() - stack.stackSize));
        if ((stack.stackSize += count) <= 0) {
            this.tempContents[slot] = null;
        }
        itemData.itemCount += count;
        return count;
    }

    private int setItemsInSlot(int slot, ItemIdentifier item, MapData itemData, int maxAmount) {
        int size = Math.min(maxAmount, item.createStack(1).getMaxStackSize());
        this.tempContents[slot] = item.createStack(size);
        itemData.itemCount += size;
        return size;
    }

    private static class MapData {
        public int itemCount = 0;

        private MapData() {
        }
    }
}

