/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.ContainerInfo;
import net.mcft.copy.betterstorage.api.crafting.CraftingSourceTileEntity;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.recipe.VanillaStationCrafting;
import net.mcft.copy.betterstorage.misc.FakePlayer;
import net.mcft.copy.betterstorage.tile.entity.TileEntityCraftingStation;
import net.mcft.copy.betterstorage.utils.InventoryUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryCraftingStation
extends InventoryBetterStorage {
    public TileEntityCraftingStation entity = null;
    public final ItemStack[] crafting;
    public final ItemStack[] output;
    public final ItemStack[] contents;
    public StationCrafting currentCrafting = null;
    public boolean outputIsReal = false;
    public int progress = 0;
    private boolean hasRequirements = false;
    private boolean checkHasRequirements = true;

    public InventoryCraftingStation(TileEntityCraftingStation entity) {
        this("", entity.crafting, entity.output, entity.contents);
        this.entity = entity;
    }

    public InventoryCraftingStation(String name) {
        this(name, new ItemStack[9], new ItemStack[9], new ItemStack[18]);
    }

    private InventoryCraftingStation(String name, ItemStack[] crafting, ItemStack[] output, ItemStack[] contents) {
        super(name);
        this.crafting = crafting;
        this.output = output;
        this.contents = contents;
    }

    public void update() {
        if (!this.outputIsReal && this.currentCrafting != null) {
            if (this.progress >= Math.max(this.currentCrafting.getCraftingTime(), (Integer)GlobalConfig.stationAutocraftDelaySetting.getValue())) {
                if (this.entity != null && this.entity.isRedstonePowered() && this.currentCrafting.getRequiredExperience() == 0 && this.hasItemRequirements()) {
                    this.craft(null);
                }
            } else {
                ++this.progress;
            }
        }
    }

    public void inputChanged() {
        this.progress = 0;
        this.currentCrafting = BetterStorageCrafting.findMatchingStationCrafting(this.crafting);
        if (this.currentCrafting == null && ((Boolean)GlobalConfig.enableStationVanillaCraftingSetting.getValue()).booleanValue()) {
            this.currentCrafting = VanillaStationCrafting.findVanillaRecipe(this);
        }
        this.updateGhostOutput();
    }

    public void updateGhostOutput() {
        if (this.outputIsReal) {
            return;
        }
        if (this.currentCrafting != null) {
            ItemStack[] craftingOutput = this.currentCrafting.getOutput();
            for (int i = 0; i < this.output.length; ++i) {
                this.output[i] = i < craftingOutput.length ? ItemStack.copyItemStack((ItemStack)craftingOutput[i]) : null;
            }
        } else {
            Arrays.fill(this.output, null);
        }
    }

    private boolean craft(EntityPlayer player, boolean simulate) {
        ItemStack[] crafting;
        ItemStack[] contents = simulate ? (ItemStack[])this.contents.clone() : this.contents;
        ItemStack[] itemStackArray = crafting = simulate ? (ItemStack[])this.crafting.clone() : this.crafting;
        if (simulate) {
            for (int i = 0; i < crafting.length; ++i) {
                crafting[i] = ItemStack.copyItemStack((ItemStack)crafting[i]);
            }
        }
        if (this.currentCrafting instanceof VanillaStationCrafting) {
            boolean unset = false;
            if (player == null) {
                player = FakePlayer.get(this.entity);
                unset = true;
            }
            ItemStack craftOutput = simulate ? this.output[4].copy() : this.output[4];
            InventoryStacks craftMatrix = new InventoryStacks(new ItemStack[][]{crafting});
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, craftOutput, (IInventory)craftMatrix);
            new CustomSlotCrafting(player, craftOutput);
            if (unset) {
                FakePlayer.unset();
                player = null;
            }
        }
        CraftingSourceTileEntity source = new CraftingSourceTileEntity(this.entity, player);
        this.currentCrafting.craft(source);
        IRecipeInput[] requiredInput = this.currentCrafting.getCraftRequirements();
        for (int i = 0; i < crafting.length; ++i) {
            if (crafting[i] == null) continue;
            crafting[i] = this.craftSlot(crafting[i], requiredInput[i], player, simulate);
        }
        boolean pulled = this.pullRequired(contents, crafting, requiredInput);
        if (!simulate) {
            int requiredExperience = this.currentCrafting.getRequiredExperience();
            if (requiredExperience != 0 && player != null && !player.capabilities.isCreativeMode) {
                player.experienceLevel -= requiredExperience;
            }
            this.outputIsReal = !this.outputEmpty();
            this.progress = 0;
            this.inputChanged();
            this.checkHasRequirements = true;
        }
        return pulled;
    }

    public void craft(EntityPlayer player) {
        this.craft(player, false);
    }

    public boolean simulateCraft() {
        boolean canCraftAgain = this.craft(FakePlayer.get(this.entity), true);
        FakePlayer.unset();
        return canCraftAgain;
    }

    private ItemStack craftSlot(ItemStack stack, IRecipeInput requiredInput, EntityPlayer player, boolean simulate) {
        if (simulate) {
            stack = stack.copy();
        }
        ContainerInfo containerInfo = new ContainerInfo();
        requiredInput.craft(stack, containerInfo);
        ItemStack containerItem = ItemStack.copyItemStack((ItemStack)containerInfo.getContainerItem());
        boolean removeStack = false;
        if (stack.stackSize <= 0) {
            removeStack = true;
        } else if (stack.getItem().isDamageable() && stack.getItemDamage() > stack.getMaxDamage()) {
            removeStack = true;
            if (player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, stack));
            }
        }
        if (removeStack) {
            if (!containerInfo.doesLeaveCrafting()) {
                stack = containerItem;
                containerItem = null;
            } else {
                stack = null;
            }
        }
        if (containerItem != null && !simulate && !InventoryUtils.tryAddItemToInventory(containerItem, new InventoryStacks(new ItemStack[][]{this.contents}), true) && this.entity != null) {
            WorldUtils.spawnItem(this.entity.getWorldObj(), (double)this.entity.xCoord + 0.5, (double)this.entity.yCoord + 0.5, (double)this.entity.zCoord + 0.5, containerItem);
        }
        return stack;
    }

    public boolean pullRequired(ItemStack[] contents, ItemStack[] crafting, IRecipeInput[] requiredInput) {
        boolean success = true;
        block0: for (int i = 0; i < crafting.length; ++i) {
            ItemStack stack = crafting[i];
            IRecipeInput required = requiredInput[i];
            if (required != null) {
                int requiredAmount;
                int currentAmount = 0;
                if (stack != null) {
                    if (!required.matches(stack)) {
                        return false;
                    }
                    currentAmount = stack.stackSize;
                }
                if ((requiredAmount = required.getAmount() - currentAmount) <= 0) continue;
                for (int j = 0; j < contents.length; ++j) {
                    ItemStack contentsStack = contents[j];
                    if (contentsStack == null || !(stack == null ? required.matches(contentsStack) : StackUtils.matches(stack, contentsStack))) continue;
                    int amount = Math.min(contentsStack.stackSize, requiredAmount);
                    crafting[i] = stack = StackUtils.copyStack(contentsStack, currentAmount += amount);
                    contents[j] = StackUtils.copyStack(contentsStack, contentsStack.stackSize - amount);
                    if ((requiredAmount -= amount) <= 0) continue block0;
                }
            } else if (stack == null) continue;
            success = false;
        }
        return success;
    }

    public boolean canTake(EntityPlayer player) {
        return this.outputIsReal || player != null && this.currentCrafting != null && this.currentCrafting.canCraft(new CraftingSourceTileEntity(this.entity, player)) && this.progress >= this.currentCrafting.getCraftingTime() && this.hasRequiredExperience(player);
    }

    private boolean hasRequiredExperience(EntityPlayer player) {
        int requiredExperience = this.currentCrafting.getRequiredExperience();
        return requiredExperience == 0 || player != null && (player.capabilities.isCreativeMode || player.experienceLevel >= requiredExperience);
    }

    public boolean hasItemRequirements() {
        if (this.checkHasRequirements) {
            this.hasRequirements = this.simulateCraft();
            this.checkHasRequirements = false;
        }
        return this.hasRequirements;
    }

    public int getSizeInventory() {
        return this.crafting.length + this.output.length + this.contents.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < this.crafting.length) {
            return this.crafting[slot];
        }
        if (slot < this.crafting.length + this.output.length) {
            return this.output[slot - this.crafting.length];
        }
        return this.contents[slot - (this.crafting.length + this.output.length)];
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (slot < this.crafting.length) {
            this.crafting[slot] = stack;
        } else if (slot < this.crafting.length + this.output.length) {
            this.output[slot - this.crafting.length] = stack;
        } else {
            this.contents[slot - (this.crafting.length + this.output.length)] = stack;
        }
        this.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void markDirty() {
        if (this.entity != null) {
            this.entity.markDirtySuper();
        }
        if (this.outputEmpty()) {
            this.outputIsReal = false;
            this.updateGhostOutput();
        }
        this.checkHasRequirements = true;
    }

    private boolean outputEmpty() {
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] == null) continue;
            return false;
        }
        return true;
    }

    private static class CustomSlotCrafting
    extends SlotCrafting {
        public CustomSlotCrafting(EntityPlayer player, ItemStack stack) {
            super(player, null, null, 0, 0, 0);
            this.onCrafting(stack);
        }
    }
}

