/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class InventoryBetterStorage
implements IInventory {
    private String name;

    public InventoryBetterStorage(String name) {
        this.name = name;
    }

    public InventoryBetterStorage() {
        this("");
    }

    public String getInventoryName() {
        return this.name;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack == null) {
            return null;
        }
        if ((amount = Math.min(amount, stack.stackSize)) < stack.stackSize) {
            stack.stackSize -= amount;
            stack = StackUtils.copyStack(stack, amount);
            this.markDirty();
        } else {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack == null) {
            return null;
        }
        this.setInventorySlotContents(slot, null);
        return stack;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }
}

