/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.entity;

import java.util.IdentityHashMap;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.network.packet.PacketBackpackTeleport;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.ReflectionUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFrienderman
extends EntityEnderman {
    public static IdentityHashMap<Block, Boolean> friendermanCarriable = new IdentityHashMap(1);

    public EntityFrienderman(World world) {
        super(world);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(40.0);
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    public void setScreaming(boolean screaming) {
    }

    public Block func_146080_bZ() {
        return Block.getBlockById((int)((this.dataWatcher.getWatchableObjectByte(16) + 256) % 256));
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        boolean success = super.attackEntityFrom(source, damage);
        if (this.entityToAttack != null) {
            int i = 0;
            while ((float)i < 40.0f - this.getMaxHealth() / 2.0f && !this.teleportRandomly()) {
                ++i;
            }
            this.entityToAttack = null;
        }
        return success;
    }

    protected void despawnEntity() {
        if (this.isNoDespawnRequired()) {
            this.entityAge = 0;
            return;
        }
        EntityPlayer player = this.worldObj.getClosestPlayerToEntity((Entity)this, -1.0);
        double distance = player != null ? this.getDistanceToEntity((Entity)player) : 64000.0f;
        if (this.entityAge >= 0) {
            if (distance < 16.0) {
                this.entityAge = 0;
            } else if (distance < 32.0) {
                this.entityAge = Math.max(0, this.entityAge - 2);
            } else if (distance < 48.0) {
                this.entityAge = Math.max(0, this.entityAge - 1);
            } else if (distance > 64.0 && this.entityAge > 6000 && RandomUtils.getBoolean(0.001)) {
                this.setDead();
            }
        }
    }

    public void onLivingUpdate() {
        if (this.worldObj.isRemote) {
            super.onLivingUpdate();
            return;
        }
        int x = (int)Math.floor(this.posX);
        int y = (int)(this.posY + 0.6);
        int z = (int)Math.floor(this.posZ);
        GameRules rules = this.worldObj.getGameRules();
        String ruleBefore = rules.getGameRuleStringValue("mobGriefing");
        boolean ruleChanged = false;
        boolean hasEnderChest = this.func_146080_bZ() == Blocks.ender_chest;
        boolean hasBackpack = this.getEquipmentInSlot(3) != null;
        IdentityHashMap carriable = (IdentityHashMap)ReflectionUtils.get(EntityEnderman.class, null, "carriable", "");
        ReflectionUtils.set(EntityEnderman.class, null, "carriable", "", friendermanCarriable);
        if (hasEnderChest) {
            if (ruleBefore.equalsIgnoreCase("true")) {
                rules.setOrCreateGameRule("mobGriefing", "false");
                ruleChanged = true;
            }
        } else if (hasBackpack && this.worldObj.isAirBlock(x, y, z) && ruleBefore.equalsIgnoreCase("false")) {
            rules.setOrCreateGameRule("mobGriefing", "true");
            ruleChanged = true;
        }
        super.onLivingUpdate();
        ReflectionUtils.set(EntityEnderman.class, null, "carriable", "", carriable);
        if (ruleChanged) {
            rules.setOrCreateGameRule("mobGriefing", ruleBefore);
        }
        if (!hasEnderChest && this.func_146080_bZ() == Blocks.ender_chest) {
            this.setCurrentItemOrArmor(3, null);
            this.worldObj.setBlock(x, y, z, (Block)BetterStorageTiles.enderBackpack, RandomUtils.getInt(2, 6), 3);
            WorldUtils.get((IBlockAccess)this.worldObj, (int)x, (int)y, (int)z, TileEntityBackpack.class).stack = new ItemStack((Item)BetterStorageItems.itemEnderBackpack);
            double px = (double)x + 0.5;
            double py = (double)y + 0.5;
            double pz = (double)z + 0.5;
            BetterStorage.networkChannel.sendToAllAround(new PacketBackpackTeleport(px, py, pz, x, y, z), this.worldObj, px, py, pz, 256.0);
            this.worldObj.playSoundEffect(px, py, pz, "mob.endermen.portal", 1.0f, 1.0f);
        }
    }

    static {
        friendermanCarriable.put(Blocks.ender_chest, true);
    }
}

