/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ChestContainer;
import net.mcft.copy.betterstorage.client.gui.GuiBetterStorage;
import net.mcft.copy.betterstorage.container.SlotBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@ChestContainer(isLargeChest=true)
public class ContainerBetterStorage
extends Container {
    private final int columns;
    private final int rows;
    public final EntityPlayer player;
    public final IInventory inventory;
    public final int separation;
    private int startHotbar = -1;
    @SideOnly(value=Side.CLIENT)
    public GuiBetterStorage updateGui;

    @ChestContainer.RowSizeCallback
    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public ContainerBetterStorage(EntityPlayer player, IInventory inventory, int columns, int rows, int seperation) {
        this.player = player;
        this.inventory = inventory;
        this.columns = columns;
        this.rows = rows;
        this.separation = seperation;
        this.setupInventoryContainer();
        this.setupInventoryPlayer();
        inventory.openInventory();
    }

    public ContainerBetterStorage(EntityPlayer player, IInventory inventory, int columns, int rows) {
        this(player, inventory, columns, rows, 14);
    }

    public ContainerBetterStorage(EntityPlayer player, InventoryTileEntity inventory) {
        this(player, inventory, inventory.columns, inventory.rows);
    }

    @SideOnly(value=Side.CLIENT)
    public ContainerBetterStorage(EntityPlayer player, IInventory inventory, int columns, int rows, GuiBetterStorage gui) {
        this(player, inventory, columns, rows);
        this.setUpdateGui(gui);
    }

    public int getHeight() {
        return (this.getRows() + 4) * 18 + this.separation + 29;
    }

    protected void setupInventoryContainer() {
        for (int y = 0; y < this.getRows(); ++y) {
            for (int x = 0; x < this.getColumns(); ++x) {
                this.addSlotToContainer(new SlotBetterStorage(this, this.inventory, x + y * this.getColumns(), 8 + x * 18, 18 + y * 18));
            }
        }
    }

    protected void setupInventoryPlayer() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(new SlotBetterStorage(this, (IInventory)this.player.inventory, 9 + x + y * 9, 8 + x * 18 + (this.getColumns() - 9) * 9, this.getHeight() - 83 + y * 18));
            }
        }
        this.setHotbarStart();
        for (int x = 0; x < 9; ++x) {
            this.addSlotToContainer(new SlotBetterStorage(this, (IInventory)this.player.inventory, x, 8 + x * 18 + (this.getColumns() - 9) * 9, this.getHeight() - 25));
        }
    }

    protected void setHotbarStart() {
        this.startHotbar = this.inventorySlots.size();
    }

    protected boolean inInventory(int slot) {
        return slot < this.inventory.getSizeInventory();
    }

    protected int transferStart(int slot) {
        return this.inInventory(slot) ? this.inventory.getSizeInventory() : 0;
    }

    protected int transferEnd(int slot) {
        return this.inInventory(slot) ? this.inventorySlots.size() : this.inventory.getSizeInventory();
    }

    protected boolean transferDirection(int slot) {
        return this.inInventory(slot);
    }

    public void onSlotChanged(int slot) {
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotId) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotId);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (!this.mergeItemStack(slotStack, this.transferStart(slotId), this.transferEnd(slotId), this.transferDirection(slotId))) {
                return null;
            }
            if (slotStack.stackSize != 0) {
                slot.onSlotChanged();
            } else {
                slot.putStack(null);
            }
        }
        return stack;
    }

    protected boolean mergeItemStack(ItemStack stack, int start, int end, boolean backwards) {
        int maxStackSize;
        ItemStack slotStack;
        Slot slot;
        int index;
        int i;
        boolean success = false;
        if (stack.isStackable()) {
            for (i = 0; i < end - start; ++i) {
                int amount;
                ItemStack testStack;
                index = start + (backwards ? end - start - 1 - i : i);
                slot = (Slot)this.inventorySlots.get(index);
                slotStack = slot.getStack();
                maxStackSize = Math.min(stack.getMaxStackSize(), slot.inventory.getInventoryStackLimit());
                if (StackUtils.matches(stack, slotStack) && slotStack.stackSize < maxStackSize && slot.isItemValid(testStack = StackUtils.copyStack(stack, amount = Math.min(slotStack.stackSize + stack.stackSize, maxStackSize))) && slot.inventory.isItemValidForSlot(slot.slotNumber, testStack)) {
                    stack.stackSize -= testStack.stackSize - slotStack.stackSize;
                    slot.putStack(testStack);
                    success = true;
                }
                if (stack.stackSize > 0) continue;
                return success;
            }
        }
        for (i = 0; i < end - start; ++i) {
            ItemStack testStack;
            index = start + (backwards ? end - start - 1 - i : i);
            slot = (Slot)this.inventorySlots.get(index);
            slotStack = slot.getStack();
            if (slotStack == null && slot.isItemValid(testStack = StackUtils.copyStack(stack, Math.min(stack.stackSize, maxStackSize = Math.min(stack.getMaxStackSize(), slot.inventory.getInventoryStackLimit())))) && slot.inventory.isItemValidForSlot(slot.slotNumber, testStack)) {
                stack.stackSize -= testStack.stackSize;
                slot.putStack(testStack);
                success = true;
            }
            if (stack.stackSize <= 0) break;
        }
        return success;
    }

    public ItemStack slotClick(int slotId, int button, int special, EntityPlayer player) {
        Slot slot = null;
        if (slotId >= 0 && slotId < this.inventorySlots.size()) {
            slot = (Slot)this.inventorySlots.get(slotId);
        }
        if (slot != null) {
            if (special == 0) {
                if (button == 0 || button == 1) {
                    ItemStack slotStack = slot.getStack();
                    ItemStack holding = player.inventory.getItemStack();
                    if (slotStack != null && holding != null && (holding == null ? slot.canTakeStack(player) : slot.isItemValid(holding)) && StackUtils.matches(slotStack, holding)) {
                        int amount = button == 0 ? holding.stackSize : 1;
                        amount = Math.min(amount, slot.getSlotStackLimit() - slotStack.stackSize);
                        if ((amount = Math.min(amount, slotStack.getMaxStackSize() - slotStack.stackSize)) > 0) {
                            if ((holding.stackSize -= amount) <= 0) {
                                player.inventory.setItemStack(null);
                            }
                            slot.putStack(StackUtils.copyStack(slotStack, slotStack.stackSize + amount));
                        }
                        return slotStack;
                    }
                }
            } else {
                if (special == 1) {
                    return slot.canTakeStack(player) ? this.transferStackInSlot(player, slotId) : null;
                }
                if (special == 2 && button >= 0 && button < 9) {
                    if (this.startHotbar < 0) {
                        return null;
                    }
                    Slot slot2 = (Slot)this.inventorySlots.get(this.startHotbar + button);
                    ItemStack stack = slot.getStack();
                    if (!slot2.canTakeStack(player) || stack != null && !slot2.isItemValid(stack)) {
                        return null;
                    }
                }
            }
        }
        return super.slotClick(slotId, button, special, player);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.inventory.isUseableByPlayer(player);
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        this.inventory.closeInventory();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int val) {
        if (this.updateGui != null) {
            this.updateGui.update(id, val);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setUpdateGui(GuiBetterStorage gui) {
        this.updateGui = gui;
    }

    public void sendUpdate(int id, int value) {
        for (Object c : this.crafters) {
            ((ICrafting)c).sendProgressBarUpdate((Container)this, id, value);
        }
    }

    public void sendUpdateIfChanged(int id, int value, int previousValue) {
        if (value != previousValue) {
            this.sendUpdate(id, value);
        }
    }
}

