/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.renderer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.client.model.ModelPresent;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.tile.entity.TileEntityPresent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityPresentRenderer
extends TileEntitySpecialRenderer {
    private static final double NAMETAG_RENDER_RANGE = 3.0;
    private static final double NAMETAG_RENDER_RANGE_SQ = 9.0;
    private ModelPresent model = new ModelPresent();

    public void renderTileEntityAt(TileEntity entity, double x, double y, double z, float par8) {
        this.renderTileEntityAt((TileEntityPresent)entity, x, y, z, par8);
    }

    public void renderTileEntityAt(TileEntityPresent present, double x, double y, double z, float partialTicks) {
        int[] nArray;
        TextureManager texMan = Minecraft.getMinecraft().getTextureManager();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        texMan.bindTexture(texMan.getResourceLocation(0));
        this.renderSome(present.colorInner, 1);
        int n = present.colorOuter;
        if (present.skojanzaMode) {
            int[] nArray2 = new int[2];
            nArray2[0] = 2;
            nArray = nArray2;
            nArray2[1] = 3;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        this.renderSome(n, nArray);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)514);
        GL11.glBlendFunc((int)770, (int)771);
        texMan.bindTexture(Resources.texturePresentOverlay);
        this.model.render(1);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3042);
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        if (present.nameTag != null && present.getWorldObj() != null && player != null && player.getDistanceSq((double)present.xCoord + 0.5, (double)present.yCoord + 0.5, (double)present.zCoord + 0.5) < 9.0) {
            MovingObjectPosition o = Minecraft.getMinecraft().objectMouseOver;
            this.renderNameTag(present.nameTag, player.getCommandSenderName().equalsIgnoreCase(present.nameTag), o.blockX == present.xCoord && o.blockY == present.yCoord && o.blockZ == present.zCoord);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderSome(int color, int ... layers) {
        IIcon icon = color < 16 ? Blocks.wool.getIcon(0, color) : Blocks.gold_block.getIcon(0, 0);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)icon.getMinU(), (float)icon.getMinV(), (float)0.0f);
        GL11.glScalef((float)(icon.getMaxU() - icon.getMinU()), (float)(icon.getMaxV() - icon.getMinV()), (float)1.0f);
        for (int i = 0; i < layers.length; ++i) {
            this.model.render(layers[i]);
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }

    private void renderNameTag(String owner, boolean isOwner, boolean lookingAt) {
        FontRenderer fontRen = Minecraft.getMinecraft().fontRenderer;
        RenderManager renMan = RenderManager.instance;
        int boxColor = 0;
        int boxAlpha = lookingAt ? 128 : 48;
        int textColor = (isOwner ? 0xFFFF55 : 0xAAAAAA) + (lookingAt ? -16777216 : Integer.MIN_VALUE);
        float f1 = 0.011764706f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.1f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renMan.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renMan.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        int j = fontRen.getStringWidth(owner) / 2;
        tessellator.setColorRGBA_I(boxColor, boxAlpha);
        tessellator.addVertex((double)(-j - 2), -1.0, 0.0);
        tessellator.addVertex((double)(-j - 2), 9.0, 0.0);
        tessellator.addVertex((double)(j + 2), 9.0, 0.0);
        tessellator.addVertex((double)(j + 2), -1.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        fontRen.drawString(owner, -fontRen.getStringWidth(owner) / 2, 0, textColor);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

