/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.renderer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFrienderman
extends RenderEnderman {
    protected int shouldRenderPass(EntityEnderman entity, int slot, float partialTicks) {
        int color;
        if (slot == 0) {
            this.setRenderPassModel(this.mainModel);
            return super.shouldRenderPass(entity, slot, partialTicks);
        }
        if (slot != 1) {
            return -1;
        }
        ItemStack stack = entity.getEquipmentInSlot(3);
        if (stack == null) {
            return -1;
        }
        Item item = stack.getItem();
        if (!(item instanceof ItemArmor)) {
            return -1;
        }
        ItemArmor itemarmor = (ItemArmor)item;
        TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
        textureManager.bindTexture(RenderBiped.getArmorResource((Entity)entity, (ItemStack)stack, (int)slot, null));
        ModelBiped modelBiped = ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)stack, (int)slot, null);
        this.setRenderPassModel((ModelBase)modelBiped);
        if (modelBiped != null) {
            modelBiped.onGround = this.mainModel.onGround;
            modelBiped.isRiding = this.mainModel.isRiding;
            modelBiped.isChild = this.mainModel.isChild;
        }
        if ((color = itemarmor.getColor(stack)) != -1) {
            RenderUtils.setColorFromInt(color);
            if (stack.isItemEnchanted()) {
                return 31;
            }
            return 16;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        return stack.isItemEnchanted() ? 15 : 1;
    }
}

