/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.client.model.ModelBackpack;
import net.mcft.copy.betterstorage.entity.EntityFrienderman;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

@SideOnly(value=Side.CLIENT)
public class ModelBackpackArmor
extends ModelBiped {
    public final ModelBackpack baseModel;

    public ModelBackpackArmor(ModelBackpack baseModel) {
        this.baseModel = baseModel;
        this.textureWidth = baseModel.textureWidth;
        this.textureHeight = baseModel.textureHeight;
        this.bipedBody = new ModelRenderer((ModelBase)this);
        ModelRenderer model = new ModelRenderer((ModelBase)this);
        for (ModelRenderer box : baseModel.boxList) {
            box.rotationPointY -= (float)baseModel.getModelHeight();
            box.rotationPointZ += 5.5f;
            this.bipedBody.addChild(box);
        }
        this.bipedBody.addChild(model);
    }

    public void setLivingAnimations(EntityLivingBase entity, float par2, float par3, float partialTicks) {
        float angle = 0.0f;
        if (entity != null) {
            PropertiesBackpack backpack = ItemBackpack.getBackpackData(entity);
            angle = backpack.prevLidAngle + (backpack.lidAngle - backpack.prevLidAngle) * partialTicks;
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle;
        }
        if (this.baseModel.top != null) {
            this.baseModel.top.rotateAngleX = (float)((double)angle * Math.PI / 4.0);
        }
    }

    public void render(Entity entity, float v1, float v2, float v3, float v4, float v5, float v6) {
        this.setRotationAngles(v1, v2, v3, v4, v5, v6, entity);
        if (entity instanceof EntityFrienderman) {
            float y = this.bipedBody.rotationPointY;
            this.bipedBody.rotationPointY -= 18.0f;
            this.bipedBody.render(0.05f);
            this.bipedBody.rotationPointY = y;
        } else {
            this.bipedBody.render(0.05f);
        }
    }

    public void setRotationAngles(float v1, float v2, float v3, float v4, float v5, float v6, Entity entity) {
        this.isSneak = entity != null ? ((EntityLivingBase)entity).isSneaking() : false;
        super.setRotationAngles(v1, v2, v3, v4, v5, v6, entity);
    }
}

