/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBetterStorage
extends GuiContainer {
    public final ContainerBetterStorage container;
    public final String title;
    private final int columns;
    private final int rows;

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public GuiBetterStorage(ContainerBetterStorage container) {
        super((Container)container);
        this.container = container;
        IInventory inv = container.inventory;
        this.title = inv.hasCustomInventoryName() ? inv.getInventoryName() : StatCollector.translateToLocal((String)inv.getInventoryName());
        this.columns = container.getColumns();
        this.rows = container.getRows();
        this.xSize = 14 + this.columns * 18;
        this.ySize = container.getHeight();
        container.setUpdateGui(this);
    }

    public GuiBetterStorage(EntityPlayer player, int columns, int rows, IInventory inventory) {
        this(new ContainerBetterStorage(player, inventory, columns, rows));
    }

    public GuiBetterStorage(EntityPlayer player, int columns, int rows, String title, boolean localized) {
        this(player, columns, rows, (IInventory)new InventoryBasic(title, localized, columns * rows));
    }

    public GuiBetterStorage(EntityPlayer player, int columns, int rows, String title) {
        this(player, columns, rows, title, false);
    }

    protected ResourceLocation getResource() {
        if (this.columns <= 9) {
            return new ResourceLocation("textures/gui/container/generic_54.png");
        }
        return Resources.containerReinforcedChest;
    }

    protected int getHeight() {
        return 223;
    }

    protected int getTextureWidth() {
        return 256;
    }

    protected int getTextureHeight() {
        return 256;
    }

    public void update(int par1, int par2) {
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(this.title, 8, 6, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8 + (this.xSize - 176) / 2, this.ySize - 94, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(this.getResource());
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        int w = this.getTextureWidth();
        int h = this.getTextureHeight();
        int m = 107;
        int m1 = this.ySize - m;
        int m2 = this.getHeight() - m;
        RenderUtils.drawTexturedModalRect(x, y, 0, 0, this.xSize, m1, this.zLevel, w, h);
        RenderUtils.drawTexturedModalRect(x, y + m1, 0, m2, this.xSize, m, this.zLevel, w, h);
    }
}

