/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.minetweaker;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.player.MCPlayer;
import net.mcft.copy.betterstorage.addon.minetweaker.MTHelper;
import net.mcft.copy.betterstorage.api.crafting.ContainerInfo;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class RecipeInputIngredient
extends RecipeInputBase {
    protected static EntityPlayer player;
    private final IIngredient ingredient;

    public RecipeInputIngredient(IIngredient ingredient) {
        this.ingredient = ingredient;
    }

    @Override
    public int getAmount() {
        return this.ingredient.getAmount();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack != null ? this.ingredient.matches((IItemStack)new MCItemStack(stack)) : false;
    }

    @Override
    public void craft(ItemStack input, ContainerInfo containerInfo) {
        super.craft(input, containerInfo);
        ItemStack transformed = MTHelper.toStack(this.ingredient.applyTransform((IItemStack)new MCItemStack(input), (IPlayer)(player != null ? new MCPlayer(player) : null)));
        if (transformed != input) {
            input.stackSize = 0;
            if (transformed.stackSize > 0) {
                containerInfo.set(transformed, false);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getPossibleMatches() {
        List stacks = this.ingredient.getItems();
        return stacks != null ? MTHelper.toStacks(stacks) : Arrays.asList(new ItemStack(Blocks.air));
    }
}

