/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.api.crafting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeBounds;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.minecraft.item.ItemStack;

public class ShapelessStationRecipe
implements IStationRecipe {
    public final IRecipeInput[] recipeInput;
    public final ItemStack[] recipeOutput;
    public int requiredExperience = 0;
    public int craftingTime = 0;

    public ShapelessStationRecipe(IRecipeInput[] input, ItemStack[] output) {
        this.recipeInput = input;
        this.recipeOutput = output;
    }

    public ShapelessStationRecipe(ItemStack[] output, Object ... input) {
        this.recipeInput = new IRecipeInput[input.length];
        this.recipeOutput = output;
        for (int i = 0; i < input.length; ++i) {
            this.recipeInput[i] = BetterStorageCrafting.makeInput(input[i]);
        }
    }

    public ShapelessStationRecipe(ItemStack output, Object ... input) {
        this(new ItemStack[]{null, null, null, null, output}, input);
    }

    public ShapelessStationRecipe setRequiredExperience(int experience) {
        this.requiredExperience = experience;
        return this;
    }

    public ShapelessStationRecipe setCraftingTime(int time) {
        this.craftingTime = time;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IRecipeInput[]> getSampleInputs() {
        IRecipeInput[] input = new IRecipeInput[9];
        System.arraycopy(this.recipeInput, 0, input, 0, this.recipeInput.length);
        return Arrays.asList(new IRecipeInput[][]{input});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IRecipeInput> getPossibleInputs() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getPossibleOutputs() {
        return null;
    }

    @Override
    public StationCrafting checkMatch(ItemStack[] input, RecipeBounds bounds) {
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        LinkedList<IRecipeInput> checklist = new LinkedList<IRecipeInput>(Arrays.asList(this.recipeInput));
        block0: for (int i = 0; i < input.length; ++i) {
            ItemStack item = input[i];
            if (item == null) continue;
            Iterator iter = checklist.iterator();
            while (iter.hasNext()) {
                requiredInput[i] = (IRecipeInput)iter.next();
                if (!requiredInput[i].matches(item)) continue;
                iter.remove();
                continue block0;
            }
            return null;
        }
        if (!checklist.isEmpty()) {
            return null;
        }
        return new StationCrafting(this.recipeOutput, requiredInput, this.requiredExperience, this.craftingTime);
    }
}

