/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.BW_GT_MaterialReference;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import net.minecraft.item.ItemStack;

public class CasingLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff == BW_GT_MaterialReference.Wood) {
            CasingLoader.addCasingRecipes(werkstoff, OrePrefixes.plank);
        } else {
            if (!(werkstoff.hasGenerationFeature(WerkstoffLoader.blockCasing) && werkstoff.doesOreDictedItemExists(OrePrefixes.plate) && werkstoff.doesOreDictedItemExists(OrePrefixes.screw) && werkstoff.doesOreDictedItemExists(OrePrefixes.gearGtSmall) && werkstoff.doesOreDictedItemExists(OrePrefixes.gearGt) && werkstoff.doesOreDictedItemExists(OrePrefixes.plateDouble))) {
                return;
            }
            CasingLoader.addCasingRecipes(werkstoff, OrePrefixes.plateDouble);
        }
    }

    private static void addCasingRecipes(Werkstoff werkstoff, OrePrefixes reboltedCasingsOuterStuff) {
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(WerkstoffLoader.blockCasing), (Object[])new Object[]{"PSP", "PGP", "PSP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw), Character.valueOf('G'), werkstoff.get(OrePrefixes.gearGtSmall)});
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{werkstoff.get(OrePrefixes.plate, 6), werkstoff.get(OrePrefixes.screw, 2), werkstoff.get(OrePrefixes.gearGtSmall)}, GT_Values.NF, werkstoff.get(WerkstoffLoader.blockCasing), 200, 30);
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(WerkstoffLoader.blockCasingAdvanced), (Object[])new Object[]{"PSP", "PGP", "PSP", Character.valueOf('P'), werkstoff.get(reboltedCasingsOuterStuff), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw), Character.valueOf('G'), werkstoff.get(OrePrefixes.gearGt)});
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{werkstoff.get(reboltedCasingsOuterStuff, 6), werkstoff.get(OrePrefixes.screw, 2), werkstoff.get(OrePrefixes.gearGt)}, GT_Values.NF, werkstoff.get(WerkstoffLoader.blockCasingAdvanced), 200, 30);
    }
}

