/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.items.SimpleSubItemClass;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_HTGR
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_HTGR> {
    private static final int BASECASINGINDEX = 181;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_HTGR> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  BBBBBBB  ", " BBBBBBBBB ", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", "BBBBBBBBBBB", " BBBBBBBBB ", "  BBBBBBB  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  ccccccc  ", " c-------c ", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", "c---------c", " c-------c ", "  ccccccc  "}, {"  bbb~bbb  ", " bbbbbbbbb ", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", "bbbbbbbbbbb", " bbbbbbbbb ", "  bbbbbbb  "}})).addElement(Character.valueOf('c'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)5)).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)181, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)181, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)181, (int)1), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)5)})).addElement(Character.valueOf('B'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)181, (int)2, (Block)GregTech_API.sBlockCasings8, (int)5)).build();
    private static final int HELIUM_NEEDED = 730000;
    private static final int powerUsage = BW_Util.getMachineVoltageFromTier(6);
    private static final int maxcapacity = 720000;
    private static final int mincapacity = 72000;
    private int HeliumSupply;
    private int fueltype = -1;
    private int fuelsupply = 0;
    private boolean empty;
    private int emptyticksnodiff = 0;
    private int coolanttaking = 0;
    private int runningtick = 0;

    public GT_TileEntity_HTGR(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_HTGR(String aName) {
        super(aName);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public IStructureDefinition<GT_TileEntity_HTGR> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Breeder Reactor").addInfo("Controller block for the High Temperature Gas-cooled Reactor (HTGR)").addInfo("Needs a constant supply of coolant while running").addInfo("Needs at least 72k Fuel pebbles to start operation (can hold up to 720k pebbles)").addInfo("Consumes up to 0.5% of total Fuel Pellets per Operation depending on efficiency").addInfo("Efficiency is calculated exponentially depending on the amount of pebbles in the internal buffer").addInfo("Reactor will take 4 000L/s of coolant multiplied by efficiency and by fuel coolant value (check tooltips)").addInfo("Uses " + GT_Utility.formatNumbers((long)powerUsage) + " EU/t").addInfo("One Operation takes 1 hour").addSeparator().beginStructureBlock(11, 12, 11, true).addController("Front bottom center").addCasingInfo("Europium Reinforced Radiation Proof Casings", 0).addStructureInfo("Corners and the 2 touching blocks are air (cylindric)").addInputBus("Any top layer casing", new int[]{2}).addInputHatch("Any top layer casing", new int[]{2}).addOutputBus("Any bottom layer casing", new int[]{1}).addOutputHatch("Any bottom layer casing", new int[]{1}).addEnergyHatch("Any bottom layer casing", new int[]{1}).addMaintenanceHatch("Any bottom layer casing", new int[]{1}).toolTipFinisher("Bartworks");
        return tt;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 5, 11, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 5, 11, 0) && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() > 0 && this.mOutputHatches.size() > 0 && this.mInputBusses.size() > 0 && this.mOutputBusses.size() > 0 && this.mEnergyHatches.size() > 0;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.HeliumSupply = aNBT.func_74762_e("HeliumSupply");
        this.fueltype = aNBT.func_74762_e("fueltype");
        this.fuelsupply = aNBT.func_74762_e("fuelsupply");
        this.empty = aNBT.func_74767_n("EmptyMode");
        this.coolanttaking = aNBT.func_74762_e("coolanttaking");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("HeliumSupply", this.HeliumSupply);
        aNBT.func_74768_a("fueltype", this.fueltype);
        aNBT.func_74768_a("fuelsupply", this.fuelsupply);
        aNBT.func_74757_a("EmptyMode", this.empty);
        aNBT.func_74768_a("coolanttaking", this.coolanttaking);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && !this.empty) {
            if (this.HeliumSupply < 730000) {
                for (FluidStack fluidStack : this.getStoredFluids()) {
                    if (!fluidStack.isFluidEqual(Materials.Helium.getGas(1L))) continue;
                    int toget = Math.min(730000 - this.HeliumSupply, fluidStack.amount);
                    fluidStack.amount -= toget;
                    this.HeliumSupply += toget;
                    if (730000 != this.HeliumSupply || fluidStack.amount != 0) continue;
                    fluidStack = null;
                }
            }
            if (this.fuelsupply < 720000) {
                for (ItemStack itemStack : this.getStoredInputs()) {
                    int damage;
                    int type = -1;
                    if (itemStack == null || itemStack.func_77973_b() != HTGRMaterials.aHTGR_Materials || ((damage = HTGRMaterials.aHTGR_Materials.getDamage(itemStack)) + 1) % HTGRMaterials.MATERIALS_PER_FUEL != 5) continue;
                    type = damage / HTGRMaterials.MATERIALS_PER_FUEL;
                    if (this.fueltype == -1) {
                        this.fueltype = type;
                    }
                    if (this.fueltype != type) continue;
                    int toget = Math.min(720000 - this.fuelsupply, itemStack.field_77994_a);
                    this.fuelsupply += toget;
                    itemStack.field_77994_a -= toget;
                }
                this.updateSlots();
            }
        }
    }

    public boolean checkRecipe(ItemStack controllerStack) {
        if (this.empty) {
            if (this.HeliumSupply > 0 || this.fuelsupply > 0) {
                this.mEfficiency = 10000;
                this.mMaxProgresstime = 100;
                return true;
            }
            return false;
        }
        if (this.HeliumSupply < 730000 || this.fuelsupply < 72000) {
            return false;
        }
        double eff = Math.min(Math.pow((double)this.fuelsupply / 72000.0, 2.0), 100.0) / 100.0 - (double)(this.getIdealStatus() - this.getRepairStatus()) / 10.0;
        if (eff <= 0.0) {
            return false;
        }
        int toReduce = MathUtils.floorInt((double)this.fuelsupply * 0.005 * eff);
        this.fuelsupply -= toReduce;
        int burnedballs = toReduce / 64;
        if (burnedballs > 0) {
            toReduce -= burnedballs * 64;
        }
        int meta = this.fueltype * HTGRMaterials.MATERIALS_PER_FUEL + 5;
        this.mOutputItems = new ItemStack[]{new ItemStack((Item)HTGRMaterials.aHTGR_Materials, burnedballs, meta), new ItemStack((Item)HTGRMaterials.aHTGR_Materials, toReduce, meta + 1)};
        this.coolanttaking = (int)(4000.0 * ((double)this.fueltype * 0.5 + 1.0) * eff);
        this.mEfficiency = (int)(eff * 10000.0);
        this.mEUt = -powerUsage;
        this.mMaxProgresstime = 72000;
        return true;
    }

    public boolean onRunningTick(ItemStack aStack) {
        ++this.runningtick;
        if (this.empty) {
            if (this.emptyticksnodiff > 20 && this.emptyticksnodiff % 20 != 0) {
                ++this.emptyticksnodiff;
                return true;
            }
            if (this.HeliumSupply > 0) {
                this.addOutput(Materials.Helium.getGas((long)this.HeliumSupply));
                this.HeliumSupply = 0;
            }
            if (this.fuelsupply > 0) {
                ItemStack iStack = new ItemStack((Item)HTGRMaterials.aHTGR_Materials, this.fuelsupply, HTGRMaterials.MATERIALS_PER_FUEL * this.fueltype + 4);
                boolean storedAll = false;
                for (GT_MetaTileEntity_Hatch_OutputBus tHatch : this.mOutputBusses) {
                    if (!GT_TileEntity_HTGR.isValidMetaTileEntity((MetaTileEntity)tHatch) || !tHatch.storeAll(iStack)) continue;
                    storedAll = true;
                    break;
                }
                if (!storedAll) {
                    if (this.fuelsupply == iStack.field_77994_a) {
                        ++this.emptyticksnodiff;
                    } else {
                        this.fuelsupply = iStack.field_77994_a;
                        this.emptyticksnodiff = 0;
                    }
                } else {
                    this.fuelsupply = 0;
                    this.fueltype = -1;
                    this.coolanttaking = 0;
                }
            }
            return true;
        }
        if (!super.onRunningTick(aStack)) {
            return false;
        }
        if (this.runningtick % 20 == 0) {
            int takecoolant = this.coolanttaking;
            int drainedamount = 0;
            for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
                FluidStack tLiquid;
                if (!GT_TileEntity_HTGR.isValidMetaTileEntity((MetaTileEntity)tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(FluidRegistry.getFluidStack((String)"ic2coolant", (int)1))) continue;
                FluidStack drained = tHatch.drain(takecoolant, true);
                drainedamount += drained.amount;
                if ((takecoolant -= drained.amount) > 0) continue;
                break;
            }
            if (drainedamount > 0) {
                this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)drainedamount));
            }
            this.updateSlots();
            if (takecoolant > 0) {
                this.stopMachine();
            }
        }
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_HTGR(this.mName);
    }

    public String[] getInfoData() {
        return new String[]{"Mode:", this.empty ? "Emptying" : "Normal", "Progress:", GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + "s / " + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + "s", "Fuel type:", this.fueltype == -1 ? "NONE" : "TRISO (" + HTGRMaterials.sHTGR_Fuel[this.fueltype].sEnglish + ")", "Fuel amount:", GT_Utility.formatNumbers((long)this.fuelsupply) + " pcs.", "Helium-Level:", GT_Utility.formatNumbers((long)this.HeliumSupply) + "L / " + GT_Utility.formatNumbers((long)730000L) + "L", "Coolant:", GT_Utility.formatNumbers((long)this.coolanttaking) + "L/s", "Problems:", String.valueOf(this.getIdealStatus() - this.getRepairStatus())};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)181), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)181), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)181)};
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"HTGR mode cannot be changed while the machine is running.");
            return;
        }
        this.empty = !this.empty;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("HTGR is now running in " + (this.empty ? "emptying mode." : "normal Operation")));
    }

    public static class HTGRMaterials {
        static final Base_[] sHTGR_Bases = new Base_[]{new Base_("HTGRFuelMixture", "HTGR fuel mixture"), new Base_("BISOPebbleCompound", "BISO pebble compound"), new Base_("TRISOPebbleCompound", "TRISO pebble compound"), new Base_("TRISOBall", "TRISO ball"), new Base_("TRISOPebble", "TRISO pebble"), new Base_("BurnedOutTRISOBall", "Burned out TRISO Ball"), new Base_("BurnedOutTRISOPebble", "Burned out TRISO Pebble")};
        static final int MATERIALS_PER_FUEL = sHTGR_Bases.length;
        static final int USABLE_FUEL_INDEX = 4;
        static final int BURNED_OUT_FUEL_INDEX = 5;
        static final Fuel_[] sHTGR_Fuel = new Fuel_[]{new Fuel_("Thorium", "Thorium", WerkstoffLoader.Thorium232.get(OrePrefixes.dust, 64), Materials.Uranium235.getDust(4), GT_Values.NF, new ItemStack[]{Materials.Silicon.getDust(1), Materials.Graphite.getDust(1), Materials.Carbon.getDust(1), Materials.Lutetium.getDust(1), WerkstoffLoader.Thorium232.get(OrePrefixes.dust, 1)}, new int[]{9000, 9000, 9000, 9000, 1000}, "Multiplies coolant by 1"), new Fuel_("Uranium", "Uranium", Materials.Uranium.getDust(64), Materials.Uranium235.getDust(8), FluidRegistry.getFluidStack((String)"krypton", (int)8), new ItemStack[]{Materials.Silicon.getDust(1), Materials.Graphite.getDust(1), Materials.Carbon.getDust(1), Materials.Lead.getDust(1), Materials.Uranium.getDust(1)}, new int[]{9000, 9000, 9000, 7000, 1000}, "Multiplies coolant by 1.5"), new Fuel_("Plutonium", "Plutonium", Materials.Plutonium.getDust(64), Materials.Plutonium241.getDust(4), FluidRegistry.getFluidStack((String)"xenon", (int)8), new ItemStack[]{Materials.Silicon.getDust(1), Materials.Graphite.getDust(1), Materials.Carbon.getDust(1), Materials.Lead.getDust(1), Materials.Plutonium.getDust(1)}, new int[]{9000, 9000, 9000, 7000, 1000}, "Multiplies coolant by 2")};
        static final CustomHTGRSimpleSubItemClass aHTGR_Materials;
        static final ArrayList<LangEntry_> aHTGR_Localizations;

        public static void registeraTHR_Materials() {
            for (LangEntry_ iName : aHTGR_Localizations) {
                GT_LanguageManager.addStringLocalization((String)iName.sName, (String)iName.sEnglish);
            }
            GameRegistry.registerItem((Item)aHTGR_Materials, (String)"bw.HTGRMaterials");
        }

        public static void registerTHR_Recipes() {
            GT_Values.RA.addAssemblerRecipe(new ItemStack[]{new ItemStack(GregTech_API.sBlockCasings3, 1, 12), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Europium, (long)6L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.Europium, (long)24L)}, Materials.Lead.getMolten(1296L), new ItemStack(GregTech_API.sBlockCasings8, 1, 5), 200, BW_Util.getMachineVoltageFromTier(6));
            int i = 0;
            for (Fuel_ fuel : sHTGR_Fuel) {
                GT_Values.RA.addMixerRecipe(fuel.mainItem, fuel.secondaryItem, GT_Utility.getIntegratedCircuit((int)1), null, null, null, new ItemStack((Item)aHTGR_Materials, 1, i), 400, 30);
                GT_Values.RA.addFormingPressRecipe(new ItemStack((Item)aHTGR_Materials, 1, i), Materials.Carbon.getDust(64), new ItemStack((Item)aHTGR_Materials, 1, i + 1), 40, 30);
                GT_Values.RA.addFormingPressRecipe(new ItemStack((Item)aHTGR_Materials, 1, i + 1), Materials.Silicon.getDust(64), new ItemStack((Item)aHTGR_Materials, 1, i + 2), 40, 30);
                GT_Values.RA.addFormingPressRecipe(new ItemStack((Item)aHTGR_Materials, 1, i + 2), Materials.Graphite.getDust(64), new ItemStack((Item)aHTGR_Materials, 1, i + 3), 40, 30);
                GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aHTGR_Materials, 1, i + 3), GT_Utility.getIntegratedCircuit((int)17)}, new ItemStack[]{new ItemStack((Item)aHTGR_Materials, 64, i + 4)}, null, null, null, null, 32000, 30, 0);
                GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.addRecipe(false, new ItemStack[]{new ItemStack((Item)aHTGR_Materials, 1, i + 5), GT_Utility.getIntegratedCircuit((int)17)}, new ItemStack[]{new ItemStack((Item)aHTGR_Materials, 64, i + 6)}, null, null, null, null, 48000, 30, 0);
                GT_Values.RA.addCentrifugeRecipe(new ItemStack((Item)aHTGR_Materials, 1, i + 6), GT_Values.NI, GT_Values.NF, fuel.recycledFluid, fuel.recycledItems[0], fuel.recycledItems[1], fuel.recycledItems[2], fuel.recycledItems[3], fuel.recycledItems[4], fuel.recycledItems[5], fuel.recycleChances, 1200, 30);
                i += sHTGR_Bases.length;
            }
        }

        static {
            aHTGR_Localizations = new ArrayList();
            String[] sHTGR_Materials = new String[sHTGR_Bases.length * sHTGR_Fuel.length];
            HashMap<Integer, String> tooltip = new HashMap<Integer, String>();
            int i = 0;
            for (Fuel_ fuel : sHTGR_Fuel) {
                for (Base_ base : sHTGR_Bases) {
                    sHTGR_Materials[i] = "HTGR" + base.sName + fuel.sName;
                    aHTGR_Localizations.add(new LangEntry_("item." + sHTGR_Materials[i] + ".name", base.sEnglish + " (" + fuel.sEnglish + ")"));
                    if ((i + 1) % MATERIALS_PER_FUEL == 5 && fuel.tooltip != null && fuel.tooltip != "") {
                        tooltip.put(i, fuel.tooltip);
                    }
                    ++i;
                }
            }
            aHTGR_Materials = new CustomHTGRSimpleSubItemClass(tooltip, sHTGR_Materials);
        }

        private static class LangEntry_ {
            public String sName;
            public String sEnglish;

            public LangEntry_(String a, String b) {
                this.sName = a;
                this.sEnglish = b;
            }
        }

        static class Fuel_ {
            public String sName;
            public String sEnglish;
            public ItemStack mainItem;
            public ItemStack secondaryItem;
            public ItemStack[] recycledItems = new ItemStack[]{GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI};
            public FluidStack recycledFluid;
            public int[] recycleChances;
            public String tooltip;

            public Fuel_(String sName, String sEnglish, ItemStack mainItem, ItemStack secondaryItem, FluidStack recycledFluid, ItemStack[] recycledItems, int[] recycleChances, String tooltip) {
                this.sName = sName;
                this.sEnglish = sEnglish;
                this.mainItem = mainItem;
                this.secondaryItem = secondaryItem;
                this.recycledFluid = recycledFluid;
                for (int i = 0; i < recycledItems.length; ++i) {
                    this.recycledItems[i] = recycledItems[i];
                }
                this.recycleChances = recycleChances;
                this.tooltip = tooltip;
            }
        }

        private static class Base_ {
            public String sName;
            public String sEnglish;
            public String sTooltip;

            public Base_(String a, String b) {
                this.sName = a;
                this.sEnglish = b;
                this.sTooltip = "";
            }

            public Base_(String a, String b, String c) {
                this.sName = a;
                this.sEnglish = b;
                this.sTooltip = c;
            }
        }

        private static class CustomHTGRSimpleSubItemClass
        extends SimpleSubItemClass {
            HashMap<Integer, String> tooltip = null;

            public CustomHTGRSimpleSubItemClass(HashMap<Integer, String> tooltip, String ... tex) {
                super(tex);
                this.tooltip = tooltip;
            }

            @Override
            public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
                if (this.tooltip.containsKey(this.getDamage(p_77624_1_))) {
                    aList.add(this.tooltip.get(this.getDamage(p_77624_1_)));
                }
                aList.add("Material for High Temperature Gas-cooled Reactor");
                super.func_77624_a(p_77624_1_, p_77624_2_, aList, p_77624_4_);
            }
        }
    }
}

