/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.client.renderer.RendererGlasBlock;
import com.github.bartimaeusnek.bartworks.client.renderer.RendererSwitchingColorFluid;
import com.github.bartimaeusnek.bartworks.common.blocks.BioFluidBlock;
import com.github.bartimaeusnek.bartworks.common.tileentities.classic.BWTileEntityDimIDBridge;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.objects.GT_Fluid;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import ic2.core.item.ItemFluidCell;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidLoader {
    public static IIcon autogenIIcon;
    public static Fluid ff;
    public static int renderID;
    public static Block bioFluidBlock;
    public static Fluid[] BioLabFluidMaterials;
    public static ItemStack[] BioLabFluidCells;
    public static Fluid fulvicAcid;
    public static Fluid heatedfulvicAcid;
    public static Fluid Kerogen;

    public static void run() {
        renderID = RenderingRegistry.getNextAvailableRenderId();
        short[] rgb = new short[3];
        Arrays.fill(rgb, (short)255);
        ff = new GT_Fluid("BWfakeFluid", "molten.autogenerated", rgb);
        fulvicAcid = FluidLoader.createAndRegisterFluid("Fulvic Acid", new Color(20, 20, 20));
        heatedfulvicAcid = FluidLoader.createAndRegisterFluid("Heated Fulvic Acid", new Color(40, 20, 20), 720);
        Kerogen = FluidLoader.createAndRegisterFluid("Kerogen", new Color(85, 85, 85));
        BioLabFluidMaterials = new Fluid[]{new GT_Fluid("FluorecentdDNA", "molten.autogenerated", new short[]{125, 50, 170, 0}), new GT_Fluid("EnzymesSollution", "molten.autogenerated", new short[]{240, 200, 125, 0}), new GT_Fluid("Penicillin", "molten.autogenerated", new short[]{255, 255, 255, 0}), new GT_Fluid("Polymerase", "molten.autogenerated", new short[]{110, 180, 110, 0})};
        BioLabFluidCells = new ItemStack[BioLabFluidMaterials.length];
        for (int i = 0; i < BioLabFluidMaterials.length; ++i) {
            FluidRegistry.registerFluid((Fluid)BioLabFluidMaterials[i]);
            FluidLoader.BioLabFluidCells[i] = ItemFluidCell.getUniversalFluidCell((FluidStack)new FluidStack(BioLabFluidMaterials[i], 1000));
        }
        FluidStack dnaFluid = LoaderReference.gendustry ? FluidRegistry.getFluidStack((String)"liquiddna", (int)100) : Materials.Biomass.getFluid(100L);
        for (BioCulture B : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            if (!B.isBreedable()) continue;
            B.setFluid((Fluid)new GT_Fluid(B.getName().replaceAll(" ", "").toLowerCase() + "fluid", "molten.autogenerated", new short[]{(short)B.getColor().getRed(), (short)B.getColor().getBlue(), (short)B.getColor().getGreen()}));
            FluidRegistry.registerFluid((Fluid)B.getFluid());
            GT_LanguageManager.addStringLocalization((String)B.getFluid().getUnlocalizedName(), (String)(B.getLocalisedName() + " Fluid"));
            GT_Values.RA.addCentrifugeRecipe(GT_Utility.getIntegratedCircuit((int)10), GT_Values.NI, new FluidStack(B.getFluid(), 1000), dnaFluid, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, null, 500, 120);
        }
        bioFluidBlock = new BioFluidBlock();
        GameRegistry.registerBlock((Block)bioFluidBlock, (String)"coloredFluidBlock");
        GameRegistry.registerTileEntity(BWTileEntityDimIDBridge.class, (String)"bwTEDimIDBridge");
        if (SideReference.Side.Client) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)RendererSwitchingColorFluid.instance);
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)RendererGlasBlock.instance);
        }
    }

    public static Fluid createAndRegisterFluid(String Name, Color color) {
        GT_Fluid f = new GT_Fluid(Name, "molten.autogenerated", new short[]{(short)color.getRed(), (short)color.getGreen(), (short)color.getBlue(), (short)color.getAlpha()});
        GT_LanguageManager.addStringLocalization((String)f.getUnlocalizedName(), (String)Name);
        FluidRegistry.registerFluid((Fluid)f);
        return f;
    }

    public static Fluid createAndRegisterFluid(String Name, Color color, int temperature) {
        GT_Fluid f = new GT_Fluid(Name, "molten.autogenerated", new short[]{(short)color.getRed(), (short)color.getGreen(), (short)color.getBlue(), (short)color.getAlpha()});
        GT_LanguageManager.addStringLocalization((String)f.getUnlocalizedName(), (String)Name);
        f.setTemperature(temperature);
        FluidRegistry.registerFluid((Fluid)f);
        return f;
    }
}

