/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.worldgen;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.worldgen.GT_WorldgenUtil;
import com.github.bartimaeusnek.bartworks.util.Pair;
import gregtech.api.GregTech_API;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Utility;
import java.security.SecureRandom;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;

public abstract class MapGenRuins
extends WorldGenerator {
    protected Pair<Block, Integer>[][] ToBuildWith = new Pair[4][0];
    int[] statBlocks = new int[4];

    public boolean generate(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        return false;
    }

    protected void setFloorBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[0] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[0][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setWallBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[1] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[1][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setRoofBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[2] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[2][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setMiscBlocks(int[] metas, Block ... blocks) {
        this.ToBuildWith[3] = new Pair[metas.length];
        for (int i = 0; i < metas.length; ++i) {
            this.ToBuildWith[3][i] = new Pair<Block, Integer>(blocks[i % blocks.length], metas[i]);
        }
    }

    protected void setRandomBlockWAirChance(World worldObj, int x, int y, int z, Random rand, int airchance, Pair<Block, Integer> ... blocks) {
        if (rand.nextInt(100) > airchance) {
            this.setRandomBlock(worldObj, x, y, z, rand, blocks);
        } else {
            this.setBlock(worldObj, x, y, z, Blocks.air, 0);
        }
    }

    protected void setRandomBlock(World worldObj, int x, int y, int z, Random rand, Pair<Block, Integer> ... blocks) {
        Block toSet = blocks[rand.nextInt(blocks.length)].getKey();
        int meta = blocks[rand.nextInt(blocks.length)].getValue();
        this.setBlock(worldObj, x, y, z, toSet, meta);
    }

    protected void setBlock(World worldObj, int x, int y, int z, Block block, int meta) {
        this.setBlockAndNotifyAdequately(worldObj, x, y, z, block, meta);
    }

    protected void setBlock(World worldObj, int x, int y, int z, Pair<Block, Integer> pair) {
        this.setBlockAndNotifyAdequately(worldObj, x, y, z, pair.getKey(), pair.getValue());
    }

    public static class RuinsBase
    extends MapGenRuins {
        @Override
        public boolean generate(World worldObj, Random rand1, int x, int y, int z) {
            BaseMetaTileEntity BTE;
            for (int i = 0; i < rand1.nextInt(144); ++i) {
                rand1.nextLong();
            }
            XSTR rand = new XSTR(rand1.nextLong());
            SecureRandom secureRandom = new SecureRandom();
            if (worldObj.getBlock(x += 5, y, z += 5) == Blocks.air) {
                while (worldObj.getBlock(x, y, z) == Blocks.air) {
                    --y;
                }
            } else {
                while (worldObj.getBlock(x, y, z) != Blocks.air) {
                    ++y;
                }
                --y;
            }
            this.setFloorBlocks(new int[]{0, 0, 0}, new Block[]{Blocks.brick_block, Blocks.double_stone_slab, Blocks.stonebrick});
            this.setWallBlocks(new int[]{0, 1, 2, 1, 1}, Blocks.stonebrick);
            this.setRoofBlocks(new int[]{9}, Blocks.log);
            this.setMiscBlocks(new int[]{1}, Blocks.log);
            this.statBlocks = new int[]{rand.nextInt(this.ToBuildWith[0].length)};
            int colored = rand.nextInt(15);
            int tier = secureRandom.nextInt(ConfigHandler.maxTierRoss);
            boolean useColor = rand.nextBoolean();
            byte set = 0;
            byte toSet = (byte)(rand.nextInt(ConfigHandler.maxTierRoss - tier) + 1);
            short cablemeta = GT_WorldgenUtil.getCable(secureRandom, tier);
            int treeinaRow = 0;
            boolean lastset = rand.nextBoolean();
            for (int dx = -6; dx <= 6; ++dx) {
                for (int dy = 0; dy <= 8; ++dy) {
                    for (int dz = -6; dz <= 6; ++dz) {
                        this.setBlock(worldObj, x + dx, y + dy, z + dz, Blocks.air, 0);
                        if (dy == 0) {
                            Pair floor = this.ToBuildWith[0][this.statBlocks[0]];
                            this.setBlock(worldObj, x + dx, y + 0, z + dz, (Block)floor.getKey(), (Integer)floor.getValue());
                            continue;
                        }
                        if (dy > 0 && dy < 4) {
                            if (Math.abs(dx) == 5 && Math.abs(dz) == 5) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 5, this.ToBuildWith[3][0]);
                            } else if (dx == 0 && dz == -5 && (dy == 1 || dy == 2)) {
                                if (dy == 1) {
                                    this.setBlock(worldObj, x + dx, y + 1, z + -5, Blocks.iron_door, 1);
                                }
                                if (dy == 2) {
                                    this.setBlock(worldObj, x + dx, y + 2, z + dz, Blocks.iron_door, 8);
                                }
                            } else if (Math.abs(dx) == 5 && Math.abs(dz) < 5 || Math.abs(dz) == 5 && Math.abs(dx) < 5) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 25, this.ToBuildWith[1]);
                                if (dy == 2 && rand.nextInt(100) < 12) {
                                    if (useColor) {
                                        this.setRandomBlockWAirChance(worldObj, x + dx, y + 2, z + dz, (Random)rand, 25, new Pair<BlockStainedGlassPane, Integer>(Blocks.stained_glass_pane, colored));
                                    } else {
                                        this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 25, new Pair<Block, Integer>(Blocks.glass_pane, 0));
                                    }
                                }
                            }
                            if (dy == 3 && Math.abs(dx) == 6) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 3, z + dz, (Random)rand, 25, this.ToBuildWith[2]);
                            }
                            if (dy != 1) continue;
                            if (dx == 3 && dz == -3) {
                                this.setBlock(worldObj, x + 3, y + 1, z + dz, Blocks.crafting_table, 0);
                            }
                            if (dx == -3 && (dz == -3 || dz == -2)) {
                                this.setBlock(worldObj, x + -3, y + dy, z + dz, (Block)Blocks.chest, 5);
                                IInventory chest = (IInventory)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                                if (chest != null) {
                                    WeightedRandomChestContent.generateChestContents((Random)secureRandom, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"pyramidJungleChest", (Random)rand), (IInventory)chest, (int)ChestGenHooks.getCount((String)"pyramidJungleChest", (Random)rand));
                                }
                            }
                            if (dx == 4 && dz == 4) {
                                short meta = GT_WorldgenUtil.getGenerator(secureRandom, tier);
                                this.setBlock(worldObj, x + 4, y + dy, z + dz, GT_WorldgenUtil.GT_TILES, GregTech_API.METATILEENTITIES[meta].getTileEntityBaseType());
                                BTE = (BaseMetaTileEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                                BTE.setInitialValuesAsNBT(null, meta);
                                BTE.setOwnerName("Ancient Cultures");
                                BTE.setFrontFacing(tier > 0 ? (byte)4 : 2);
                                continue;
                            }
                            if (dx == 3 && dz == 4) {
                                if (tier > 0) {
                                    short meta = GT_WorldgenUtil.getBuffer(secureRandom, tier);
                                    this.setBlock(worldObj, x + 3, y + dy, z + dz, GT_WorldgenUtil.GT_TILES, GregTech_API.METATILEENTITIES[meta].getTileEntityBaseType());
                                    BTE = (BaseMetaTileEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                                    BTE.setInitialValuesAsNBT(null, meta);
                                    BTE.setOwnerName("Ancient Cultures");
                                    BTE.setFrontFacing((byte)4);
                                    continue;
                                }
                                short meta = cablemeta;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 33, new Pair<Block, Integer>(GT_WorldgenUtil.GT_TILES, Integer.valueOf(GregTech_API.METATILEENTITIES[meta].getTileEntityBaseType())));
                                BTE = (BaseMetaPipeEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                                if (BTE == null) continue;
                                BTE.setInitialValuesAsNBT(null, meta);
                                BTE.setOwnerName("Ancient Cultures");
                                BTE.setFrontFacing((byte)4);
                                BTE.mConnections = (byte)(BTE.mConnections | 0x10);
                                ((MetaPipeEntity)BTE.getMetaTileEntity()).mConnections = BTE.mConnections = (byte)(BTE.mConnections | 1 << GT_Utility.getOppositeSide((int)4));
                                continue;
                            }
                            if (dx < 3 && dx > -5 && dz == 4) {
                                short meta = cablemeta;
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + 4, (Random)rand, 33, new Pair<Block, Integer>(GT_WorldgenUtil.GT_TILES, Integer.valueOf(GregTech_API.METATILEENTITIES[meta].getTileEntityBaseType())));
                                BTE = (BaseMetaPipeEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                                if (BTE == null) continue;
                                BTE.setInitialValuesAsNBT(null, meta);
                                BTE.setOwnerName("Ancient Cultures");
                                BTE.setFrontFacing((byte)4);
                                BTE.mConnections = (byte)(BTE.mConnections | 0x10);
                                BTE.mConnections = (byte)(BTE.mConnections | 1 << GT_Utility.getOppositeSide((int)4));
                                BaseMetaTileEntity BPE = (BaseMetaTileEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz - 1);
                                if (BPE != null) {
                                    BTE.mConnections = (byte)(BTE.mConnections | 4);
                                }
                                ((MetaPipeEntity)BTE.getMetaTileEntity()).mConnections = BTE.mConnections;
                                continue;
                            }
                            if (dx >= 3 || dx <= -5 || dz != 3 || set >= toSet) continue;
                            if (!lastset || treeinaRow > 2) {
                                short meta = GT_WorldgenUtil.getMachine(secureRandom, tier);
                                this.setBlock(worldObj, x + dx, y + dy, z + 3, GT_WorldgenUtil.GT_TILES, GregTech_API.METATILEENTITIES[meta].getTileEntityBaseType());
                                BTE = (BaseMetaTileEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                                BTE.setInitialValuesAsNBT(null, meta);
                                BTE.setOwnerName("Ancient Cultures");
                                BTE.setFrontFacing((byte)2);
                                set = (byte)(set + 1);
                                treeinaRow = 0;
                                lastset = true;
                                continue;
                            }
                            lastset = rand.nextBoolean();
                            if (!lastset) continue;
                            treeinaRow = (byte)(treeinaRow + 1);
                            continue;
                        }
                        if (dy == 4) {
                            if (Math.abs(dx) == 5) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 4, z + dz, (Random)rand, 25, this.ToBuildWith[2]);
                                continue;
                            }
                            if (Math.abs(dz) != 5 || Math.abs(dx) >= 5) continue;
                            this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 25, this.ToBuildWith[1]);
                            continue;
                        }
                        if (dy == 5) {
                            if (Math.abs(dx) == 4) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 5, z + dz, (Random)rand, 25, this.ToBuildWith[2]);
                                continue;
                            }
                            if (Math.abs(dz) != 5 || Math.abs(dx) >= 4) continue;
                            this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 25, this.ToBuildWith[1]);
                            continue;
                        }
                        if (dy == 6) {
                            if (Math.abs(dx) == 3) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 6, z + dz, (Random)rand, 25, this.ToBuildWith[2]);
                                continue;
                            }
                            if (Math.abs(dz) != 5 || Math.abs(dx) >= 3) continue;
                            this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 25, this.ToBuildWith[1]);
                            continue;
                        }
                        if (dy == 7) {
                            if (Math.abs(dx) == 2) {
                                this.setRandomBlockWAirChance(worldObj, x + dx, y + 7, z + dz, (Random)rand, 25, this.ToBuildWith[2]);
                                continue;
                            }
                            if (Math.abs(dz) != 5 || Math.abs(dx) >= 2) continue;
                            this.setRandomBlockWAirChance(worldObj, x + dx, y + dy, z + dz, (Random)rand, 25, this.ToBuildWith[1]);
                            continue;
                        }
                        if (dy != 8 || Math.abs(dx) != 1 && Math.abs(dx) != 0) continue;
                        this.setRandomBlockWAirChance(worldObj, x + dx, y + 8, z + dz, (Random)rand, 25, this.ToBuildWith[2]);
                    }
                }
            }
            block6: while (set < toSet) {
                int dy = 1;
                int dz = 3;
                for (int dx = 2; dx > -5; --dx) {
                    if (set >= toSet) break block6;
                    if (!lastset || treeinaRow > 2 && worldObj.getTileEntity(x + dx, y + dy, z + dz) == null) {
                        short meta = GT_WorldgenUtil.getMachine(secureRandom, tier);
                        this.setBlock(worldObj, x + dx, y + dy, z + dz, GT_WorldgenUtil.GT_TILES, GregTech_API.METATILEENTITIES[meta].getTileEntityBaseType());
                        BTE = (BaseMetaTileEntity)worldObj.getTileEntity(x + dx, y + dy, z + dz);
                        BTE.setInitialValuesAsNBT(null, meta);
                        BTE.setOwnerName("Ancient Cultures");
                        BTE.setFrontFacing((byte)2);
                        set = (byte)(set + 1);
                        treeinaRow = 0;
                        lastset = true;
                        continue;
                    }
                    lastset = rand.nextBoolean();
                    if (!lastset) continue;
                    treeinaRow = (byte)(treeinaRow + 1);
                }
            }
            return true;
        }
    }
}

