/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.oredict;

import com.github.bartimaeusnek.bartworks.util.Pair;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.OrePrefixes;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictHandler {
    private static final HashMap<String, Pair<Integer, Short>> cache = new HashMap();
    private static final HashSet<Pair<Integer, Short>> cacheNonBW = new HashSet();

    public static HashMap<String, Pair<Integer, Short>> getCache() {
        return cache;
    }

    public static HashSet<Pair<Integer, Short>> getNonBWCache() {
        return cacheNonBW;
    }

    public static void adaptCacheForWorld() {
        HashSet<String> used = new HashSet<String>(cache.keySet());
        cache.clear();
        cacheNonBW.clear();
        for (String s : used) {
            if (OreDictionary.getOres((String)s).isEmpty()) continue;
            ItemStack tmpstack = ((ItemStack)OreDictionary.getOres((String)s).get(0)).copy();
            Pair<Integer, Short> p = new Pair<Integer, Short>(Item.getIdFromItem((Item)tmpstack.getItem()), (short)tmpstack.getItemDamage());
            cache.put(s, p);
            for (ItemStack tmp : OreDictionary.getOres((String)s)) {
                Pair<Integer, Short> p2 = new Pair<Integer, Short>(Item.getIdFromItem((Item)tmp.getItem()), (short)tmp.getItemDamage());
                GameRegistry.UniqueIdentifier UI = GameRegistry.findUniqueIdentifierFor((Item)tmp.getItem());
                if (UI == null) {
                    UI = GameRegistry.findUniqueIdentifierFor((Block)Block.getBlockFromItem((Item)tmp.getItem()));
                }
                if (UI.modId.equals("bartworks") || UI.modId.equals("bartworkscrossmod") || UI.modId.equals("BWCore")) continue;
                cacheNonBW.add(p2);
            }
        }
    }

    public static ItemStack getItemStack(String elementName, OrePrefixes prefixes, int amount) {
        if (cache.get(prefixes + elementName.replaceAll(" ", "")) != null) {
            Pair<Integer, Short> p = cache.get(prefixes + elementName.replaceAll(" ", ""));
            return new ItemStack(Item.getItemById((int)p.getKey()), amount, (int)p.getValue().shortValue());
        }
        if (!OreDictionary.getOres((String)(prefixes + elementName.replaceAll(" ", ""))).isEmpty()) {
            ItemStack tmp = ((ItemStack)OreDictionary.getOres((String)(prefixes + elementName.replaceAll(" ", ""))).get(0)).copy();
            cache.put(prefixes + elementName.replaceAll(" ", ""), new Pair<Integer, Short>(Item.getIdFromItem((Item)tmp.getItem()), (short)tmp.getItemDamage()));
            tmp.stackSize = amount;
            return tmp;
        }
        return null;
    }
}

