/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.API.WerkstoffAdderRegistry;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.client.renderer.BW_Renderer_Block_Ores;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlock_Item;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedSmallOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Items;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Ores;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_SmallOres;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_WerkstoffBlock_TE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_WerkstoffBlocks;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_CircuitsLoader;
import com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement.GTMetaItemEnhancer;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.AdditionalRecipes;
import com.github.bartimaeusnek.bartworks.system.oredict.OreDictHandler;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.log.DebugLog;
import com.github.bartimaeusnek.crossmod.cls.CLSCompat;
import com.github.bartimaeusnek.crossmod.thaumcraft.util.ThaumcraftHandler;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enchants.Enchantment_Radioactivity;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.objects.GT_Fluid;
import gregtech.api.objects.GT_MultiTexture;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import gregtech.common.covers.GT_Cover_Lens;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class WerkstoffLoader {
    public static final SubTag NOBLE_GAS = SubTag.getNewSubTag((String)"NobleGas");
    public static final SubTag ANAEROBE_GAS = SubTag.getNewSubTag((String)"AnaerobeGas");
    public static final SubTag ANAEROBE_SMELTING = SubTag.getNewSubTag((String)"AnaerobeSmelting");
    public static final SubTag NOBLE_GAS_SMELTING = SubTag.getNewSubTag((String)"NobleGasSmelting");
    public static final SubTag NO_BLAST = SubTag.getNewSubTag((String)"NoBlast");
    public static OrePrefixes cellMolten;
    public static OrePrefixes capsuleMolten;
    public static ItemList rotorMold;
    public static ItemList rotorShape;
    public static ItemList smallGearShape;
    public static ItemList ringMold;
    public static ItemList boltMold;
    public static boolean gtnhGT;
    public static final Werkstoff Bismutite;
    public static final Werkstoff Bismuthinit;
    public static final Werkstoff Zirconium;
    public static final Werkstoff CubicZirconia;
    public static final Werkstoff FluorBuergerit;
    public static final Werkstoff YttriumOxide;
    public static final Werkstoff ChromoAluminoPovondrait;
    public static final Werkstoff VanadioOxyDravit;
    public static final Werkstoff Olenit;
    public static final Werkstoff Arsenopyrite;
    public static final Werkstoff Ferberite;
    public static final Werkstoff Loellingit;
    public static final Werkstoff Roquesit;
    public static final Werkstoff Bornite;
    public static final Werkstoff Wittichenit;
    public static final Werkstoff Djurleit;
    public static final Werkstoff Huebnerit;
    public static final Werkstoff Thorianit;
    public static final Werkstoff RedZircon;
    public static final Werkstoff Salt;
    public static final Werkstoff Spodumen;
    public static final Werkstoff RockSalt;
    public static final Werkstoff Fayalit;
    public static final Werkstoff Forsterit;
    public static final Werkstoff Hedenbergit;
    public static final Werkstoff DescloiziteZNVO4;
    public static final Werkstoff DescloiziteCUVO4;
    public static final Werkstoff FuchsitAL;
    public static final Werkstoff FuchsitCR;
    public static final Werkstoff Thorium232;
    public static final Werkstoff BismuthTellurite;
    public static final Werkstoff Tellurium;
    public static final Werkstoff BismuthHydroBorat;
    public static final Werkstoff ArInGaPhoBiBoTe;
    public static final Werkstoff Prasiolite;
    public static final Werkstoff MagnetoResonaticDust;
    public static final Werkstoff Xenon;
    public static final Werkstoff Oganesson;
    public static final Werkstoff Californium;
    public static final Werkstoff Calcium;
    public static final Werkstoff Neon;
    public static final Werkstoff Krypton;
    public static final Werkstoff BArTiMaEuSNeK;
    public static final Werkstoff PTConcentrate;
    public static final Werkstoff PTSaltCrude;
    public static final Werkstoff PTSaltRefined;
    public static final Werkstoff PTMetallicPowder;
    public static final Werkstoff AquaRegia;
    public static final Werkstoff PTResidue;
    public static final Werkstoff AmmoniumChloride;
    public static final Werkstoff PTRawPowder;
    public static final Werkstoff PDAmmonia;
    public static final Werkstoff PDMetallicPowder;
    public static final Werkstoff PDRawPowder;
    public static final Werkstoff PDSalt;
    public static final Werkstoff Sodiumformate;
    public static final Werkstoff Sodiumsulfate;
    public static final Werkstoff FormicAcid;
    public static final Werkstoff PotassiumDisulfate;
    public static final Werkstoff LeachResidue;
    public static final Werkstoff RHSulfate;
    public static final Werkstoff RHSulfateSolution;
    public static final Werkstoff CalciumChloride;
    public static final Werkstoff Ruthenium;
    public static final Werkstoff SodiumRuthenate;
    public static final Werkstoff RutheniumTetroxide;
    public static final Werkstoff HotRutheniumTetroxideSollution;
    public static final Werkstoff RutheniumTetroxideSollution;
    public static final Werkstoff IrOsLeachResidue;
    public static final Werkstoff IrLeachResidue;
    public static final Werkstoff PGSDResidue;
    public static final Werkstoff AcidicOsmiumSolution;
    public static final Werkstoff IridiumDioxide;
    public static final Werkstoff OsmiumSolution;
    public static final Werkstoff AcidicIridiumSolution;
    public static final Werkstoff IridiumChloride;
    public static final Werkstoff PGSDResidue2;
    public static final Werkstoff Rhodium;
    public static final Werkstoff CrudeRhMetall;
    public static final Werkstoff RHSalt;
    public static final Werkstoff RHSaltSolution;
    public static final Werkstoff SodiumNitrate;
    public static final Werkstoff RHNitrate;
    public static final Werkstoff ZincSulfate;
    public static final Werkstoff RhFilterCake;
    public static final Werkstoff RHFilterCakeSolution;
    public static final Werkstoff ReRh;
    public static final Werkstoff LuVTierMaterial;
    public static final Werkstoff Tiberium;
    public static final Werkstoff Ruridit;
    public static final Werkstoff Fluorspar;
    public static final Werkstoff HDCS;
    public static final Werkstoff Atheneite;
    public static final Werkstoff Temagamite;
    public static final Werkstoff Terlinguaite;
    public static final Werkstoff AdemicSteel;
    public static final Werkstoff RawAdemicSteel;
    public static HashMap<OrePrefixes, BW_MetaGenerated_Items> items;
    public static HashBiMap<Werkstoff, Fluid> fluids;
    public static HashBiMap<Werkstoff, Fluid> molten;
    public static Block BWOres;
    public static Block BWSmallOres;
    public static Block BWBlocks;
    public static boolean registered;
    public static final HashSet<OrePrefixes> ENABLED_ORE_PREFIXES;
    public static int toGenerateGlobal;

    private WerkstoffLoader() {
    }

    public static void setUp() {
        try {
            gtnhGT = GT_MetaGenerated_Tool_01.class.getField("SOLDERING_IRON_MV") != null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (OrePrefixes prefix : OrePrefixes.values()) {
            if (!prefix.toString().equals("cellMolten")) continue;
            cellMolten = prefix;
            break;
        }
        if (cellMolten == null) {
            cellMolten = (OrePrefixes)EnumHelper.addEnum(OrePrefixes.class, (String)"cellMolten", (Class[])new Class[]{String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{"Cells of Molten stuff", "Molten ", " Cell", true, true, true, true, false, false, false, true, false, false, 64, 3628800L, 64, 31});
        } else {
            WerkstoffLoader.cellMolten.mMaterialGenerationBits = 64;
        }
        try {
            rotorMold = Enum.valueOf(ItemList.class, "Shape_Mold_Rotor");
            rotorShape = Enum.valueOf(ItemList.class, "Shape_Extruder_Rotor");
            smallGearShape = Enum.valueOf(ItemList.class, "Shape_Extruder_Small_Gear");
            ringMold = Enum.valueOf(ItemList.class, "Shape_Mold_Ring");
            boltMold = Enum.valueOf(ItemList.class, "Shape_Mold_Bolt");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        Element t = BW_Util.createNewElement("Tr", 123L, 203L, 0L, -1L, null, "Tiberium", false);
        if (LoaderReference.Forestry) {
            capsuleMolten = (OrePrefixes)EnumHelper.addEnum(OrePrefixes.class, (String)"capsuleMolten", (Class[])new Class[]{String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{"Capsule of Molten stuff", "Molten ", " Capsule", true, true, true, true, false, false, false, true, false, false, 64, 3628800L, 64, -1});
            OrePrefixes.capsule.mMaterialGenerationBits = 32;
            OrePrefixes.capsule.mDefaultStackSize = (byte)64;
        }
        OrePrefixes.bottle.mDefaultStackSize = 1;
        Werkstoff.GenerationFeatures.initPrefixLogic();
    }

    public static Werkstoff getWerkstoff(String Name) {
        try {
            Field f = WerkstoffLoader.class.getField(Name);
            if (f != null) {
                return (Werkstoff)f.get(null);
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return Werkstoff.default_null_Werkstoff;
    }

    public static ItemStack getCorrespondingItemStack(OrePrefixes orePrefixes, Werkstoff werkstoff) {
        return WerkstoffLoader.getCorrespondingItemStack(orePrefixes, werkstoff, 1);
    }

    private static ItemStack getCorrespondingItemStackUnsafe(OrePrefixes orePrefixes, Werkstoff werkstoff, int amount) {
        ItemStack ret;
        if (!werkstoff.getGenerationFeatures().enforceUnification && (ret = OreDictHandler.getItemStack(werkstoff.getVarName(), orePrefixes, amount)) != null) {
            return ret;
        }
        if (orePrefixes == OrePrefixes.ore) {
            return new ItemStack(BWOres, amount, (int)werkstoff.getmID());
        }
        if (orePrefixes == OrePrefixes.oreSmall) {
            return new ItemStack(BWSmallOres, amount, (int)werkstoff.getmID());
        }
        if (orePrefixes == OrePrefixes.block) {
            return new ItemStack(BWBlocks, amount, (int)werkstoff.getmID());
        }
        if (items.get(orePrefixes) == null) {
            return null;
        }
        return new ItemStack((Item)items.get(orePrefixes), amount, (int)werkstoff.getmID()).copy();
    }

    public static ItemStack getCorrespondingItemStack(OrePrefixes orePrefixes, Werkstoff werkstoff, int amount) {
        ItemStack stack = WerkstoffLoader.getCorrespondingItemStackUnsafe(orePrefixes, werkstoff, amount);
        if (stack != null) {
            return stack;
        }
        MainMod.LOGGER.catching(Level.ERROR, (Throwable)new Exception("NO SUCH ITEM! " + orePrefixes + werkstoff.getVarName() + " If you encounter this as a user, make sure to contact the authors of the pack/the mods you're playing! If you are a Developer, you forgot to enable " + orePrefixes + " OrePrefix for Werkstoff " + werkstoff.getDefaultName()));
        return new ItemStack((Item)items.get(orePrefixes), amount, (int)werkstoff.getmID()).copy();
    }

    public static void runInit() {
        MainMod.LOGGER.info("Making Meta Items for BW Materials");
        long timepre = System.nanoTime();
        WerkstoffAdderRegistry.run();
        WerkstoffLoader.addSubTags();
        WerkstoffLoader.addItemsForGeneration();
        WerkstoffLoader.runAdditionalOreDict();
        long timepost = System.nanoTime();
        MainMod.LOGGER.info("Making Meta Items for BW Materials took " + (timepost - timepre) + "ns/" + (timepost - timepre) / 1000000L + "ms/" + (timepost - timepre) / 1000000000L + "s!");
    }

    public static void run() {
        if (!registered) {
            MainMod.LOGGER.info("Loading Processing Recipes for BW Materials");
            long timepre = System.nanoTime();
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Register BW Materials", (int)(Werkstoff.werkstoffHashSet.size() + 1));
            DebugLog.log("Loading Recipes" + (System.nanoTime() - timepre));
            Integer[] clsArr = new Integer[]{};
            int size = 0;
            if (LoaderReference.betterloadingscreen) {
                clsArr = CLSCompat.initCls();
            }
            for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
                long timepreone = System.nanoTime();
                DebugLog.log("Werkstoff is null or id < 0 ? " + (werkstoff == null || werkstoff.getmID() < 0) + " " + (System.nanoTime() - timepreone));
                if (werkstoff == null || werkstoff.getmID() < 0) {
                    progressBar.step("");
                    continue;
                }
                if (LoaderReference.betterloadingscreen) {
                    size = CLSCompat.invokeStepSize(werkstoff, clsArr, size);
                }
                DebugLog.log("Werkstoff: " + werkstoff.getDefaultName() + " " + (System.nanoTime() - timepreone));
                DebugLog.log("Loading Dusts Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addDustRecipes(werkstoff);
                DebugLog.log("Loading Gem Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addGemRecipes(werkstoff);
                DebugLog.log("Loading Ore Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addOreRecipes(werkstoff);
                DebugLog.log("Loading Crushed Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addCrushedRecipes(werkstoff);
                DebugLog.log("Loading Cell Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addCellRecipes(werkstoff);
                DebugLog.log("Loading Meltdown Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addMoltenRecipes(werkstoff);
                DebugLog.log("Loading Simple MetalWorking Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addSimpleMetalRecipes(werkstoff);
                DebugLog.log("Loading Crafting MetalWorking Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addCraftingMetalRecipes(werkstoff);
                DebugLog.log("Loading MultipleIngots MetalWorking Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addMultipleMetalRecipes(werkstoff);
                DebugLog.log("Loading Metal Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addMetalRecipes(werkstoff);
                DebugLog.log("Loading Block Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addBlockRecipes(werkstoff);
                DebugLog.log("Loading Tool Recipes " + (System.nanoTime() - timepreone));
                WerkstoffLoader.addTools(werkstoff);
                if (LoaderReference.Thaumcraft) {
                    DebugLog.log("Loading Aspects " + (System.nanoTime() - timepreone));
                    WerkstoffLoader.addAspectToAll(werkstoff);
                }
                DebugLog.log("Loading New Circuits " + (System.nanoTime() - timepreone));
                new BW_CircuitsLoader();
                DebugLog.log("Done " + (System.nanoTime() - timepreone));
                progressBar.step(werkstoff.getDefaultName());
            }
            if (LoaderReference.betterloadingscreen) {
                CLSCompat.disableCls();
            }
            progressBar.step("Load Additional Recipes");
            AdditionalRecipes.run();
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
            long timepost = System.nanoTime();
            MainMod.LOGGER.info("Loading Processing Recipes for BW Materials took " + (timepost - timepre) + "ns/" + (timepost - timepre) / 1000000L + "ms/" + (timepost - timepre) / 1000000000L + "s!");
            registered = true;
        }
    }

    private static void addSubTags() {
        CubicZirconia.getStats().setDurOverride(Materials.Diamond.mDurability);
        HDCS.getStats().setSpeedOverride(Materials.HSSS.mToolSpeed);
        HDCS.getStats().setDurMod(10.0f);
        Materials.Helium.add(new SubTag[]{NOBLE_GAS});
        Neon.add(NOBLE_GAS);
        Materials.Argon.add(new SubTag[]{NOBLE_GAS});
        Krypton.add(NOBLE_GAS);
        Xenon.add(NOBLE_GAS, ANAEROBE_GAS);
        Materials.Radon.add(new SubTag[]{NOBLE_GAS});
        Oganesson.add(NOBLE_GAS, ANAEROBE_GAS);
        Materials.Nitrogen.add(new SubTag[]{ANAEROBE_GAS});
        Calcium.add(ANAEROBE_SMELTING);
        LuVTierMaterial.add(NOBLE_GAS_SMELTING);
        Ruridit.add(NOBLE_GAS_SMELTING);
        AdemicSteel.add(NOBLE_GAS_SMELTING);
        MagnetoResonaticDust.add(NO_BLAST);
        Materials.Calcium.mBlastFurnaceRequired = true;
        Materials.Salt.mDurability = Salt.getDurability();
        Materials.Spodumene.mDurability = Spodumen.getDurability();
        Materials.RockSalt.mDurability = RockSalt.getDurability();
        Materials.Calcium.mDurability = Calcium.getDurability();
        Materials.Salt.mToolSpeed = Salt.getToolSpeed();
        Materials.Spodumene.mToolSpeed = Spodumen.getToolSpeed();
        Materials.RockSalt.mToolSpeed = RockSalt.getToolSpeed();
        Materials.Calcium.mToolSpeed = Calcium.getToolSpeed();
        Materials.Salt.mToolQuality = Salt.getToolQuality();
        Materials.Spodumene.mToolQuality = Spodumen.getToolQuality();
        Materials.RockSalt.mToolQuality = RockSalt.getToolQuality();
        Materials.Calcium.mToolQuality = Calcium.getToolQuality();
        for (Werkstoff W : Werkstoff.werkstoffHashSet) {
            for (Pair pair : W.getContents().getValue().toArray(new Pair[0])) {
                if (pair.getKey() instanceof Materials && pair.getKey() == Materials.Neodymium) {
                    W.add(SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM);
                    break;
                }
                if (pair.getKey() instanceof Materials && pair.getKey() == Materials.Iron) {
                    W.add(SubTag.ELECTROMAGNETIC_SEPERATION_IRON);
                    break;
                }
                if (!(pair.getKey() instanceof Materials) || pair.getKey() != Materials.Gold) continue;
                W.add(SubTag.ELECTROMAGNETIC_SEPERATION_GOLD);
                break;
            }
            if (!W.getGenerationFeatures().hasGems()) continue;
            W.add(SubTag.CRYSTAL);
            W.add(SubTag.CRYSTALLISABLE);
        }
    }

    private static void addItemsForGeneration() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            GT_Fluid fluid;
            if ((werkstoff.getGenerationFeatures().toGenerate & 0x10) != 0) {
                if (!FluidRegistry.isFluidRegistered((String)werkstoff.getDefaultName())) {
                    DebugLog.log("Adding new Fluid: " + werkstoff.getDefaultName());
                    fluid = (GT_Fluid)new GT_Fluid(werkstoff.getDefaultName(), "molten.autogenerated", werkstoff.getRGBA()).setGaseous(werkstoff.getStats().isGas());
                    FluidRegistry.registerFluid((Fluid)fluid);
                    fluids.put((Object)werkstoff, (Object)fluid);
                } else {
                    fluids.put((Object)werkstoff, (Object)FluidRegistry.getFluid((String)werkstoff.getDefaultName()));
                }
            }
            if ((werkstoff.getGenerationFeatures().toGenerate & 0x40) != 0) {
                if (!FluidRegistry.isFluidRegistered((String)("molten." + werkstoff.getDefaultName()))) {
                    DebugLog.log("Adding new Molten: " + werkstoff.getDefaultName());
                    fluid = new GT_Fluid("molten." + werkstoff.getDefaultName(), "molten.autogenerated", werkstoff.getRGBA());
                    if (werkstoff.getStats().meltingPoint > 0) {
                        fluid = fluid.setTemperature(werkstoff.getStats().meltingPoint);
                    }
                    FluidRegistry.registerFluid((Fluid)fluid);
                    GT_LanguageManager.addStringLocalization((String)fluid.getUnlocalizedName(), (String)("Molten " + werkstoff.getDefaultName()));
                    molten.put((Object)werkstoff, (Object)fluid);
                } else {
                    molten.put((Object)werkstoff, (Object)FluidRegistry.getFluid((String)werkstoff.getDefaultName()));
                }
            }
            for (OrePrefixes p : OrePrefixes.values()) {
                if (werkstoff.getGenerationFeatures().enforceUnification || (werkstoff.getGenerationFeatures().toGenerate & p.mMaterialGenerationBits) == 0 || OreDictHandler.getItemStack(werkstoff.getDefaultName(), p, 1) == null) continue;
                DebugLog.log("Found: " + p + werkstoff.getVarName() + " in oreDict, disable and reroute my Items to that, also add a Tooltip.");
                werkstoff.getGenerationFeatures().setBlacklist(p);
            }
            toGenerateGlobal |= werkstoff.getGenerationFeatures().toGenerate;
        }
        DebugLog.log("GlobalGeneration: " + toGenerateGlobal);
        if ((toGenerateGlobal & 1) != 0) {
            items.put(OrePrefixes.dust, new BW_MetaGenerated_Items(OrePrefixes.dust));
            items.put(OrePrefixes.dustTiny, new BW_MetaGenerated_Items(OrePrefixes.dustTiny));
            items.put(OrePrefixes.dustSmall, new BW_MetaGenerated_Items(OrePrefixes.dustSmall));
        }
        if ((toGenerateGlobal & 2) != 0) {
            items.put(OrePrefixes.ingot, new BW_MetaGenerated_Items(OrePrefixes.ingot));
            items.put(OrePrefixes.ingotHot, new BW_MetaGenerated_Items(OrePrefixes.ingotHot));
            items.put(OrePrefixes.nugget, new BW_MetaGenerated_Items(OrePrefixes.nugget));
        }
        if ((toGenerateGlobal & 4) != 0) {
            items.put(OrePrefixes.gem, new BW_MetaGenerated_Items(OrePrefixes.gem));
            items.put(OrePrefixes.gemChipped, new BW_MetaGenerated_Items(OrePrefixes.gemChipped));
            items.put(OrePrefixes.gemExquisite, new BW_MetaGenerated_Items(OrePrefixes.gemExquisite));
            items.put(OrePrefixes.gemFlawed, new BW_MetaGenerated_Items(OrePrefixes.gemFlawed));
            items.put(OrePrefixes.gemFlawless, new BW_MetaGenerated_Items(OrePrefixes.gemFlawless));
            items.put(OrePrefixes.lens, new BW_MetaGenerated_Items(OrePrefixes.lens));
        }
        if ((toGenerateGlobal & 8) != 0) {
            WerkstoffLoader.gameRegistryHandler();
            items.put(OrePrefixes.crushed, new BW_MetaGenerated_Items(OrePrefixes.crushed));
            items.put(OrePrefixes.crushedPurified, new BW_MetaGenerated_Items(OrePrefixes.crushedPurified));
            items.put(OrePrefixes.crushedCentrifuged, new BW_MetaGenerated_Items(OrePrefixes.crushedCentrifuged));
            items.put(OrePrefixes.dustPure, new BW_MetaGenerated_Items(OrePrefixes.dustPure));
            items.put(OrePrefixes.dustImpure, new BW_MetaGenerated_Items(OrePrefixes.dustImpure));
        }
        if ((toGenerateGlobal & 0x10) != 0) {
            items.put(OrePrefixes.cell, new BW_MetaGenerated_Items(OrePrefixes.cell));
            if (LoaderReference.Forestry) {
                items.put(OrePrefixes.capsule, new BW_MetaGenerated_Items(OrePrefixes.capsule));
            }
        }
        if ((toGenerateGlobal & 0x20) != 0) {
            items.put(OrePrefixes.cellPlasma, new BW_MetaGenerated_Items(OrePrefixes.cellPlasma));
        }
        if ((toGenerateGlobal & 0x40) != 0) {
            items.put(cellMolten, new BW_MetaGenerated_Items(cellMolten));
            if (LoaderReference.Forestry) {
                items.put(capsuleMolten, new BW_MetaGenerated_Items(capsuleMolten));
            }
        }
        if ((toGenerateGlobal & 0x80) != 0) {
            items.put(OrePrefixes.plate, new BW_MetaGenerated_Items(OrePrefixes.plate));
            items.put(OrePrefixes.stick, new BW_MetaGenerated_Items(OrePrefixes.stick));
            items.put(OrePrefixes.stickLong, new BW_MetaGenerated_Items(OrePrefixes.stickLong));
            items.put(OrePrefixes.toolHeadWrench, new BW_MetaGenerated_Items(OrePrefixes.toolHeadWrench));
            items.put(OrePrefixes.toolHeadHammer, new BW_MetaGenerated_Items(OrePrefixes.toolHeadHammer));
            items.put(OrePrefixes.toolHeadSaw, new BW_MetaGenerated_Items(OrePrefixes.toolHeadSaw));
        }
        if ((toGenerateGlobal & 0x100) != 0) {
            items.put(OrePrefixes.gearGt, new BW_MetaGenerated_Items(OrePrefixes.gearGt));
            items.put(OrePrefixes.gearGtSmall, new BW_MetaGenerated_Items(OrePrefixes.gearGtSmall));
            items.put(OrePrefixes.bolt, new BW_MetaGenerated_Items(OrePrefixes.bolt));
            items.put(OrePrefixes.screw, new BW_MetaGenerated_Items(OrePrefixes.screw));
            items.put(OrePrefixes.ring, new BW_MetaGenerated_Items(OrePrefixes.ring));
            items.put(OrePrefixes.spring, new BW_MetaGenerated_Items(OrePrefixes.spring));
            items.put(OrePrefixes.springSmall, new BW_MetaGenerated_Items(OrePrefixes.springSmall));
            items.put(OrePrefixes.rotor, new BW_MetaGenerated_Items(OrePrefixes.rotor));
            items.put(OrePrefixes.wireFine, new BW_MetaGenerated_Items(OrePrefixes.wireFine));
        }
        if ((toGenerateGlobal & 0x200) != 0) {
            items.put(OrePrefixes.plateDouble, new BW_MetaGenerated_Items(OrePrefixes.plateDouble));
            items.put(OrePrefixes.plateTriple, new BW_MetaGenerated_Items(OrePrefixes.plateTriple));
            items.put(OrePrefixes.plateQuadruple, new BW_MetaGenerated_Items(OrePrefixes.plateQuadruple));
            items.put(OrePrefixes.plateQuintuple, new BW_MetaGenerated_Items(OrePrefixes.plateQuintuple));
            items.put(OrePrefixes.plateDense, new BW_MetaGenerated_Items(OrePrefixes.plateDense));
            items.put(OrePrefixes.ingotDouble, new BW_MetaGenerated_Items(OrePrefixes.ingotDouble));
            items.put(OrePrefixes.ingotTriple, new BW_MetaGenerated_Items(OrePrefixes.ingotTriple));
            items.put(OrePrefixes.ingotQuadruple, new BW_MetaGenerated_Items(OrePrefixes.ingotQuadruple));
            items.put(OrePrefixes.ingotQuintuple, new BW_MetaGenerated_Items(OrePrefixes.ingotQuintuple));
        }
        ENABLED_ORE_PREFIXES.addAll(items.keySet());
        ENABLED_ORE_PREFIXES.add(OrePrefixes.ore);
        ENABLED_ORE_PREFIXES.add(OrePrefixes.oreSmall);
        WerkstoffLoader.runGTItemDataRegistrator();
    }

    static void gameRegistryHandler() {
        if (SideReference.Side.Client) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)BW_Renderer_Block_Ores.INSTANCE);
        }
        GameRegistry.registerTileEntity(BW_MetaGeneratedOreTE.class, (String)"bw.blockoresTE");
        GameRegistry.registerTileEntity(BW_MetaGeneratedSmallOreTE.class, (String)"bw.blockoresSmallTE");
        GameRegistry.registerTileEntity(BW_MetaGenerated_WerkstoffBlock_TE.class, (String)"bw.werkstoffblockTE");
        BWOres = new BW_MetaGenerated_Ores(Material.rock, BW_MetaGeneratedOreTE.class, "bw.blockores");
        BWSmallOres = new BW_MetaGenerated_SmallOres(Material.rock, BW_MetaGeneratedSmallOreTE.class, "bw.blockoresSmall");
        BWBlocks = new BW_MetaGenerated_WerkstoffBlocks(Material.iron, BW_MetaGenerated_WerkstoffBlock_TE.class, "bw.werkstoffblocks");
        GameRegistry.registerBlock((Block)BWOres, BW_MetaGeneratedBlock_Item.class, (String)"bw.blockores.01");
        GameRegistry.registerBlock((Block)BWSmallOres, BW_MetaGeneratedBlock_Item.class, (String)"bw.blockores.02");
        GameRegistry.registerBlock((Block)BWBlocks, BW_MetaGeneratedBlock_Item.class, (String)"bw.werkstoffblocks.01");
        GTMetaItemEnhancer.init();
    }

    private static void runGTItemDataRegistrator() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            Materials werkstoffBridgeMaterial = werkstoff.getBridgeMaterial() != null ? werkstoff.getBridgeMaterial() : (Materials.get((String)werkstoff.getVarName()) != Materials._NULL ? Materials.get((String)werkstoff.getVarName()) : new Materials(-1, werkstoff.getTexSet(), werkstoff.getToolSpeed(), werkstoff.getDurability(), (int)werkstoff.getToolQuality(), 0, (int)werkstoff.getRGBA()[0], (int)werkstoff.getRGBA()[1], (int)werkstoff.getRGBA()[2], (int)werkstoff.getRGBA()[3], werkstoff.getVarName(), werkstoff.getDefaultName(), 0, 0, werkstoff.getStats().meltingPoint, werkstoff.getStats().meltingPoint, werkstoff.getStats().isBlastFurnace(), false, 0, 1, 1, null));
            for (OrePrefixes prefixes : OrePrefixes.values()) {
                if (prefixes == OrePrefixes.cell && werkstoff.getType().equals((Object)Werkstoff.Types.ELEMENT)) continue;
                if (prefixes == OrePrefixes.dust && werkstoff.getType().equals((Object)Werkstoff.Types.ELEMENT) && werkstoff.getType().equals((Object)Werkstoff.Types.ELEMENT)) {
                    boolean ElementSet = false;
                    for (Element e : Element.values()) {
                        if (!e.toString().equals(werkstoff.getToolTip())) continue;
                        if (e.mLinkedMaterials.size() > 0) break;
                        werkstoffBridgeMaterial = werkstoff.getBridgeMaterial() != null ? werkstoff.getBridgeMaterial() : (Materials.get((String)werkstoff.getVarName()) != Materials._NULL ? Materials.get((String)werkstoff.getVarName()) : new Materials(-1, werkstoff.getTexSet(), werkstoff.getToolSpeed(), werkstoff.getDurability(), (int)werkstoff.getToolQuality(), 0, (int)werkstoff.getRGBA()[0], (int)werkstoff.getRGBA()[1], (int)werkstoff.getRGBA()[2], (int)werkstoff.getRGBA()[3], werkstoff.getVarName(), werkstoff.getDefaultName(), 0, 0, werkstoff.getStats().meltingPoint, werkstoff.getStats().meltingPoint, werkstoff.getStats().isBlastFurnace(), false, 0, 1, 1, null));
                        werkstoffBridgeMaterial.mElement = e;
                        e.mLinkedMaterials = new ArrayList();
                        e.mLinkedMaterials.add(werkstoffBridgeMaterial);
                        if (werkstoff.hasItemType(OrePrefixes.dust)) {
                            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.dust, (Materials)werkstoffBridgeMaterial, (ItemStack)werkstoff.get(OrePrefixes.dust), (boolean)false);
                            GT_OreDictUnificator.set((OrePrefixes)OrePrefixes.dust, (Materials)werkstoffBridgeMaterial, (ItemStack)werkstoff.get(OrePrefixes.dust), (boolean)true, (boolean)true);
                        }
                        ElementSet = true;
                        break;
                    }
                    if (!ElementSet) continue;
                    if (werkstoff.hasItemType(OrePrefixes.dust)) {
                        ItemStack scannerOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                        Behaviour_DataOrb.setDataTitle((ItemStack)scannerOutput, (String)"Elemental-Scan");
                        Behaviour_DataOrb.setDataName((ItemStack)scannerOutput, (String)werkstoff.getToolTip());
                        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, (GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{werkstoff.get(prefixes)}, new ItemStack[]{scannerOutput}, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, null, (int)(werkstoffBridgeMaterial.getMass() * 8192L), 30, 0));
                        GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, (GT_Recipe)new BWRecipes.DynamicGTRecipe(false, null, new ItemStack[]{werkstoff.get(prefixes)}, scannerOutput, null, new FluidStack[]{Materials.UUMatter.getFluid(werkstoffBridgeMaterial.getMass())}, null, (int)(werkstoffBridgeMaterial.getMass() * 512L), 30, 0));
                    }
                }
                if (werkstoff.getGenerationFeatures().hasCells()) {
                    werkstoffBridgeMaterial.setHasCorrespondingFluid(true);
                    werkstoffBridgeMaterial.setHasCorrespondingGas(true);
                    werkstoffBridgeMaterial.mFluid = werkstoff.getFluidOrGas(1).getFluid();
                    werkstoffBridgeMaterial.mGas = werkstoff.getFluidOrGas(1).getFluid();
                }
                if (werkstoff.getGenerationFeatures().hasMolten()) {
                    werkstoffBridgeMaterial.mStandardMoltenFluid = werkstoff.getMolten(1).getFluid();
                }
                werkstoffBridgeMaterial.mName = werkstoff.getVarName();
                werkstoffBridgeMaterial.mDefaultLocalName = werkstoff.getDefaultName();
                try {
                    Field f = Materials.class.getField("mLocalizedName");
                    f.set(werkstoffBridgeMaterial, werkstoff.getDefaultName());
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
                werkstoffBridgeMaterial.mChemicalFormula = werkstoff.getToolTip();
                if (LoaderReference.Thaumcraft) {
                    werkstoffBridgeMaterial.mAspects = werkstoff.getGTWrappedTCAspects();
                }
                werkstoffBridgeMaterial.mMaterialInto = werkstoffBridgeMaterial;
                Materials materials = werkstoff.contains(SubTag.BURNING) ? Materials.Blaze : (werkstoff.contains(SubTag.MAGICAL) ? Materials.Thaumium : (werkstoffBridgeMaterial.mDurability > 5120 ? Materials.TungstenSteel : (werkstoffBridgeMaterial.mHandleMaterial = werkstoffBridgeMaterial.mDurability > 1280 ? Materials.Steel : Materials.Wood)));
                if (werkstoff.getStats().isRadioactive()) {
                    werkstoffBridgeMaterial.setEnchantmentForArmors((Enchantment)Enchantment_Radioactivity.INSTANCE, (int)werkstoff.getStats().getEnchantmentlvl());
                    werkstoffBridgeMaterial.setEnchantmentForTools((Enchantment)Enchantment_Radioactivity.INSTANCE, (int)werkstoff.getStats().getEnchantmentlvl());
                }
                werkstoff.setBridgeMaterial(werkstoffBridgeMaterial);
            }
        }
        WerkstoffLoader.addAssociationToItems();
        WerkstoffLoader.addFakeItemDataToInWorldBlocksAndCleanUpFakeData();
    }

    public static void addAssociationToItems() {
        Arrays.stream(OrePrefixes.values()).forEach(prefixes -> Werkstoff.werkstoffHashSet.stream().filter(werkstoff -> werkstoff.hasItemType((OrePrefixes)prefixes)).forEach(werkstoff -> {
            Materials werkstoffBridgeMaterial = werkstoff.getBridgeMaterial();
            ItemStack stack = WerkstoffLoader.getCorrespondingItemStackUnsafe(prefixes, werkstoff, 1);
            if (stack != null && stack.getItem() != null) {
                GT_OreDictUnificator.addAssociation((OrePrefixes)prefixes, (Materials)werkstoffBridgeMaterial, (ItemStack)stack, (boolean)false);
                GT_OreDictUnificator.set((OrePrefixes)prefixes, (Materials)werkstoffBridgeMaterial, (ItemStack)stack, (boolean)true, (boolean)true);
            }
        }));
    }

    private static void addFakeItemDataToInWorldBlocksAndCleanUpFakeData() {
        Map MATERIALS_MAP = null;
        try {
            Field f = Materials.class.getDeclaredField("MATERIALS_MAP");
            f.setAccessible(true);
            MATERIALS_MAP = (Map)f.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (MATERIALS_MAP == null) {
            throw new NullPointerException("MATERIALS_MAP null!");
        }
        Materials oreMat = new Materials(-1, null, 0.0f, 0, 0, false, "bwores", "bwores", null, true, null);
        Materials smallOreMat = new Materials(-1, null, 0.0f, 0, 0, false, "bwsmallores", "bwsmallores", null, true, null);
        Materials blockMat = new Materials(-1, null, 0.0f, 0, 0, false, "bwblocks", "bwblocks", null, true, null);
        for (int i = 0; i < 16; ++i) {
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.ore, (Materials)oreMat, (ItemStack)new ItemStack(BWOres, 1, i), (boolean)true);
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.oreSmall, (Materials)smallOreMat, (ItemStack)new ItemStack(BWSmallOres, 1, i), (boolean)true);
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.block, (Materials)blockMat, (ItemStack)new ItemStack(BWBlocks, 1, i), (boolean)true);
        }
        MATERIALS_MAP.remove("bwores");
        MATERIALS_MAP.remove("bwsmallores");
        MATERIALS_MAP.remove("bwblocks");
    }

    private static void addTools(Werkstoff werkstoff) {
        if (werkstoff.getBridgeMaterial().mDurability == 0) {
            return;
        }
        if (werkstoff.getGenerationFeatures().hasGems()) {
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"XX ", "XXS", "XX ", Character.valueOf('X'), OrePrefixes.gem.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSaw, (Object)werkstoff.getBridgeMaterial(), (long)1L), (long)GT_Proxy.tBits, (Object[])new Object[]{"GGf", Character.valueOf('G'), OrePrefixes.gem.get((Object)werkstoff.getBridgeMaterial())});
        }
        if (!werkstoff.getGenerationFeatures().hasSimpleMetalWorkingItems()) {
            return;
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(44, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"xRR", " SR", "S f", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('R'), OrePrefixes.plate.get((Object)Materials.AnyRubber)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(16, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"IhI", "III", " I ", Character.valueOf('I'), OrePrefixes.ingot.get((Object)werkstoff.getBridgeMaterial())});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(20, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"hDS", "DSD", "SDf", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('D'), Dyes.dyeBlue});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(22, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{" fS", " Sh", "W  ", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('W'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(26, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PfP", "hPd", "STS", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('T'), OrePrefixes.screw.get((Object)werkstoff.getBridgeMaterial())});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(28, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SWS", "SSS", "xSh", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('W'), new ItemStack(Blocks.wool, 1, Short.MAX_VALUE)});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(30, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PfP", "PdP", "STS", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('T'), OrePrefixes.screw.get((Object)werkstoff.getBridgeMaterial())});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(34, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"fPh", " S ", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial())});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(36, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial(), null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PPf", "PP ", "Sh ", Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial())});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(160, 1, werkstoff.getBridgeMaterial(), Materials.Rubber, new long[]{100000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"LBf", "Sd ", "P  ", Character.valueOf('B'), OrePrefixes.bolt.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.AnyRubber), Character.valueOf('S'), OrePrefixes.stick.get((Object)Materials.Iron), Character.valueOf('L'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
        if (gtnhGT) {
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(162, 1, werkstoff.getBridgeMaterial(), Materials.Rubber, new long[]{400000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"LBf", "Sd ", "P  ", Character.valueOf('B'), OrePrefixes.bolt.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.AnyRubber), Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('L'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(164, 1, werkstoff.getBridgeMaterial(), Materials.StyreneButadieneRubber, new long[]{1600000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"LBf", "Sd ", "P  ", Character.valueOf('B'), OrePrefixes.bolt.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StyreneButadieneRubber), Character.valueOf('S'), OrePrefixes.stick.get((Object)Materials.StainlessSteel), Character.valueOf('L'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(120, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{100000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(120, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{75000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(120, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{50000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(122, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, new long[]{400000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Titanium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.Titanium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(122, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, new long[]{300000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Titanium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.Titanium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(122, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, new long[]{200000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Titanium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.Titanium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(124, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, new long[]{1600000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.TungstenSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.TungstenSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.TungstenSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(124, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, new long[]{1200000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.TungstenSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.TungstenSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.TungstenSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(124, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, new long[]{800000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), OrePrefixes.toolHeadWrench.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.TungstenSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.TungstenSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.TungstenSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(150, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{100000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(150, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{75000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(150, 1, werkstoff.getBridgeMaterial(), Materials.StainlessSteel, new long[]{50000L, 32L, 1L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
        if (gtnhGT) {
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(152, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, new long[]{400000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Titanium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.Titanium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(152, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, new long[]{300000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Titanium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.Titanium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(152, 1, werkstoff.getBridgeMaterial(), Materials.Titanium, new long[]{200000L, 128L, 2L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Titanium), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Titanium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.Titanium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(154, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, new long[]{1600000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.TungstenSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.TungstenSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.TungstenSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(154, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, new long[]{1200000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.TungstenSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.TungstenSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.TungstenSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(154, 1, werkstoff.getBridgeMaterial(), Materials.TungstenSteel, new long[]{800000L, 512L, 3L, -1L}), (long)(GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.TungstenSteel), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.TungstenSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get((Object)Materials.TungstenSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadHammer, (Object)werkstoff.getBridgeMaterial(), (long)1L), (long)GT_Proxy.tBits, (Object[])new Object[]{"II ", "IIh", "II ", Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('I'), OrePrefixes.ingot.get((Object)werkstoff.getBridgeMaterial())});
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadWrench, (Object)werkstoff.getBridgeMaterial(), (long)1L), (long)GT_Proxy.tBits, (Object[])new Object[]{"hXW", "XRX", "WXd", Character.valueOf('X'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('R'), OrePrefixes.ring.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial), Character.valueOf('W'), OrePrefixes.screw.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
        GT_ModHandler.addShapelessCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{OrePrefixes.toolHeadHammer.get((Object)werkstoff.getBridgeMaterial()), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
        if (!werkstoff.getGenerationFeatures().hasGems()) {
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), (long)(GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"XX ", "XXS", "XX ", Character.valueOf('X'), OrePrefixes.ingot.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
            GT_ModHandler.addCraftingRecipe((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSaw, (Object)werkstoff.getBridgeMaterial(), (long)1L), (long)GT_Proxy.tBits, (Object[])new Object[]{"PP ", "fh ", Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('I'), OrePrefixes.ingot.get((Object)werkstoff.getBridgeMaterial())});
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(18, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), (long)(GT_ModHandler.RecipeBits.MIRRORED | GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"P", "P", "S", Character.valueOf('P'), OrePrefixes.plate.get((Object)werkstoff.getBridgeMaterial()), Character.valueOf('S'), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
        GT_ModHandler.addShapelessCraftingRecipe((ItemStack)GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(10, 1, werkstoff.getBridgeMaterial(), werkstoff.getBridgeMaterial().mHandleMaterial, null), (Object[])new Object[]{OrePrefixes.toolHeadSaw.get((Object)werkstoff.getBridgeMaterial()), OrePrefixes.stick.get((Object)werkstoff.getBridgeMaterial().mHandleMaterial)});
    }

    public static void removeIC2Recipes() {
        try {
            HashSet remset = new HashSet();
            for (Map.Entry curr : Recipes.macerator.getRecipes().entrySet()) {
                if (!(curr.getKey() instanceof RecipeInputOreDict)) continue;
                if (((RecipeInputOreDict)curr.getKey()).input.equalsIgnoreCase("oreNULL")) {
                    remset.add(curr);
                }
                for (ItemStack stack : ((RecipeOutput)curr.getValue()).items) {
                    if (!(stack.getItem() instanceof BW_MetaGenerated_Items)) continue;
                    remset.add(curr);
                }
            }
            Recipes.macerator.getRecipes().entrySet().removeAll(remset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runAdditionalOreDict() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (werkstoff.getGenerationFeatures().hasOres()) {
                GT_OreDictUnificator.registerOre((Object)(OrePrefixes.ore + werkstoff.getVarName()), (ItemStack)werkstoff.get(OrePrefixes.ore));
                GT_OreDictUnificator.registerOre((Object)(OrePrefixes.oreSmall + werkstoff.getVarName()), (ItemStack)werkstoff.get(OrePrefixes.oreSmall));
                werkstoff.getADDITIONAL_OREDICT().forEach(e -> OreDictionary.registerOre((String)(OrePrefixes.ore + e), (ItemStack)werkstoff.get(OrePrefixes.ore)));
                werkstoff.getADDITIONAL_OREDICT().forEach(e -> OreDictionary.registerOre((String)(OrePrefixes.oreSmall + e), (ItemStack)werkstoff.get(OrePrefixes.oreSmall)));
            }
            if (werkstoff.getGenerationFeatures().hasGems()) {
                OreDictionary.registerOre((String)("craftingLens" + BW_ColorUtil.getDyeFromColor((short[])werkstoff.getRGBA()).mName.replace(" ", "")), (ItemStack)werkstoff.get(OrePrefixes.lens));
            }
            if (werkstoff.getGenerationFeatures().hasGems() || (werkstoff.getGenerationFeatures().toGenerate & 2) != 0) {
                GT_OreDictUnificator.registerOre((Object)(OrePrefixes.block + werkstoff.getVarName()), (ItemStack)werkstoff.get(OrePrefixes.block));
                werkstoff.getADDITIONAL_OREDICT().forEach(e -> OreDictionary.registerOre((String)(OrePrefixes.block + e), (ItemStack)werkstoff.get(OrePrefixes.block)));
            }
            werkstoff.getADDITIONAL_OREDICT().forEach(s -> ENABLED_ORE_PREFIXES.stream().filter(o -> Objects.nonNull(werkstoff.get((OrePrefixes)o))).forEach(od -> OreDictionary.registerOre((String)(od + s), (ItemStack)werkstoff.get((OrePrefixes)od))));
        }
        GT_OreDictUnificator.registerOre((Object)"craftingIndustrialDiamond", (ItemStack)CubicZirconia.get(OrePrefixes.gemExquisite));
    }

    private static void addGemRecipes(Werkstoff werkstoff) {
        if (werkstoff.getGenerationFeatures().hasGems()) {
            if (werkstoff.getGenerationFeatures().hasSifterRecipes() || (werkstoff.getGenerationFeatures().toGenerate & 8) != 0 && (werkstoff.getGenerationFeatures().toGenerate & 1) != 0) {
                GT_ModHandler.addCompressionRecipe((ItemStack)werkstoff.get(OrePrefixes.gem, 9), (ItemStack)werkstoff.get(OrePrefixes.block));
                GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.block), werkstoff.get(OrePrefixes.gem, 9), 100, 24);
                GT_Values.RA.addSifterRecipe(werkstoff.get(OrePrefixes.crushedPurified), new ItemStack[]{werkstoff.get(OrePrefixes.gemExquisite), werkstoff.get(OrePrefixes.gemFlawless), werkstoff.get(OrePrefixes.gem), werkstoff.get(OrePrefixes.gemFlawed), werkstoff.get(OrePrefixes.gemChipped), werkstoff.get(OrePrefixes.dust)}, new int[]{200, 1000, 2500, 2000, 4000, 5000}, 800, 16);
            }
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.gemExquisite), (ItemStack)werkstoff.get(OrePrefixes.dust, 4));
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.gemFlawless), (ItemStack)werkstoff.get(OrePrefixes.dust, 2));
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.gem), (ItemStack)werkstoff.get(OrePrefixes.dust));
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.gemFlawed), (ItemStack)werkstoff.get(OrePrefixes.dustSmall, 2));
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.gemChipped), (ItemStack)werkstoff.get(OrePrefixes.dustSmall));
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gemFlawless, 2), (long)0L, (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.gemExquisite)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gem, 2), (long)0L, (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.gemFlawless)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gemFlawed, 2), (long)0L, (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.gem)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gemChipped, 2), (long)0L, (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.gemFlawed)});
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.gemExquisite), werkstoff.get(OrePrefixes.gemFlawless, 2), 64, 16);
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.gemFlawless), werkstoff.get(OrePrefixes.gem, 2), 64, 16);
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.gem), werkstoff.get(OrePrefixes.gemFlawed, 2), 64, 16);
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.gemFlawed), werkstoff.get(OrePrefixes.gemChipped, 2), 64, 16);
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.gemChipped), werkstoff.get(OrePrefixes.dustTiny), 64, 16);
            if (!werkstoff.contains(NO_BLAST)) {
                GT_Values.RA.addImplosionRecipe(werkstoff.get(OrePrefixes.gemFlawless, 3), 8, werkstoff.get(OrePrefixes.gemExquisite), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)2L));
                GT_Values.RA.addImplosionRecipe(werkstoff.get(OrePrefixes.gem, 3), 8, werkstoff.get(OrePrefixes.gemFlawless), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)2L));
                GT_Values.RA.addImplosionRecipe(werkstoff.get(OrePrefixes.gemFlawed, 3), 8, werkstoff.get(OrePrefixes.gem), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)2L));
                GT_Values.RA.addImplosionRecipe(werkstoff.get(OrePrefixes.gemChipped, 3), 8, werkstoff.get(OrePrefixes.gemFlawed), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)2L));
                GT_Values.RA.addImplosionRecipe(werkstoff.get(OrePrefixes.dust, 4), 24, werkstoff.get(OrePrefixes.gem, 3), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)8L));
            }
            if (werkstoff.hasItemType(OrePrefixes.plate)) {
                GT_Values.RA.addLatheRecipe(werkstoff.get(OrePrefixes.plate), werkstoff.get(OrePrefixes.lens), werkstoff.get(OrePrefixes.dustSmall), 1200, 120);
                GT_Values.RA.addCutterRecipe(werkstoff.get(OrePrefixes.block), werkstoff.get(OrePrefixes.plate, 9), null, (int)Math.max(werkstoff.getStats().getMass() * 10L, 1L), 30);
            }
            GT_Values.RA.addLatheRecipe(werkstoff.get(OrePrefixes.gemExquisite), werkstoff.get(OrePrefixes.lens), werkstoff.get(OrePrefixes.dust, 2), 2400, 30);
            GregTech_API.registerCover((ItemStack)werkstoff.get(OrePrefixes.lens), (ITexture)new GT_MultiTexture(new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[2][0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_LENS, werkstoff.getRGBA(), false)}), (GT_CoverBehavior)new GT_Cover_Lens(BW_ColorUtil.getDyeFromColor((short[])werkstoff.getRGBA()).mIndex));
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.lens), (ItemStack)werkstoff.get(OrePrefixes.dustSmall, 3));
            for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + BW_ColorUtil.getDyeFromColor((short[])werkstoff.getRGBA()).mName.replace(" ", "")))) {
                is.stackSize = 0;
                GT_Values.RA.addLaserEngraverRecipe(werkstoff.get(OrePrefixes.gemChipped, 3), is, werkstoff.get(OrePrefixes.gemFlawed, 1), 600, 30);
                GT_Values.RA.addLaserEngraverRecipe(werkstoff.get(OrePrefixes.gemFlawed, 3), is, werkstoff.get(OrePrefixes.gem, 1), 600, 120);
                GT_Values.RA.addLaserEngraverRecipe(werkstoff.get(OrePrefixes.gem, 3), is, werkstoff.get(OrePrefixes.gemFlawless, 1), 1200, 480);
                GT_Values.RA.addLaserEngraverRecipe(werkstoff.get(OrePrefixes.gemFlawless, 3), is, werkstoff.get(OrePrefixes.gemExquisite, 1), 2400, 2000);
            }
        }
    }

    private static void addSimpleMetalRecipes(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.plate)) {
            if (werkstoff.hasItemType(OrePrefixes.gem)) {
                GT_Values.RA.addLatheRecipe(werkstoff.get(OrePrefixes.gem), werkstoff.get(OrePrefixes.stick), werkstoff.get(OrePrefixes.dustSmall, 2), (int)Math.max(werkstoff.getStats().getMass() * 5L, 1L), 16);
                GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.stick, 2), (long)GT_Proxy.tBits, (Object[])new Object[]{"s", "X", Character.valueOf('X'), werkstoff.get(OrePrefixes.stickLong)});
                GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.stick), (long)GT_Proxy.tBits, (Object[])new Object[]{"f ", " X", Character.valueOf('X'), werkstoff.get(OrePrefixes.gem)});
                GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.stick, 2), werkstoff.get(OrePrefixes.stickLong), (int)Math.max(werkstoff.getStats().getMass(), 1L), 16);
                return;
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.stick, 2), (long)GT_Proxy.tBits, (Object[])new Object[]{"s", "X", Character.valueOf('X'), werkstoff.get(OrePrefixes.stickLong)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.stick), (long)GT_Proxy.tBits, (Object[])new Object[]{"f ", " X", Character.valueOf('X'), werkstoff.get(OrePrefixes.ingot)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.plate), (long)GT_Proxy.tBits, (Object[])new Object[]{"h", "X", "X", Character.valueOf('X'), werkstoff.get(OrePrefixes.ingot)});
            GT_Recipe.GT_Recipe_Map.sBenderRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{werkstoff.get(OrePrefixes.ingot), GT_Utility.getIntegratedCircuit((int)1)}, new ItemStack[]{werkstoff.get(OrePrefixes.plate)}, null, null, null, null, (int)Math.max(werkstoff.getStats().getMass(), 1L), 24, 0));
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.ingot, 3), werkstoff.get(OrePrefixes.plate, 2), (int)Math.max(werkstoff.getStats().getMass(), 1L), 16);
            GregTech_API.registerCover((ItemStack)werkstoff.get(OrePrefixes.plate), (ITexture)new GT_RenderedTexture(werkstoff.getTexSet().mTextures[71], werkstoff.getRGBA(), false), null);
            GT_Values.RA.addLatheRecipe(werkstoff.get(OrePrefixes.ingot), werkstoff.get(OrePrefixes.stick), werkstoff.get(OrePrefixes.dustSmall, 2), (int)Math.max(werkstoff.getStats().getMass() * 5L, 1L), 16);
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.stick, 2), werkstoff.get(OrePrefixes.stickLong), (int)Math.max(werkstoff.getStats().getMass(), 1L), 16);
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Plate.get(0L, new Object[0]), werkstoff.get(OrePrefixes.plate), (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 45);
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Rod.get(0L, new Object[0]), werkstoff.get(OrePrefixes.stick, 2), (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 45);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.ingot), new ItemStack[]{werkstoff.get(OrePrefixes.dust)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.plate), new ItemStack[]{werkstoff.get(OrePrefixes.dust)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.stickLong), new ItemStack[]{werkstoff.get(OrePrefixes.dust)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.stick), new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall, 2)}, null, 2, 8);
        }
    }

    private static void addCraftingMetalRecipes(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.screw)) {
            int tVoltageMultiplier = werkstoff.getStats().meltingPoint >= 2800 ? 60 : 15;
            GT_Values.RA.addExtruderRecipe(werkstoff.getGenerationFeatures().hasGems() ? werkstoff.get(OrePrefixes.gem) : werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0]), werkstoff.get(OrePrefixes.bolt, 8), (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 8 * tVoltageMultiplier);
            GT_Values.RA.addCutterRecipe(werkstoff.get(OrePrefixes.stick), werkstoff.get(OrePrefixes.bolt, 4), null, (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 4);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.bolt), new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 1)}, null, 2, 8);
            GT_Values.RA.addLatheRecipe(werkstoff.get(OrePrefixes.bolt), werkstoff.get(OrePrefixes.screw), null, (int)Math.max(werkstoff.getStats().getMass() / 8L, 1L), 4);
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.screw), (long)GT_Proxy.tBits, (Object[])new Object[]{"fX", "X ", Character.valueOf('X'), werkstoff.get(OrePrefixes.bolt)});
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.screw), new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny, 1)}, null, 2, 8);
            if (werkstoff.getGenerationFeatures().hasGems()) {
                return;
            }
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Ring.get(0L, new Object[0]), werkstoff.get(OrePrefixes.ring, 4), (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 6 * tVoltageMultiplier);
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.ring), (long)GT_Proxy.tBits, (Object[])new Object[]{"h ", "fX", Character.valueOf('X'), werkstoff.get(OrePrefixes.stick)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGt), (long)GT_Proxy.tBits, (Object[])new Object[]{"SPS", "PwP", "SPS", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.stick)});
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot, 4), ItemList.Shape_Extruder_Gear.get(0L, new Object[0]), werkstoff.get(OrePrefixes.gearGt), (int)Math.max(werkstoff.getStats().getMass() * 5L, 1L), 8 * tVoltageMultiplier);
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Wire.get(0L, new Object[0]), werkstoff.get(OrePrefixes.wireFine, 8), (int)Math.max((float)werkstoff.getStats().getMass() * 1.5f, 1.0f), 8 * tVoltageMultiplier);
            GT_Values.RA.addWiremillRecipe(werkstoff.get(OrePrefixes.ingot), werkstoff.get(OrePrefixes.wireFine, 8), (int)Math.max(werkstoff.getStats().getMass(), 1L), 8 * tVoltageMultiplier);
            GT_Values.RA.addWiremillRecipe(werkstoff.get(OrePrefixes.stick), werkstoff.get(OrePrefixes.wireFine, 4), (int)Math.max((float)werkstoff.getStats().getMass() * 0.5f, 1.0f), 8 * tVoltageMultiplier);
            if (smallGearShape != null) {
                GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot), smallGearShape.get(0L, new Object[0]), werkstoff.get(OrePrefixes.gearGtSmall), (int)werkstoff.getStats().mass, 8 * tVoltageMultiplier);
            }
            if (ConfigHandler.GTNH) {
                GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGtSmall), (long)GT_Proxy.tBits, (Object[])new Object[]{" S ", "hPx", " S ", Character.valueOf('S'), werkstoff.get(OrePrefixes.stick), Character.valueOf('P'), werkstoff.get(OrePrefixes.plate)});
            } else {
                GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.gearGtSmall), (long)GT_Proxy.tBits, (Object[])new Object[]{"P  ", " h ", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate)});
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.rotor), (long)GT_Proxy.tBits, (Object[])new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('R'), werkstoff.get(OrePrefixes.ring), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw)});
            GT_Values.RA.addAssemblerRecipe(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring), Materials.Tin.getMolten(32L), werkstoff.get(OrePrefixes.rotor), 240, 24);
            GT_Values.RA.addAssemblerRecipe(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring), Materials.Lead.getMolten(48L), werkstoff.get(OrePrefixes.rotor), 240, 24);
            GT_Values.RA.addAssemblerRecipe(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring), Materials.SolderingAlloy.getMolten(16L), werkstoff.get(OrePrefixes.rotor), 240, 24);
            if (rotorShape != null) {
                GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot, 5), rotorShape.get(0L, new Object[0]), werkstoff.get(OrePrefixes.rotor), 200, 60);
            }
            if (werkstoff.getGenerationFeatures().hasMolten()) {
                GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Gear.get(0L, new Object[0]), werkstoff.getMolten(576), werkstoff.get(OrePrefixes.gearGt), 128, 8);
                GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Gear_Small.get(0L, new Object[0]), werkstoff.getMolten(144), werkstoff.get(OrePrefixes.gearGtSmall), 16, 8);
                if (ringMold != null) {
                    GT_Values.RA.addFluidSolidifierRecipe(ringMold.get(0L, new Object[0]), werkstoff.getMolten(36), werkstoff.get(OrePrefixes.ring), 100, 4 * tVoltageMultiplier);
                }
                if (boltMold != null) {
                    GT_Values.RA.addFluidSolidifierRecipe(boltMold.get(0L, new Object[0]), werkstoff.getMolten(18), werkstoff.get(OrePrefixes.bolt), 50, 2 * tVoltageMultiplier);
                }
                if (rotorMold != null) {
                    GT_Values.RA.addFluidSolidifierRecipe(rotorMold.get(0L, new Object[0]), werkstoff.getMolten(612), werkstoff.get(OrePrefixes.rotor), 100, 60);
                }
            }
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.gearGt), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 4)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.gearGtSmall), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 1)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.rotor), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 4), werkstoff.get(OrePrefixes.dustSmall)}, null, 2, 8);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.ring), new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall, 1)}, null, 2, 8);
        }
    }

    private static void addBlockRecipes(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.block)) {
            return;
        }
        if (werkstoff.hasItemType(OrePrefixes.ingot)) {
            GT_Values.RA.addArcFurnaceRecipe(werkstoff.get(OrePrefixes.block), new ItemStack[]{werkstoff.get(OrePrefixes.ingot, 9)}, null, 16, 90, false);
        }
        if (werkstoff.hasItemType(cellMolten)) {
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.block), null, werkstoff.getMolten(1296), 0, 288, 8);
        }
        if (werkstoff.hasItemType(OrePrefixes.plate)) {
            GT_Values.RA.addCutterRecipe(werkstoff.get(OrePrefixes.block), werkstoff.get(OrePrefixes.plate, 9), null, (int)Math.max(werkstoff.getStats().getMass() * 10L, 1L), 30);
        }
    }

    private static void addMetalRecipes(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.ingot)) {
            GT_ModHandler.addCompressionRecipe((ItemStack)werkstoff.get(OrePrefixes.ingot, 9), (ItemStack)werkstoff.get(OrePrefixes.block));
            GT_Values.RA.addExtruderRecipe(werkstoff.get(OrePrefixes.ingot, 9), ItemList.Shape_Extruder_Block.get(0L, new Object[0]), werkstoff.get(OrePrefixes.block), (int)werkstoff.getStats().mass, 8 * werkstoff.getStats().getMeltingPoint() >= 2800 ? 60 : 15);
            GT_Values.RA.addAlloySmelterRecipe(werkstoff.get(OrePrefixes.ingot, 9), ItemList.Shape_Mold_Block.get(0L, new Object[0]), werkstoff.get(OrePrefixes.block), (int)(werkstoff.getStats().mass / 2L), 4 * werkstoff.getStats().getMeltingPoint() >= 2800 ? 60 : 15);
        }
    }

    private static void addMultipleMetalRecipes(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.plateDense)) {
            GT_Recipe.GT_Recipe_Map.sBenderRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{werkstoff.get(OrePrefixes.ingot, 2), GT_Utility.getIntegratedCircuit((int)2)}, new ItemStack[]{werkstoff.get(OrePrefixes.plateDouble)}, null, null, null, null, (int)Math.max(werkstoff.getStats().getMass() * 2L, 1L), 60, 0));
            GregTech_API.registerCover((ItemStack)werkstoff.get(OrePrefixes.plateDouble), (ITexture)new GT_RenderedTexture(werkstoff.getTexSet().mTextures[72], werkstoff.getRGBA(), false), null);
            GT_Values.RA.addPulveriserRecipe(werkstoff.get(OrePrefixes.plateDouble), new ItemStack[]{werkstoff.get(OrePrefixes.dust, 2)}, null, 2, 8);
        }
    }

    private static void addDustRecipes(Werkstoff werkstoff) {
        if ((werkstoff.getGenerationFeatures().toGenerate & 1) != 0) {
            ArrayList<FluidStack> flOutputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> stOutputs = new ArrayList<ItemStack>();
            HashMap tracker = new HashMap();
            int cells = 0;
            if (werkstoff.getGenerationFeatures().hasMixerRecipes() || werkstoff.getStats().isElektrolysis() || werkstoff.getStats().isCentrifuge() || werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                for (Pair container : werkstoff.getContents().getValue().toArray(new Pair[0])) {
                    FluidStack tmpFl;
                    if (container.getKey() instanceof Materials) {
                        if (((Materials)container.getKey()).getGas(0L) != null || ((Materials)container.getKey()).getFluid(0L) != null || ((Materials)container.getKey()).mIconSet == TextureSet.SET_FLUID) {
                            tmpFl = ((Materials)container.getKey()).getGas((long)(1000 * (Integer)container.getValue()));
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = ((Materials)container.getKey()).getFluid((long)(1000 * (Integer)container.getValue()));
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() <= 1) continue;
                            if (!tracker.containsKey(container.getKey())) {
                                stOutputs.add(((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()));
                                tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                            } else {
                                stOutputs.add(((Materials)container.getKey()).getCells((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                                stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                            }
                            cells += ((Integer)container.getValue()).intValue();
                            continue;
                        }
                        if (((Materials)container.getKey()).getDust(((Integer)container.getValue()).intValue()) == null) {
                            if (((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()) == null || ((Materials)container.getKey()).getMolten(0L) == null && ((Materials)container.getKey()).getSolid(0L) == null) continue;
                            tmpFl = ((Materials)container.getKey()).getMolten((long)(1000 * (Integer)container.getValue()));
                            if (tmpFl == null || tmpFl.getFluid() == null) {
                                tmpFl = ((Materials)container.getKey()).getSolid((long)(1000 * (Integer)container.getValue()));
                            }
                            flOutputs.add(tmpFl);
                            if (flOutputs.size() > 1) {
                                if (!tracker.containsKey(container.getKey())) {
                                    stOutputs.add(((Materials)container.getKey()).getCells(((Integer)container.getValue()).intValue()));
                                    tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                                } else {
                                    stOutputs.add(((Materials)container.getKey()).getCells((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                                    stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                                }
                                cells += ((Integer)container.getValue()).intValue();
                            }
                        }
                        if (!tracker.containsKey(container.getKey())) {
                            stOutputs.add(((Materials)container.getKey()).getDust(((Integer)container.getValue()).intValue()));
                            tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                            continue;
                        }
                        stOutputs.add(((Materials)container.getKey()).getDust((Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                        stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                        continue;
                    }
                    if (!(container.getKey() instanceof Werkstoff)) continue;
                    if (((Werkstoff)container.getKey()).getStats().isGas() || ((Werkstoff)container.getKey()).getGenerationFeatures().hasCells()) {
                        tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                        if (tmpFl == null || tmpFl.getFluid() == null) {
                            tmpFl = ((Werkstoff)container.getKey()).getFluidOrGas(1000 * (Integer)container.getValue());
                        }
                        flOutputs.add(tmpFl);
                        if (flOutputs.size() <= 1) continue;
                        if (!tracker.containsKey(container.getKey())) {
                            stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)container.getValue()));
                            tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                        } else {
                            stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.cell, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                            stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                        }
                        cells += ((Integer)container.getValue()).intValue();
                        continue;
                    }
                    if (!((Werkstoff)container.getKey()).getGenerationFeatures().hasDusts()) continue;
                    if (!tracker.containsKey(container.getKey())) {
                        stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)container.getValue()));
                        tracker.put(container.getKey(), new Pair(container.getValue(), stOutputs.size() - 1));
                        continue;
                    }
                    stOutputs.add(((Werkstoff)container.getKey()).get(OrePrefixes.dust, (Integer)((Pair)tracker.get(container.getKey())).getKey() + (Integer)container.getValue()));
                    stOutputs.remove((Integer)((Pair)tracker.get(container.getKey())).getValue() + 1);
                }
                ItemStack input = werkstoff.get(OrePrefixes.dust);
                input.stackSize = werkstoff.getContents().getKey();
                if (werkstoff.getStats().isElektrolysis()) {
                    GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().protons / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0));
                }
                if (werkstoff.getStats().isCentrifuge()) {
                    GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{input, cells > 0 ? Materials.Empty.getCells(cells) : null}, stOutputs.toArray(new ItemStack[0]), null, null, new FluidStack[]{null}, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, (int)Math.max(1L, Math.abs(werkstoff.getStats().mass / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
                }
                if (werkstoff.getGenerationFeatures().hasChemicalRecipes()) {
                    if (cells > 0) {
                        stOutputs.add(Materials.Empty.getCells(cells));
                    }
                    GT_Recipe.GT_Recipe_Map.sChemicalRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().protons / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0));
                    GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes.addRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().protons / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 30, 0);
                }
                if (werkstoff.getGenerationFeatures().hasMixerRecipes()) {
                    if (cells > 0) {
                        stOutputs.add(Materials.Empty.getCells(cells));
                    }
                    GT_Recipe.GT_Recipe_Map.sMixerRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(true, stOutputs.toArray(new ItemStack[0]), new ItemStack[]{input}, null, null, new FluidStack[]{flOutputs.size() > 0 ? (FluidStack)flOutputs.get(0) : null}, null, (int)Math.max(1L, Math.abs(werkstoff.getStats().mass / (long)werkstoff.getContents().getValue().size())), Math.min(4, werkstoff.getContents().getValue().size()) * 5, 0));
                }
            }
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"TTT", "TTT", "TTT", Character.valueOf('T'), werkstoff.get(OrePrefixes.dustTiny)});
            GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"TT ", "TT ", Character.valueOf('T'), WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff)});
            GT_ModHandler.addCraftingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustSmall, werkstoff, 4), (Object[])new Object[]{" T ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GT_ModHandler.addCraftingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dustTiny, werkstoff, 9), (Object[])new Object[]{"T  ", Character.valueOf('T'), werkstoff.get(OrePrefixes.dust)});
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_Dust.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_Dust.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustTiny, 9), ItemList.Schematic_3by3.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            GT_Values.RA.addBoxingRecipe(werkstoff.get(OrePrefixes.dustSmall, 4), ItemList.Schematic_2by2.get(0L, new Object[0]), werkstoff.get(OrePrefixes.dust), 100, 4);
            if ((werkstoff.getGenerationFeatures().toGenerate & 2) != 0 && !werkstoff.getStats().isBlastFurnace()) {
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (ItemStack)werkstoff.get(OrePrefixes.ingot));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustTiny), (ItemStack)werkstoff.get(OrePrefixes.nugget));
            } else if ((werkstoff.getGenerationFeatures().toGenerate & 2) != 0 && werkstoff.getStats().isBlastFurnace() && werkstoff.getStats().meltingPoint != 0) {
                if (werkstoff.contains(ANAEROBE_SMELTING)) {
                    GT_Values.RA.addBlastRecipe(werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11), Materials.Nitrogen.getGas(1000L), null, werkstoff.getStats().meltingPoint < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().meltingPoint, 120, werkstoff.getStats().getMeltingPoint());
                } else if (werkstoff.contains(NOBLE_GAS_SMELTING)) {
                    GT_Values.RA.addBlastRecipe(werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)11), Materials.Argon.getGas(1000L), null, werkstoff.getStats().meltingPoint < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().meltingPoint, 120, werkstoff.getStats().getMeltingPoint());
                } else {
                    GT_Values.RA.addBlastRecipe(werkstoff.get(OrePrefixes.dust), GT_Utility.getIntegratedCircuit((int)1), null, null, werkstoff.getStats().meltingPoint < 1750 ? werkstoff.get(OrePrefixes.ingot) : werkstoff.get(OrePrefixes.ingotHot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().meltingPoint, 120, werkstoff.getStats().getMeltingPoint());
                    if (werkstoff.getStats().meltingPoint <= 1000) {
                        GT_Values.RA.addPrimitiveBlastRecipe(werkstoff.get(OrePrefixes.dust), null, 9, werkstoff.get(OrePrefixes.ingot), null, (int)Math.max(werkstoff.getStats().getMass() / 40L, 1L) * werkstoff.getStats().meltingPoint);
                        GT_ModHandler.addRCBlastFurnaceRecipe((ItemStack)werkstoff.get(OrePrefixes.ingot), (ItemStack)werkstoff.get(OrePrefixes.dust), (int)werkstoff.getStats().meltingPoint);
                    }
                }
            }
            if (werkstoff.getStats().isBlastFurnace() && werkstoff.getStats().meltingPoint > 1750) {
                GT_Values.RA.addVacuumFreezerRecipe(werkstoff.get(OrePrefixes.ingotHot), werkstoff.get(OrePrefixes.ingot), (int)Math.max(werkstoff.getStats().mass * 3L, 1L));
            }
            if ((werkstoff.getGenerationFeatures().toGenerate & 2) != 0) {
                GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.ingot), (ItemStack)werkstoff.get(OrePrefixes.dust));
                GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.nugget), (ItemStack)werkstoff.get(OrePrefixes.dustTiny));
            }
            if ((werkstoff.getGenerationFeatures().toGenerate & 2) != 0 || werkstoff.getGenerationFeatures().hasGems()) {
                GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.block), (ItemStack)werkstoff.get(OrePrefixes.dust, 9));
            }
        }
    }

    private static void addOreRecipes(Werkstoff werkstoff) {
        if ((werkstoff.getGenerationFeatures().toGenerate & 8) != 0 && (werkstoff.getGenerationFeatures().toGenerate & 2) != 0 && !werkstoff.getStats().isBlastFurnace()) {
            GT_ModHandler.addSmeltingRecipe((ItemStack)WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.ore, werkstoff), (ItemStack)werkstoff.get(OrePrefixes.ingot));
        }
        if ((werkstoff.getGenerationFeatures().toGenerate & 8) != 0) {
            GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.ore), werkstoff.getGenerationFeatures().hasGems() ? werkstoff.get(OrePrefixes.gem) : werkstoff.get(OrePrefixes.crushed), 16, 10);
            GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.ore), (ItemStack)werkstoff.get(OrePrefixes.crushed, 2), (ItemStack)(werkstoff.contains(SubTag.CRYSTAL) ? werkstoff.get(OrePrefixes.gem) : werkstoff.getOreByProduct(0, OrePrefixes.dust)), (int)(werkstoff.getNoOfByProducts() > 0 ? 10 : 0), (ItemStack)Materials.Stone.getDust(1), (int)50, (boolean)true);
        }
    }

    private static void addCrushedRecipes(Werkstoff werkstoff) {
        if ((werkstoff.getGenerationFeatures().toGenerate & 8) == 0 || (werkstoff.getGenerationFeatures().toGenerate & 1) == 0) {
            return;
        }
        if ((werkstoff.getGenerationFeatures().toGenerate & 2) != 0 && !werkstoff.getStats().isBlastFurnace()) {
            if (werkstoff.getType().equals((Object)Werkstoff.Types.ELEMENT)) {
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.crushed), (ItemStack)werkstoff.get(OrePrefixes.nugget, 10));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedPurified), (ItemStack)werkstoff.get(OrePrefixes.nugget, 10));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedCentrifuged), (ItemStack)werkstoff.get(OrePrefixes.nugget, 10));
            } else {
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.crushed), (ItemStack)werkstoff.get(OrePrefixes.ingot));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedPurified), (ItemStack)werkstoff.get(OrePrefixes.ingot));
                GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedCentrifuged), (ItemStack)werkstoff.get(OrePrefixes.ingot));
            }
            GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustImpure), (ItemStack)werkstoff.get(OrePrefixes.ingot));
            GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustPure), (ItemStack)werkstoff.get(OrePrefixes.ingot));
            GT_ModHandler.addSmeltingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (ItemStack)werkstoff.get(OrePrefixes.ingot));
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustImpure), (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.crushed)});
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dustPure), (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.crushedPurified)});
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.dust), (Object[])new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.crushedCentrifuged)});
        GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.crushed), werkstoff.get(OrePrefixes.dustImpure), 10, 16);
        GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.crushed), (ItemStack)werkstoff.get(OrePrefixes.dustImpure), (ItemStack)werkstoff.getOreByProduct(0, OrePrefixes.dust), (int)10, (boolean)false);
        GT_ModHandler.addOreWasherRecipe((ItemStack)werkstoff.get(OrePrefixes.crushed), (int)1000, (Object[])new Object[]{werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(0, OrePrefixes.dustTiny), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Stone, (long)1L)});
        GT_ModHandler.addThermalCentrifugeRecipe((ItemStack)werkstoff.get(OrePrefixes.crushed), (int)((int)Math.min(5000L, Math.abs(werkstoff.getStats().protons * 20L))), (Object[])new Object[]{werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.getOreByProduct(1, OrePrefixes.dustTiny), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Stone, (long)1L)});
        GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.get(OrePrefixes.dustPure), 10, 16);
        GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedPurified), (ItemStack)werkstoff.get(OrePrefixes.dustPure), (ItemStack)werkstoff.getOreByProduct(1, OrePrefixes.dust), (int)10, (boolean)false);
        GT_ModHandler.addThermalCentrifugeRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedPurified), (int)((int)Math.min(5000L, Math.abs(werkstoff.getStats().protons * 20L))), (Object[])new Object[]{werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.getOreByProduct(1, OrePrefixes.dustTiny)});
        GT_Values.RA.addForgeHammerRecipe(werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.get(OrePrefixes.dust), 10, 16);
        GT_ModHandler.addPulverisationRecipe((ItemStack)werkstoff.get(OrePrefixes.crushedCentrifuged), (ItemStack)werkstoff.get(OrePrefixes.dust), (ItemStack)werkstoff.getOreByProduct(2, OrePrefixes.dust), (int)10, (boolean)false);
        GT_Values.RA.addCentrifugeRecipe(werkstoff.get(OrePrefixes.dustImpure), 0, werkstoff.get(OrePrefixes.dust), werkstoff.getOreByProduct(0, OrePrefixes.dustTiny), null, null, null, null, (int)Math.max(1L, werkstoff.getStats().mass * 8L));
        GT_Values.RA.addCentrifugeRecipe(werkstoff.get(OrePrefixes.dustPure), 0, werkstoff.get(OrePrefixes.dust), werkstoff.getOreByProduct(1, OrePrefixes.dustTiny), null, null, null, null, (int)Math.max(1L, werkstoff.getStats().mass * 8L));
        if (werkstoff.contains(SubTag.CRYSTALLISABLE)) {
            GT_Values.RA.addAutoclaveRecipe(werkstoff.get(OrePrefixes.dustPure), Materials.Water.getFluid(200L), werkstoff.get(OrePrefixes.gem), 9000, 2000, 24);
            GT_Values.RA.addAutoclaveRecipe(werkstoff.get(OrePrefixes.dustImpure), Materials.Water.getFluid(200L), werkstoff.get(OrePrefixes.gem), 9000, 2000, 24);
            GT_Values.RA.addAutoclaveRecipe(werkstoff.get(OrePrefixes.dustPure), GT_ModHandler.getDistilledWater((long)200L), werkstoff.get(OrePrefixes.gem), 9500, 1500, 24);
            GT_Values.RA.addAutoclaveRecipe(werkstoff.get(OrePrefixes.dustImpure), GT_ModHandler.getDistilledWater((long)200L), werkstoff.get(OrePrefixes.gem), 9500, 1500, 24);
        }
        if (werkstoff.contains(SubTag.WASHING_MERCURY)) {
            GT_Values.RA.addChemicalBathRecipe(werkstoff.get(OrePrefixes.crushed), Materials.Mercury.getFluid(1000L), werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(1, OrePrefixes.dust), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Stone, (long)1L), new int[]{10000, 7000, 4000}, 800, 8);
        }
        if (werkstoff.contains(SubTag.WASHING_SODIUMPERSULFATE)) {
            GT_Values.RA.addChemicalBathRecipe(werkstoff.get(OrePrefixes.crushed), Materials.SodiumPersulfate.getFluid(GT_Mod.gregtechproxy.mDisableOldChemicalRecipes ? 1000L : 100L), werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(1, OrePrefixes.dust), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Stone, (long)1L), new int[]{10000, 7000, 4000}, 800, 8);
        }
        if (werkstoff.contains(SubTag.ELECTROMAGNETIC_SEPERATION_GOLD)) {
            GT_Values.RA.addElectromagneticSeparatorRecipe(werkstoff.get(OrePrefixes.dustPure), werkstoff.get(OrePrefixes.dust), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Gold, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.nugget, (Object)Materials.Gold, (long)1L), new int[]{10000, 4000, 2000}, 400, 24);
        } else if (werkstoff.contains(SubTag.ELECTROMAGNETIC_SEPERATION_IRON)) {
            GT_Values.RA.addElectromagneticSeparatorRecipe(werkstoff.get(OrePrefixes.dustPure), werkstoff.get(OrePrefixes.dust), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Iron, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.nugget, (Object)Materials.Iron, (long)1L), new int[]{10000, 4000, 2000}, 400, 24);
        } else if (werkstoff.contains(SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM)) {
            GT_Values.RA.addElectromagneticSeparatorRecipe(werkstoff.get(OrePrefixes.dustPure), werkstoff.get(OrePrefixes.dust), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustSmall, (Object)Materials.Neodymium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.nugget, (Object)Materials.Neodymium, (long)1L), new int[]{10000, 4000, 2000}, 400, 24);
        }
    }

    private static void addCellRecipes(Werkstoff werkstoff) {
        if ((werkstoff.getGenerationFeatures().toGenerate & 0x10) == 0) {
            return;
        }
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(fluids.get((Object)werkstoff)), 1000), werkstoff.get(OrePrefixes.cell), Materials.Empty.getCells(1)));
        FluidContainerRegistry.registerFluidContainer((Fluid)werkstoff.getFluidOrGas(1).getFluid(), (ItemStack)werkstoff.get(OrePrefixes.cell), (ItemStack)Materials.Empty.getCells(1));
        GT_Values.RA.addFluidCannerRecipe(Materials.Empty.getCells(1), werkstoff.get(OrePrefixes.cell), new FluidStack((Fluid)Objects.requireNonNull(fluids.get((Object)werkstoff)), 1000), GT_Values.NF);
        GT_Values.RA.addFluidCannerRecipe(werkstoff.get(OrePrefixes.cell), Materials.Empty.getCells(1), GT_Values.NF, new FluidStack((Fluid)Objects.requireNonNull(fluids.get((Object)werkstoff)), 1000));
        if (LoaderReference.Forestry) {
            FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(fluids.get((Object)werkstoff)), 1000), werkstoff.get(OrePrefixes.capsule), GT_ModHandler.getModItem((String)"Forestry", (String)"waxCapsule", (long)1L), true);
            GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
            GT_Values.RA.addFluidCannerRecipe(werkstoff.get(OrePrefixes.capsule), GT_Values.NI, GT_Values.NF, new FluidStack((Fluid)Objects.requireNonNull(fluids.get((Object)werkstoff)), 1000));
        }
        if ((werkstoff.getGenerationFeatures().toGenerate & 1) != 0) {
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dust), null, werkstoff.getFluidOrGas(1000), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(GT_Utility.getIntegratedCircuit((int)1), werkstoff.getFluidOrGas(1000), werkstoff.get(OrePrefixes.dust), (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
        }
        if (werkstoff.getType().equals((Object)Werkstoff.Types.ELEMENT)) {
            Materials werkstoffBridgeMaterial = null;
            boolean ElementSet = false;
            for (Element e : Element.values()) {
                if (!e.toString().equals(werkstoff.getToolTip())) continue;
                werkstoffBridgeMaterial = new Materials(-1, werkstoff.getTexSet(), 0.0f, 0, 0, false, werkstoff.getDefaultName(), werkstoff.getDefaultName());
                werkstoffBridgeMaterial.mElement = e;
                e.mLinkedMaterials.add(werkstoffBridgeMaterial);
                ElementSet = true;
                break;
            }
            if (!ElementSet) {
                return;
            }
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.cell, werkstoffBridgeMaterial, (ItemStack)werkstoff.get(OrePrefixes.cell), (boolean)false);
            ItemStack scannerOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            Behaviour_DataOrb.setDataTitle((ItemStack)scannerOutput, (String)"Elemental-Scan");
            Behaviour_DataOrb.setDataName((ItemStack)scannerOutput, (String)werkstoff.getToolTip());
            GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, (GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{werkstoff.get(OrePrefixes.cell)}, new ItemStack[]{scannerOutput}, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, null, (int)(werkstoffBridgeMaterial.getMass() * 8192L), 30, 0));
            GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, (GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{Materials.Empty.getCells(1)}, new ItemStack[]{werkstoff.get(OrePrefixes.cell)}, scannerOutput, null, new FluidStack[]{Materials.UUMatter.getFluid(werkstoffBridgeMaterial.getMass())}, null, (int)(werkstoffBridgeMaterial.getMass() * 512L), 30, 0));
        }
    }

    private static void addMoltenRecipes(Werkstoff werkstoff) {
        if ((werkstoff.getGenerationFeatures().toGenerate & 0x40) == 0) {
            return;
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(molten.get((Object)werkstoff)), 144), werkstoff.get(cellMolten), Materials.Empty.getCells(1));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.cell), (ItemStack)Materials.Empty.getCells(1));
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)data);
        GT_Values.RA.addFluidCannerRecipe(Materials.Empty.getCells(1), werkstoff.get(cellMolten), new FluidStack((Fluid)Objects.requireNonNull(molten.get((Object)werkstoff)), 144), GT_Values.NF);
        GT_Values.RA.addFluidCannerRecipe(werkstoff.get(cellMolten), Materials.Empty.getCells(1), GT_Values.NF, new FluidStack((Fluid)Objects.requireNonNull(molten.get((Object)werkstoff)), 144));
        if (LoaderReference.Forestry) {
            FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(molten.get((Object)werkstoff)), 144), werkstoff.get(capsuleMolten), GT_ModHandler.getModItem((String)"Forestry", (String)"refractoryEmpty", (long)1L));
            FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(capsuleMolten), (ItemStack)GT_ModHandler.getModItem((String)"Forestry", (String)"refractoryEmpty", (long)1L));
            GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
            GT_Values.RA.addFluidCannerRecipe(werkstoff.get(capsuleMolten), GT_Values.NI, GT_Values.NF, new FluidStack((Fluid)Objects.requireNonNull(molten.get((Object)werkstoff)), 144));
        }
        if ((werkstoff.getGenerationFeatures().toGenerate & 2) != 0) {
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.ingot), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            if ((werkstoff.getGenerationFeatures().toGenerate & 0x80) != 0) {
                GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.stickLong), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
                GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.plate), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
                GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.stick), null, werkstoff.getMolten(72), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            }
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.nugget), null, werkstoff.getMolten(16), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Ingot.get(0L, new Object[0]), werkstoff.getMolten(144), werkstoff.get(OrePrefixes.ingot), (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Nugget.get(0L, new Object[0]), werkstoff.getMolten(16), werkstoff.get(OrePrefixes.nugget), (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Block.get(0L, new Object[0]), werkstoff.getMolten(1296), werkstoff.get(OrePrefixes.block), (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
        } else if ((werkstoff.getGenerationFeatures().toGenerate & 1) != 0 && (werkstoff.getGenerationFeatures().toGenerate & 2) == 0) {
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dust), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dustSmall), null, werkstoff.getMolten(36), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dustTiny), null, werkstoff.getMolten(16), 0, (int)werkstoff.getStats().mass, werkstoff.getStats().getMass() > 128L ? 64 : 30);
        }
    }

    public static void addAspectToAll(Werkstoff werkstoff) {
        for (OrePrefixes enabledOrePrefixes : ENABLED_ORE_PREFIXES) {
            if (!werkstoff.hasItemType(enabledOrePrefixes)) continue;
            if (enabledOrePrefixes.mMaterialAmount >= 3628800L || enabledOrePrefixes == OrePrefixes.ore) {
                DebugLog.log("OrePrefix: " + enabledOrePrefixes.name() + " mMaterialAmount: " + enabledOrePrefixes.mMaterialAmount / 3628800L);
                if (!Objects.nonNull(items.get(enabledOrePrefixes))) continue;
                ThaumcraftHandler.AspectAdder.addAspectViaBW(werkstoff.get(enabledOrePrefixes), werkstoff.getTCAspects(enabledOrePrefixes == OrePrefixes.ore ? 1 : (int)(enabledOrePrefixes.mMaterialAmount / 3628800L)));
                continue;
            }
            if (enabledOrePrefixes.mMaterialAmount < 0L || !Objects.nonNull(items.get(enabledOrePrefixes))) continue;
            ThaumcraftHandler.AspectAdder.addAspectViaBW(werkstoff.get(enabledOrePrefixes), new Pair<Object, Integer>(TC_Aspects.PERDITIO.mAspect, 1));
        }
    }

    static {
        gtnhGT = false;
        Bismutite = new Werkstoff(new short[]{255, 233, 0, 0}, "Bismutite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 1, TextureSet.SET_FLINT, Collections.singletonList(Materials.Bismuth), new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Oxygen, 2), new Pair<Materials, Integer>(Materials.CarbonDioxide, 2));
        Bismuthinit = new Werkstoff(new short[]{192, 192, 192, 0}, "Bismuthinite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 2, TextureSet.SET_METALLIC, Arrays.asList(Materials.Bismuth, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Sulfur, 3));
        Zirconium = new Werkstoff(new short[]{175, 175, 175, 0}, "Zirconium", "Zr", new Werkstoff.Stats().setProtons(40L).setMeltingPoint(2130), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().enforceUnification(), 3, TextureSet.SET_METALLIC, new Pair[0]);
        CubicZirconia = new Werkstoff(new short[]{255, 255, 255, 0}, "Cubic Zirconia", Werkstoff.Types.COMPOUND, 3273, new Werkstoff.GenerationFeatures().onlyDust().addGems().enforceUnification(), 4, TextureSet.SET_DIAMOND, Collections.singletonList(Zirconium), new Pair<Werkstoff, Integer>(Zirconium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        FluorBuergerit = new Werkstoff(new short[]{32, 32, 32, 0}, "Fluor-Buergerite", BW_Util.subscriptNumbers("NaFe3Al6(Si6O18)(BO3)3O3F"), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 5, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.Silicon), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Iron, 3), new Pair<Materials, Integer>(Materials.Aluminium, 6), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 30), new Pair<Materials, Integer>(Materials.Fluorine, 1));
        YttriumOxide = new Werkstoff(new short[]{255, 255, 255, 0}, "Yttrium Oxide", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().onlyDust().enforceUnification(), 6, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Yttrium, 2), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        ChromoAluminoPovondrait = new Werkstoff(new short[]{0, 121, 106, 0}, "Chromo-Alumino-Povondraite", BW_Util.subscriptNumbers("NaCr3(Al4Mg2)(Si6O18)(BO3)3(OH)3O"), Werkstoff.Types.getDefaultStatForType(Werkstoff.Types.COMPOUND), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 7, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.Silicon), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Chrome, 3), new Pair<Materials, Integer>(Materials.Magnalium, 6), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 31), new Pair<Materials, Integer>(Materials.Hydrogen, 3));
        VanadioOxyDravit = new Werkstoff(new short[]{96, 160, 160, 0}, "Vanadio-Oxy-Dravite", BW_Util.subscriptNumbers("NaV3(Al4Mg2)(Si6O18)(BO3)3(OH)3O"), Werkstoff.Types.getDefaultStatForType(Werkstoff.Types.COMPOUND), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 8, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.Silicon), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Vanadium, 3), new Pair<Materials, Integer>(Materials.Magnalium, 6), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 31), new Pair<Materials, Integer>(Materials.Hydrogen, 3));
        Olenit = new Werkstoff(new short[]{210, 210, 210, 0}, "Olenite", BW_Util.subscriptNumbers("NaAl3Al6(Si6O18)(BO3)3O3OH"), Werkstoff.Types.getDefaultStatForType(Werkstoff.Types.COMPOUND), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 9, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.Silicon), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Aluminium, 9), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 31), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        Arsenopyrite = new Werkstoff(new short[]{176, 176, 176, 0}, "Arsenopyrite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 10, TextureSet.SET_METALLIC, Arrays.asList(Materials.Sulfur, Materials.Arsenic, Materials.Iron), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Arsenic, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1));
        Ferberite = new Werkstoff(new short[]{176, 176, 176, 0}, "Ferberite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 11, TextureSet.SET_METALLIC, Arrays.asList(Materials.Iron, Materials.Tungsten), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Tungsten, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        Loellingit = new Werkstoff(new short[]{208, 208, 208, 0}, "Loellingite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 12, TextureSet.SET_METALLIC, Arrays.asList(Materials.Iron, Materials.Arsenic), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Arsenic, 2));
        Roquesit = new Werkstoff(new short[]{160, 160, 160, 0}, "Roquesite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 13, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 1), new Pair<Materials, Integer>(Materials.Indium, 1), new Pair<Materials, Integer>(Materials.Sulfur, 2));
        Bornite = new Werkstoff(new short[]{151, 102, 43, 0}, "Bornite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 14, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Iron, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 5), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Sulfur, 4));
        Wittichenit = new Werkstoff(Materials.Copper.mRGBa, "Wittichenite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 15, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Bismuth, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 5), new Pair<Materials, Integer>(Materials.Bismuth, 1), new Pair<Materials, Integer>(Materials.Sulfur, 4));
        Djurleit = new Werkstoff(new short[]{96, 96, 96, 0}, "Djurleite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 16, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Copper, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 31), new Pair<Materials, Integer>(Materials.Sulfur, 16));
        Huebnerit = new Werkstoff(new short[]{128, 96, 96, 0}, "Huebnerite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 17, TextureSet.SET_METALLIC, Arrays.asList(Materials.Manganese, Materials.Tungsten), new Pair<Materials, Integer>(Materials.Manganese, 1), new Pair<Materials, Integer>(Materials.Tungsten, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        Thorianit = new Werkstoff(new short[]{48, 48, 48, 0}, "Thorianite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 18, TextureSet.SET_METALLIC, Collections.singletonList(Materials.Thorium), new Pair<Materials, Integer>(Materials.Thorium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        RedZircon = new Werkstoff(new short[]{195, 19, 19, 0}, "Red Zircon", new Werkstoff.Stats().setElektrolysis(true).setMeltingPoint(2130), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 19, TextureSet.SET_GEM_VERTICAL, Arrays.asList(Zirconium, Materials.Silicon), new Pair<Werkstoff, Integer>(Zirconium, 1), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        Salt = new Werkstoff(Materials.Salt.mRGBa, "Salt", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addGems().addSifterRecipes(), 20, TextureSet.SET_FLINT, Arrays.asList(Materials.RockSalt, Materials.Borax), new Pair<Materials, Integer>(Materials.Salt, 1));
        Spodumen = new Werkstoff(Materials.Spodumene.mRGBa, "Spodumene", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addGems().addSifterRecipes(), 21, TextureSet.SET_FLINT, Collections.singletonList(Materials.Spodumene), new Pair<Materials, Integer>(Materials.Spodumene, 1));
        RockSalt = new Werkstoff(Materials.RockSalt.mRGBa, "Rock Salt", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addGems().addSifterRecipes(), 22, TextureSet.SET_FLINT, Arrays.asList(Materials.RockSalt, Materials.Borax), new Pair<Materials, Integer>(Materials.RockSalt, 1));
        Fayalit = new Werkstoff(new short[]{50, 50, 50, 0}, "Fayalite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 23, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Iron, Materials.Silicon), new Pair<Materials, Integer>(Materials.Iron, 2), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        Forsterit = new Werkstoff(new short[]{255, 255, 255, 0}, "Forsterite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 24, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Magnesium, Materials.Silicon), new Pair<Materials, Integer>(Materials.Magnesium, 2), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        Hedenbergit = new Werkstoff(new short[]{100, 150, 100, 0}, "Hedenbergite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 25, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Iron, Materials.Calcium, Materials.Silicon), new Pair<Materials, Integer>(Materials.Calcium, 1), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Silicon, 2), new Pair<Materials, Integer>(Materials.Oxygen, 6));
        DescloiziteZNVO4 = new Werkstoff(new short[]{191, 24, 15, 0}, "Red Descloizite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 26, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Lead, Materials.Copper, Materials.Vanadium), new Pair<Materials, Integer>(Materials.Lead, 1), new Pair<Materials, Integer>(Materials.Zinc, 1), new Pair<Materials, Integer>(Materials.Vanadium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        DescloiziteCUVO4 = new Werkstoff(new short[]{249, 109, 24, 0}, "Orange Descloizite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 27, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Lead, Materials.Zinc, Materials.Vanadium), new Pair<Materials, Integer>(Materials.Lead, 1), new Pair<Materials, Integer>(Materials.Copper, 1), new Pair<Materials, Integer>(Materials.Vanadium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        FuchsitAL = new Werkstoff(new short[]{77, 127, 100, 0}, "Green Fuchsite", BW_Util.subscriptNumbers("KAl3Si3O10(OH)2"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 28, TextureSet.SET_METALLIC, Arrays.asList(Materials.Potassium, Materials.Aluminium, Materials.Silicon), new Pair<Materials, Integer>(Materials.Potassium, 1), new Pair<Materials, Integer>(Materials.Aluminium, 3), new Pair<Materials, Integer>(Materials.Silicon, 3), new Pair<Materials, Integer>(Materials.Oxygen, 12), new Pair<Materials, Integer>(Materials.Hydrogen, 2));
        FuchsitCR = new Werkstoff(new short[]{128, 0, 0, 0}, "Red Fuchsite", BW_Util.subscriptNumbers("KCr3Si3O10(OH)2"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 29, TextureSet.SET_METALLIC, Arrays.asList(Materials.Potassium, Materials.Chrome, Materials.Silicon), new Pair<Materials, Integer>(Materials.Potassium, 1), new Pair<Materials, Integer>(Materials.Chrome, 3), new Pair<Materials, Integer>(Materials.Silicon, 3), new Pair<Materials, Integer>(Materials.Oxygen, 12), new Pair<Materials, Integer>(Materials.Hydrogen, 2));
        Thorium232 = new Werkstoff(new short[]{0, 64, 0, 0}, "Thorium 232", BW_Util.superscriptNumbers("Th232"), new Werkstoff.Stats().setRadioactive(true), Werkstoff.Types.ISOTOPE, new Werkstoff.GenerationFeatures().disable().onlyDust().enforceUnification(), 30, TextureSet.SET_METALLIC, new Pair[0]);
        BismuthTellurite = new Werkstoff(new short[]{32, 72, 32, 0}, "Bismuth Tellurite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addChemicalRecipes(), 31, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Tellurium, 3));
        Tellurium = new Werkstoff(new short[]{255, 255, 255, 0}, "Tellurium", new Werkstoff.Stats(), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().addMetalItems().removeOres(), 32, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Tellurium, 1));
        BismuthHydroBorat = new Werkstoff(new short[]{72, 144, 72, 0}, "Dibismuthhydroborat", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addChemicalRecipes(), 33, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Boron, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        ArInGaPhoBiBoTe = new Werkstoff(new short[]{36, 36, 36, 0}, "Circuit Compound MK3", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMixerRecipes(), 34, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.IndiumGalliumPhosphide, 1), new Pair<Werkstoff, Integer>(BismuthHydroBorat, 3), new Pair<Werkstoff, Integer>(BismuthTellurite, 2));
        Prasiolite = new Werkstoff(new short[]{208, 221, 149, 0}, "Prasiolite", new Werkstoff.Stats().setElektrolysis(true).setMeltingPoint(1923), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 35, TextureSet.SET_QUARTZ, new Pair<Materials, Integer>(Materials.Silicon, 5), new Pair<Materials, Integer>(Materials.Oxygen, 10), new Pair<Materials, Integer>(Materials.Iron, 1));
        MagnetoResonaticDust = new Werkstoff(new short[]{221, 119, 221, 0}, "Magneto Resonatic", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().onlyDust().addMixerRecipes().addGems(), 36, TextureSet.SET_MAGNETIC, new Pair<Werkstoff, Integer>(Prasiolite, 3), new Pair<Werkstoff, Integer>(BismuthTellurite, 4), new Pair<Werkstoff, Integer>(CubicZirconia, 1), new Pair<Materials, Integer>(Materials.SteelMagnetic, 1));
        Xenon = new Werkstoff(new short[]{20, 57, 127, 0}, "Xenon", "Xe", new Werkstoff.Stats().setProtons(54L).setMass(131L).setGas(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells().enforceUnification(), 37, TextureSet.SET_FLUID, new Pair[0]);
        Oganesson = new Werkstoff(new short[]{20, 57, 127, 0}, "Oganesson", "Og", new Werkstoff.Stats().setProtons(118L).setMass(294L).setGas(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells(), 38, TextureSet.SET_FLUID, new Pair[0]);
        Californium = new Werkstoff(new short[]{170, 170, 170, 0}, "Californium", "Cf", new Werkstoff.Stats().setProtons(98L).setMass(251L).setBlastFurnace(true).setMeltingPoint(900), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMolten().enforceUnification(), 39, TextureSet.SET_METALLIC, new Pair[0]);
        Calcium = new Werkstoff(Materials.Calcium.mRGBa, "Calcium", "Ca", new Werkstoff.Stats().setProtons(Element.Ca.mProtons).setMass(Element.Ca.getMass()).setBlastFurnace(true).setMeltingPoint(1115).setBoilingPoint(1757), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMolten(), 40, Materials.Calcium.mIconSet, new Pair[0]);
        Neon = new Werkstoff(new short[]{255, 7, 58}, "Neon", "Ne", new Werkstoff.Stats().setProtons(Element.Ne.mProtons).setMass(Element.Ne.getMass()).setGas(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells().enforceUnification(), 41, TextureSet.SET_FLUID, new Pair[0]);
        Krypton = new Werkstoff(new short[]{177, 255, 50}, "Krypton", "Kr", new Werkstoff.Stats().setProtons(Element.Kr.mProtons).setMass(Element.Kr.getMass()).setGas(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells().enforceUnification(), 42, TextureSet.SET_FLUID, new Pair[0]);
        BArTiMaEuSNeK = new Werkstoff(new short[]{0, 255, 0}, "BArTiMaEuSNeK", "Are you serious?", new Werkstoff.Stats().setMeltingPoint(9001).setCentrifuge(true).setBlastFurnace(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems().addMetalItems().addMolten(), 43, TextureSet.SET_DIAMOND, Arrays.asList(Materials.Boron, Materials.Titanium, Materials.Europium), new Pair<Materials, Integer>(Materials.Boron, 1), new Pair<Materials, Integer>(Materials.Argon, 1), new Pair<Materials, Integer>(Materials.Titanium, 1), new Pair<Materials, Integer>(Materials.Magic, 1), new Pair<Materials, Integer>(Materials.Europium, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Werkstoff, Integer>(Neon, 1), new Pair<Materials, Integer>(Materials.Potassium, 1));
        PTConcentrate = new Werkstoff(Materials.Platinum.getRGBA(), "Platinum Concentrate", "", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 44, TextureSet.SET_FLUID, new Pair[0]);
        PTSaltCrude = new Werkstoff(Materials.Platinum.getRGBA(), "Platinum Salt", "", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 45, TextureSet.SET_DULL, new Pair[0]);
        PTSaltRefined = new Werkstoff(Materials.Platinum.getRGBA(), "Refined Platinum Salt", "", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 46, TextureSet.SET_METALLIC, new Pair[0]);
        PTMetallicPowder = new Werkstoff(Materials.Platinum.getRGBA(), "Platinum Metallic Powder", "??PtPdIrOsRhRu??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 47, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Platinum, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        AquaRegia = new Werkstoff(new short[]{255, 177, 50}, "Aqua Regia", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 48, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.DilutedSulfuricAcid, 1), new Pair<Materials, Integer>(Materials.NitricAcid, 1));
        PTResidue = new Werkstoff(new short[]{100, 99, 46}, "Platinum Residue", "??IrOsRhRu??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 49, TextureSet.SET_ROUGH, new Pair[0]);
        AmmoniumChloride = new Werkstoff(new short[]{255, 255, 255}, "Ammonium Chloride", BW_Util.subscriptNumbers("NH4Cl"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 50, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Ammonium, 1), new Pair<Materials, Integer>(Materials.HydrochloricAcid, 1));
        PTRawPowder = new Werkstoff(Materials.Platinum.getRGBA(), "Reprecipitated Platinum", "PtCl", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 51, TextureSet.SET_METALLIC, new Pair[0]);
        PDAmmonia = new Werkstoff(Materials.Palladium.getRGBA(), "Palladium Enriched Ammonia", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 52, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Ammonium, 1), new Pair<Materials, Integer>(Materials.Palladium, 1));
        PDMetallicPowder = new Werkstoff(Materials.Palladium.getRGBA(), "Palladium Metallic Powder", "??Pd??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 53, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Palladium, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        PDRawPowder = new Werkstoff(Materials.Palladium.getRGBA(), "Reprecipitated Palladium", BW_Util.subscriptNumbers("Pd2NH4"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 54, TextureSet.SET_METALLIC, new Pair[0]);
        PDSalt = new Werkstoff(Materials.Palladium.getRGBA(), "Palladium Salt", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 55, TextureSet.SET_METALLIC, new Pair[0]);
        Sodiumformate = new Werkstoff(new short[]{255, 170, 170}, "Sodium Formate", "HCOONa", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 56, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.SodiumHydroxide, 1), new Pair<Materials, Integer>(Materials.CarbonMonoxide, 1));
        Sodiumsulfate = new Werkstoff(new short[]{255, 255, 255}, "Sodium Sulfate", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 57, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        FormicAcid = new Werkstoff(new short[]{255, 170, 119}, "Formic Acid", BW_Util.subscriptNumbers("CH2O2"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 58, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Carbon, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 2), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        PotassiumDisulfate = new Werkstoff(new short[]{251, 187, 102}, "Potassium Disulfate", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addChemicalRecipes(), 59, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Potassium, 2), new Pair<Materials, Integer>(Materials.Sulfur, 2), new Pair<Materials, Integer>(Materials.Oxygen, 7));
        LeachResidue = new Werkstoff(new short[]{100, 70, 41}, "Leach Residue", "??IrOsRu??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 60, TextureSet.SET_ROUGH, new Pair[0]);
        RHSulfate = new Werkstoff(new short[]{238, 170, 85}, "Rhodium Sulfate", new Werkstoff.Stats().setGas(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 61, TextureSet.SET_FLUID, new Pair[0]);
        RHSulfateSolution = new Werkstoff(new short[]{255, 187, 102}, "Rhodium Sulfate Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 62, TextureSet.SET_FLUID, new Pair[0]);
        CalciumChloride = new Werkstoff(new short[]{255, 255, 255}, "Calcium Chloride", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells(), 63, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Calcium, 1), new Pair<Materials, Integer>(Materials.Chlorine, 2));
        Ruthenium = new Werkstoff(new short[]{100, 100, 100}, "Ruthenium", "Ru", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(2607).setMass(Element.Ru.getMass()).setProtons(Element.Ru.mProtons), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().enforceUnification(), 64, TextureSet.SET_METALLIC, new Pair[0]);
        SodiumRuthenate = new Werkstoff(new short[]{58, 64, 203}, "Sodium Ruthenate", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 65, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        RutheniumTetroxide = new Werkstoff(new short[]{199, 199, 199}, "Ruthenium Tetroxide", new Werkstoff.Stats().setMeltingPoint(313), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells(), 66, TextureSet.SET_DULL, new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        HotRutheniumTetroxideSollution = new Werkstoff(new short[]{199, 199, 199}, "Hot Ruthenium Tetroxide Solution", "???", new Werkstoff.Stats().setGas(true).setMeltingPoint(700), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 67, TextureSet.SET_FLUID, new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4), new Pair<Materials, Integer>(Materials.Chlorine, 2), new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Materials, Integer>(Materials.Water, 2));
        RutheniumTetroxideSollution = new Werkstoff(new short[]{199, 199, 199}, "Ruthenium Tetroxide Solution", "???", new Werkstoff.Stats().setMeltingPoint(313), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 68, TextureSet.SET_FLUID, new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4), new Pair<Materials, Integer>(Materials.Chlorine, 2), new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Materials, Integer>(Materials.Water, 2));
        IrOsLeachResidue = new Werkstoff(new short[]{100, 70, 41}, "Rarest Metal Residue", "??OsIr??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 69, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Osmiridium, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        IrLeachResidue = new Werkstoff(new short[]{132, 102, 73}, "Iridium Metal Residue", "??Ir??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 70, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        PGSDResidue = new Werkstoff(new short[]{132, 102, 73}, "Sludge Dust Residue", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 71, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.SiliconDioxide, 3), new Pair<Materials, Integer>(Materials.Gold, 2));
        AcidicOsmiumSolution = new Werkstoff(new short[]{132, 102, 73}, "Acidic Osmium Solution", "???", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 72, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Osmium, 1), new Pair<Materials, Integer>(Materials.HydrochloricAcid, 1));
        IridiumDioxide = new Werkstoff(new short[]{132, 102, 73}, "Iridium Dioxide", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 73, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        OsmiumSolution = new Werkstoff(new short[]{132, 102, 73}, "Osmium Solution", "???", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 74, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Osmium, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        AcidicIridiumSolution = new Werkstoff(new short[]{132, 102, 73}, "Acidic Iridium Solution", "???", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 75, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        IridiumChloride = new Werkstoff(new short[]{132, 102, 73}, "Iridium Chloride", BW_Util.subscriptNumbers("IrCl3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 76, TextureSet.SET_LAPIS, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Chlorine, 3));
        PGSDResidue2 = new Werkstoff(new short[]{132, 102, 73}, "Metallic Sludge Dust Residue", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 77, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Nickel, 1), new Pair<Materials, Integer>(Materials.Copper, 1));
        Rhodium = new Werkstoff(new short[]{244, 244, 244}, "Rhodium", "Rh", new Werkstoff.Stats().setProtons(Element.Rh.mProtons).setMass(Element.Rh.getMass()).setBlastFurnace(true).setMeltingPoint(2237), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMolten().enforceUnification(), 78, TextureSet.SET_METALLIC, new Pair[0]);
        CrudeRhMetall = new Werkstoff(new short[]{102, 102, 102}, "Crude Rhodium Metal", "??Rh??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 79, TextureSet.SET_DULL, new Pair<Werkstoff, Integer>(Rhodium, 1), new Pair<Materials, Integer>(Materials.Stone, 1));
        RHSalt = new Werkstoff(new short[]{132, 132, 132}, "Rhodium Salt", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 80, TextureSet.SET_GEM_VERTICAL, new Pair[0]);
        RHSaltSolution = new Werkstoff(new short[]{102, 119, 136}, "Rhodium Salt Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 81, TextureSet.SET_FLUID, new Pair[0]);
        SodiumNitrate = new Werkstoff(new short[]{132, 102, 132}, "Sodium Nitrate", BW_Util.subscriptNumbers("NaNO3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addChemicalRecipes(), 82, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.NitricAcid, 1));
        RHNitrate = new Werkstoff(new short[]{119, 102, 73}, "Rhodium Nitrate", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 83, TextureSet.SET_QUARTZ, new Pair[0]);
        ZincSulfate = new Werkstoff(new short[]{132, 102, 73}, "Zinc Sulfate", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 84, TextureSet.SET_QUARTZ, new Pair<Materials, Integer>(Materials.Zinc, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        RhFilterCake = new Werkstoff(new short[]{119, 102, 73}, "Rhodium Filter Cake", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 85, TextureSet.SET_QUARTZ, new Pair[0]);
        RHFilterCakeSolution = new Werkstoff(new short[]{102, 119, 136}, "Rhodium Filter Cake Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 86, TextureSet.SET_FLUID, new Pair[0]);
        ReRh = new Werkstoff(new short[]{119, 102, 73}, "Reprecipitated Rhodium", BW_Util.subscriptNumbers("Rh2NH4"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 87, TextureSet.SET_QUARTZ, new Pair[0]);
        LuVTierMaterial = new Werkstoff(Materials.Chrome.getRGBA(), "Rhodium-Plated Palladium", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(4500), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMixerRecipes().addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 88, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Palladium, 3), new Pair<Werkstoff, Integer>(Rhodium, 1));
        Tiberium = new Werkstoff(new short[]{34, 238, 34}, "Tiberium", "Tr", new Werkstoff.Stats().setProtons(123L).setMass(326L).setBlastFurnace(true).setMeltingPoint(1800).setRadioactive(true).setToxic(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().addGems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems(), 89, TextureSet.SET_DIAMOND, new Pair[0]);
        Ruridit = new Werkstoff(new short[]{164, 164, 164}, "Ruridit", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(4500), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMixerRecipes().addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 90, TextureSet.SET_METALLIC, new Pair<Werkstoff, Integer>(Ruthenium, 2), new Pair<Materials, Integer>(Materials.Iridium, 1));
        Fluorspar = new Werkstoff(new short[]{185, 69, 251}, "Fluorspar", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 91, TextureSet.SET_GEM_VERTICAL, new Pair<Materials, Integer>(Materials.Calcium, 1), new Pair<Materials, Integer>(Materials.Fluorine, 2));
        HDCS = new Werkstoff(new short[]{51, 68, 51}, "High Durability Compound Steel", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(9000), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMixerRecipes().addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 92, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.TungstenSteel, 12), new Pair<Materials, Integer>(Materials.HSSE, 9), new Pair<Materials, Integer>(Materials.HSSG, 6), new Pair<Werkstoff, Integer>(Ruridit, 3), new Pair<Werkstoff, Integer>(MagnetoResonaticDust, 2), new Pair<Materials, Integer>(Materials.Plutonium, 1));
        Atheneite = new Werkstoff(new short[]{175, 175, 175}, "Atheneite", BW_Util.subscriptNumbers("(Pd,Hg)3As"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 93, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(PDMetallicPowder, 3), new Pair<Materials, Integer>(Materials.Mercury, 3), new Pair<Materials, Integer>(Materials.Arsenic, 1));
        Temagamite = new Werkstoff(new short[]{245, 245, 245}, "Temagamite", BW_Util.subscriptNumbers("Pd3HgTe"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 94, TextureSet.SET_ROUGH, new Pair<Werkstoff, Integer>(PDMetallicPowder, 3), new Pair<Materials, Integer>(Materials.Mercury, 1), new Pair<Materials, Integer>(Materials.Tellurium, 1));
        Terlinguaite = new Werkstoff(new short[]{245, 245, 245}, "Terlinguaite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 95, TextureSet.SET_GEM_HORIZONTAL, new Pair<Materials, Integer>(Materials.Mercury, 2), new Pair<Materials, Integer>(Materials.Chlorine, 1), new Pair<Materials, Integer>(Materials.Oxygen, 1));
        AdemicSteel = new Werkstoff(new short[]{204, 204, 204}, "Ademic Steel", "The break in the line", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setDurOverride(6144).setMeltingPoint(1800).setSpeedOverride(12.0f).setQualityOverride((byte)4), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMetalItems().addCraftingMetalWorkingItems().addMolten().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 96, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Steel, 2), new Pair<Materials, Integer>(Materials.VanadiumSteel, 1), new Pair<Materials, Integer>(Materials.DamascusSteel, 1), new Pair<Materials, Integer>(Materials.Carbon, 4));
        RawAdemicSteel = new Werkstoff(new short[]{237, 237, 237}, "Raw Ademic Steel", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMixerRecipes(), 97, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Steel, 2), new Pair<Materials, Integer>(Materials.VanadiumSteel, 1), new Pair<Materials, Integer>(Materials.DamascusSteel, 1));
        items = new HashMap();
        fluids = HashBiMap.create();
        molten = HashBiMap.create();
        ENABLED_ORE_PREFIXES = new HashSet();
    }
}

