/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.AfterLuVTierEnhacement;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class LuVTierEnhancer
implements Runnable {
    @Override
    public void run() {
        List bufferedRecipeList = null;
        try {
            bufferedRecipeList = (List)FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true).get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        HashSet<ItemStack> LuVMachines = new HashSet<ItemStack>();
        LuVMachines.add(ItemRegistry.cal);
        OrePrefixes[] LuVMaterialsGenerated = new OrePrefixes[]{OrePrefixes.dust, OrePrefixes.ingot, OrePrefixes.plate, OrePrefixes.stick, OrePrefixes.stickLong, OrePrefixes.rotor, OrePrefixes.plateDouble, OrePrefixes.plateDense};
        Arrays.stream(ItemList.values()).filter(item -> item.toString().contains("LuV") && item.hasBeenSet()).forEach(item -> LuVMachines.add(item.get(1L, new Object[0])));
        if (LoaderReference.dreamcraft) {
            LuVTierEnhancer.addDreamcraftItemListItems(LuVMachines);
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Casing_LuV.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.REVERSIBLE | GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES), (Object[])new Object[]{"PPP", "PwP", "PPP", Character.valueOf('P'), WerkstoffLoader.LuVTierMaterial.get(OrePrefixes.plate)});
        LuVTierEnhancer.replaceAllRecipes(LuVMachines, LuVMaterialsGenerated, bufferedRecipeList);
        AfterLuVTierEnhacement.run();
    }

    private static void replaceAllRecipes(Collection<ItemStack> LuVMachines, OrePrefixes[] LuVMaterialsGenerated, List<IRecipe> bufferedRecipeList) {
        LuVTierEnhancer.replaceOsmiridiumInLuVRecipes();
        LuVMachines.stream().forEach(stack -> {
            Predicate<Object> recipeFilter = obj -> obj instanceof GT_Shaped_Recipe && GT_Utility.areStacksEqual((ItemStack)((GT_Shaped_Recipe)obj).getRecipeOutput(), (ItemStack)stack, (boolean)true);
            GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes.forEach(recipe -> LuVTierEnhancer.rewriteAsslineRecipes(stack, LuVMaterialsGenerated, recipe));
            GT_Recipe.GT_Recipe_Map.sMappings.forEach(map -> map.mRecipeList.forEach(recipe -> LuVTierEnhancer.rewriteMachineRecipes(stack, LuVMaterialsGenerated, recipe)));
            LuVTierEnhancer.rewriteCraftingRecipes(bufferedRecipeList, LuVMaterialsGenerated, recipeFilter);
        });
    }

    private static void addDreamcraftItemListItems(Collection LuVMachines) {
        try {
            Class<?> customItemListClass = Class.forName("com.dreammaster.gthandler.CustomItemList");
            Method hasnotBeenSet = MethodUtils.getAccessibleMethod(customItemListClass, (String)"hasBeenSet", (Class[])new Class[0]);
            Method get = MethodUtils.getAccessibleMethod(customItemListClass, (String)"get", (Class[])new Class[]{Long.TYPE, Object[].class});
            for (Enum customItemList : (Enum[])FieldUtils.getField(customItemListClass, (String)"$VALUES", (boolean)true).get(null)) {
                if (!customItemList.toString().contains("LuV") || !((Boolean)hasnotBeenSet.invoke((Object)customItemList, new Object[0])).booleanValue()) continue;
                LuVMachines.add((ItemStack)get.invoke((Object)customItemList, 1, new Object[0]));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void rewriteCraftingRecipes(List<IRecipe> bufferedRecipeList, OrePrefixes[] LuVMaterialsGenerated, Predicate recipeFilter) {
        for (OrePrefixes prefixes : LuVMaterialsGenerated) {
            Consumer<Object> recipeAction = obj -> LuVTierEnhancer.doStacksCointainAndReplace(((GT_Shaped_Recipe)obj).getInput(), GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            CraftingManager.getInstance().getRecipeList().stream().filter(recipeFilter).forEach(recipeAction);
            bufferedRecipeList.stream().filter(recipeFilter).forEach(recipeAction);
        }
    }

    private static void rewriteMachineRecipes(ItemStack stack, OrePrefixes[] LuVMaterialsGenerated, GT_Recipe recipe) {
        for (OrePrefixes prefixes : LuVMaterialsGenerated) {
            if (LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
                LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
                LuVTierEnhancer.doStacksCointainAndReplace(recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            }
            if (!LuVTierEnhancer.doStacksCointainAndReplace(recipe.mOutputs, stack, false, new ItemStack[0])) continue;
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
        }
        if (LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
        if (LuVTierEnhancer.doStacksCointainAndReplace(recipe.mOutputs, stack, false, new ItemStack[0])) {
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
    }

    private static void rewriteAsslineRecipes(ItemStack stack, OrePrefixes[] LuVMaterialsGenerated, GT_Recipe.GT_Recipe_AssemblyLine recipe) {
        for (OrePrefixes prefixes : LuVMaterialsGenerated) {
            if (LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
                LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
                LuVTierEnhancer.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            }
            if (!LuVTierEnhancer.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) continue;
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            LuVTierEnhancer.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
        }
        if (LuVTierEnhancer.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
        if (LuVTierEnhancer.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) {
            LuVTierEnhancer.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
    }

    private static void replaceOsmiridiumInLuVRecipes() {
        ItemData ass;
        ItemStack stack;
        int i;
        for (GT_Recipe.GT_Recipe_AssemblyLine recipe_assemblyLine : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
            if (recipe_assemblyLine.mEUt > 6000) continue;
            for (i = 0; i < recipe_assemblyLine.mInputs.length; ++i) {
                stack = recipe_assemblyLine.mInputs[i];
                if (!BW_Util.checkStackAndPrefix(stack)) continue;
                ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
                if (!ass.mMaterial.mMaterial.equals(Materials.Osmiridium) || WerkstoffLoader.items.get(ass.mPrefix) == null) continue;
                recipe_assemblyLine.mInputs[i] = WerkstoffLoader.Ruridit.get(ass.mPrefix, stack.stackSize);
            }
        }
        for (GT_Recipe.GT_Recipe_AssemblyLine recipe_assemblyLine : GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList) {
            if (recipe_assemblyLine.mEUt > BW_Util.getTierVoltage(6) || BW_Util.checkStackAndPrefix(recipe_assemblyLine.mOutputs[0])) continue;
            for (i = 0; i < recipe_assemblyLine.mInputs.length; ++i) {
                stack = recipe_assemblyLine.mInputs[i];
                if (!BW_Util.checkStackAndPrefix(stack)) continue;
                ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
                if (!ass.mMaterial.mMaterial.equals(Materials.Osmiridium) || WerkstoffLoader.items.get(ass.mPrefix) == null) continue;
                recipe_assemblyLine.mInputs[i] = WerkstoffLoader.Ruridit.get(ass.mPrefix, stack.stackSize);
            }
        }
        for (GT_Recipe.GT_Recipe_AssemblyLine recipe_assemblyLine : GT_Recipe.GT_Recipe_Map.sAssemblylineVisualRecipes.mRecipeList) {
            if (recipe_assemblyLine.mEUt > 6000) continue;
            for (i = 0; i < recipe_assemblyLine.mInputs.length; ++i) {
                stack = recipe_assemblyLine.mInputs[i];
                if (!BW_Util.checkStackAndPrefix(stack)) continue;
                ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
                if (!ass.mMaterial.mMaterial.equals(Materials.Osmiridium) || WerkstoffLoader.items.get(ass.mPrefix) == null) continue;
                recipe_assemblyLine.mInputs[i] = WerkstoffLoader.Ruridit.get(ass.mPrefix, stack.stackSize);
            }
        }
    }

    private static boolean doStacksCointainAndReplace(FluidStack[] stacks, FluidStack stack, boolean replace, Fluid ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)stack, (FluidStack)stacks[i])) continue;
            if (!replace) {
                return true;
            }
            int amount = stacks[i].amount;
            stacks[i] = new FluidStack(replacement[0], amount);
            replaced = true;
        }
        return replaced;
    }

    private static boolean doStacksCointainAndReplace(Object[] stacks, ItemStack stack, boolean replace, ItemStack ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            int amount;
            if (!GT_Utility.isStackValid((Object)stacks[i])) {
                if (!(stacks[i] instanceof ArrayList) || ((ArrayList)stacks[i]).size() <= 0 || !GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)((ArrayList)stacks[i]).get(0)), (boolean)true)) continue;
                if (!replace) {
                    return true;
                }
                amount = ((ItemStack)((ArrayList)stacks[i]).get((int)0)).stackSize;
                stacks[i] = new ArrayList();
                ((ArrayList)stacks[i]).add(replacement[0].splitStack(amount));
                replaced = true;
                continue;
            }
            if (!GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)stacks[i]), (boolean)true)) continue;
            if (!replace) {
                return true;
            }
            amount = ((ItemStack)stacks[i]).stackSize;
            stacks[i] = replacement[0].splitStack(amount);
            replaced = true;
        }
        return replaced;
    }
}

