/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration;

import com.github.bartimaeusnek.ASM.BWCoreStaticReplacementMethodes;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitData;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CircuitImprintLoader {
    public static short reverseIDs = (short)32766;
    public static final ArrayListMultimap<NBTTagCompound, GT_Recipe> recipeTagMap = ArrayListMultimap.create();
    public static final HashBiMap<Short, ItemList> circuitIIconRefs = HashBiMap.create((int)20);
    public static final HashSet<ItemStack> blacklistSet = new HashSet();
    static final HashBiMap<CircuitData, ItemStack> bwCircuitTagMap = HashBiMap.create((int)20);
    private static final HashSet<IRecipe> recipeWorldCache = new HashSet();
    private static final HashSet<GT_Recipe> gtrecipeWorldCache = new HashSet();
    private static final HashSet<GT_Recipe> ORIGINAL_CAL_RECIPES = new HashSet();
    private static final HashSet<GT_Recipe> MODIFIED_CAL_RECIPES = new HashSet();

    public static void run() {
        HashSet<GT_Recipe> toRem = new HashSet<GT_Recipe>();
        HashSet<GT_Recipe> toAdd = new HashSet<GT_Recipe>();
        CircuitImprintLoader.deleteCALRecipesAndTags();
        CircuitImprintLoader.rebuildCircuitAssemblerMap(toRem, toAdd);
        CircuitImprintLoader.exchangeRecipesInList(toRem, toAdd);
        CircuitImprintLoader.makeCircuitImprintRecipes();
        toRem = null;
        toAdd = null;
    }

    private static void reAddOriginalRecipes() {
        GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.mRecipeList.removeAll(MODIFIED_CAL_RECIPES);
        GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.mRecipeList.addAll(ORIGINAL_CAL_RECIPES);
        ORIGINAL_CAL_RECIPES.clear();
        MODIFIED_CAL_RECIPES.clear();
    }

    private static void rebuildCircuitAssemblerMap(HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd) {
        CircuitImprintLoader.reAddOriginalRecipes();
        GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.mRecipeList.forEach(e -> CircuitImprintLoader.handleCircuitRecipeRebuilding(e, toRem, toAdd));
    }

    private static void handleCircuitRecipeRebuilding(GT_Recipe circuitRecipe, HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd) {
        ItemStack[] outputs = circuitRecipe.mOutputs;
        String name = CircuitImprintLoader.getTypeFromOreDict(outputs);
        if (name.contains("Circuit") || name.contains("circuit")) {
            recipeTagMap.put((Object)CircuitImprintLoader.getTagFromStack(outputs[0]), (Object)circuitRecipe.copy());
            if (circuitRecipe.mFluidInputs[0].isFluidEqual(Materials.SolderingAlloy.getMolten(0L))) {
                GT_Recipe newRecipe = CircuitImprintLoader.reBuildRecipe(circuitRecipe);
                if (newRecipe != null) {
                    BWRecipes.instance.getMappingsFor((byte)3).addRecipe(newRecipe);
                }
                CircuitImprintLoader.addCutoffRecipeToSets(toRem, toAdd, circuitRecipe);
            } else if (circuitRecipe.mEUt > BW_Util.getTierVoltage(ConfigHandler.cutoffTier)) {
                toRem.add(circuitRecipe);
            }
        }
    }

    private static String getTypeFromOreDict(ItemStack[] outputs) {
        int[] oreIDS = OreDictionary.getOreIDs((ItemStack)outputs[0]);
        if (oreIDS.length < 1) {
            return "";
        }
        return OreDictionary.getOreName((int)oreIDS[0]);
    }

    private static void exchangeRecipesInList(HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd) {
        GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.mRecipeList.addAll(toAdd);
        GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.mRecipeList.removeAll(toRem);
        ORIGINAL_CAL_RECIPES.addAll(toRem);
        MODIFIED_CAL_RECIPES.addAll(toAdd);
    }

    private static void addCutoffRecipeToSets(HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd, GT_Recipe circuitRecipe) {
        if (circuitRecipe.mEUt > BW_Util.getTierVoltage(ConfigHandler.cutoffTier)) {
            toRem.add(circuitRecipe);
            toAdd.add(CircuitImprintLoader.makeMoreExpensive(circuitRecipe));
        }
    }

    public static GT_Recipe makeMoreExpensive(GT_Recipe original) {
        GT_Recipe newRecipe = original.copy();
        for (ItemStack is : newRecipe.mInputs) {
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)is);
            if (oreIDs != null && oreIDs.length >= 1 && OreDictionary.getOreName((int)oreIDs[0]).contains("circuit")) continue;
            is.stackSize = Math.min(is.stackSize * 6, 64);
            if (is.stackSize <= is.getItem().getItemStackLimit() && is.stackSize <= is.getMaxStackSize()) continue;
            is.stackSize = is.getMaxStackSize();
        }
        newRecipe.mFluidInputs[0].amount *= 4;
        newRecipe.mDuration *= 4;
        return newRecipe;
    }

    public static GT_Recipe reBuildRecipe(GT_Recipe original) {
        ItemStack[] in = new ItemStack[6];
        BiMap inversed = circuitIIconRefs.inverse();
        for (int i = 0; i < 6; ++i) {
            try {
                CircuitImprintLoader.replaceCircuits((BiMap<ItemList, Short>)inversed, original, in, i);
                CircuitImprintLoader.replaceComponents(in, original, i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        if (CircuitImprintLoader.checkForBlacklistedComponents(in)) {
            return null;
        }
        return new BWRecipes.DynamicGTRecipe(false, in, new ItemStack[]{CircuitImprintLoader.getOutputMultiplied(original)}, BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(CircuitImprintLoader.getTagFromStack(original.mOutputs[0]), 0, 0), null, original.mFluidInputs, null, original.mDuration * 12, original.mEUt, 0);
    }

    private static ItemStack getOutputMultiplied(GT_Recipe original) {
        ItemStack out = original.copy().getOutput(0);
        out.stackSize *= 16;
        return out;
    }

    private static void replaceCircuits(BiMap<ItemList, Short> inversed, GT_Recipe original, ItemStack[] in, int index) {
        for (ItemList il : inversed.keySet()) {
            if (!GT_Utility.areStacksEqual((ItemStack)il.get(1L, new Object[0]), (ItemStack)original.mInputs[index])) continue;
            in[index] = BW_Meta_Items.getNEWCIRCUITS().getStack(((Short)inversed.get((Object)il)).shortValue(), original.mInputs[index].stackSize);
        }
    }

    private static void replaceComponents(ItemStack[] in, GT_Recipe original, int index) throws ArrayIndexOutOfBoundsException {
        if (original.mInputs[index] != null && in[index] == null) {
            if (BW_Util.checkStackAndPrefix(original.mInputs[index]) && GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mPrefix == OrePrefixes.wireGt01) {
                in[index] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt16, (Object)GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].stackSize);
            } else if (BW_Util.checkStackAndPrefix(original.mInputs[index]) && GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mPrefix == OrePrefixes.wireFine) {
                in[index] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].stackSize);
            } else {
                in[index] = original.mInputs[index].copy();
                in[index].stackSize *= 16;
                if (in[index].stackSize > in[index].getItem().getItemStackLimit() || in[index].stackSize > in[index].getMaxStackSize()) {
                    in[index].stackSize = in[index].getMaxStackSize();
                }
            }
        }
    }

    private static void makeCircuitImprintRecipes() {
        CircuitImprintLoader.removeOldRecipesFromRegistries();
        recipeTagMap.keySet().forEach(e -> {
            CircuitImprintLoader.makeAndAddSlicingRecipe(e);
            CircuitImprintLoader.makeAndAddCraftingRecipes(e);
        });
    }

    private static boolean checkForBlacklistedComponents(ItemStack[] itemStacks) {
        for (ItemStack is : itemStacks) {
            for (ItemStack is2 : blacklistSet) {
                if (!GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)is2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void removeOldRecipesFromRegistries() {
        recipeWorldCache.forEach(CraftingManager.getInstance().getRecipeList()::remove);
        BWCoreStaticReplacementMethodes.RECENTLYUSEDRECIPES.clear();
        gtrecipeWorldCache.forEach(GT_Recipe.GT_Recipe_Map.sSlicerRecipes.mRecipeList::remove);
        recipeWorldCache.forEach(r -> {
            try {
                BW_Util.getGTBufferedRecipeList().remove(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        recipeWorldCache.clear();
        gtrecipeWorldCache.clear();
    }

    private static void makeAndAddSlicingRecipe(NBTTagCompound tag) {
        ItemStack stack = CircuitImprintLoader.getStackFromTag(tag);
        int eut = Integer.MAX_VALUE;
        for (GT_Recipe recipe : recipeTagMap.get((Object)tag)) {
            eut = Math.min(eut, recipe.mEUt);
        }
        eut = Math.min(eut, BW_Util.getMachineVoltageFromTier(BW_Util.getCircuitTierFromOreDictName(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0]))));
        BWRecipes.DynamicGTRecipe slicingRecipe = new BWRecipes.DynamicGTRecipe(true, new ItemStack[]{stack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(tag, 1, 1)}, null, null, null, null, 300, eut, -200);
        gtrecipeWorldCache.add(slicingRecipe);
        GT_Recipe.GT_Recipe_Map.sSlicerRecipes.add((GT_Recipe)slicingRecipe);
    }

    private static void makeAndAddCraftingRecipes(NBTTagCompound tag) {
        ItemStack circuit = BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(tag, 0, 1);
        Object[] imprintRecipe = new Object[]{" X ", "GPG", " X ", Character.valueOf('P'), BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(tag, 1, 1), Character.valueOf('G'), WerkstoffLoader.Prasiolite.get(OrePrefixes.gemExquisite, 1), Character.valueOf('X'), BW_Meta_Items.getNEWCIRCUITS().getStack(3)};
        BWRecipes.BWNBTDependantCraftingRecipe bwrecipe = new BWRecipes.BWNBTDependantCraftingRecipe(circuit, imprintRecipe);
        ShapedOreRecipe gtrecipe = BW_Util.createGTCraftingRecipe(circuit, GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.KEEPNBT | GT_ModHandler.RecipeBits.BUFFERED, imprintRecipe);
        recipeWorldCache.add(bwrecipe);
        GameRegistry.addRecipe((IRecipe)bwrecipe);
        recipeWorldCache.add((IRecipe)gtrecipe);
        GameRegistry.addRecipe((IRecipe)gtrecipe);
    }

    public static NBTTagCompound getTagFromStack(ItemStack stack) {
        if (GT_Utility.isStackValid((Object)stack)) {
            return stack.copy().splitStack(1).writeToNBT(new NBTTagCompound());
        }
        return new NBTTagCompound();
    }

    public static ItemStack getStackFromTag(NBTTagCompound tagCompound) {
        return ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
    }

    private static void deleteCALRecipesAndTags() {
        BWRecipes.instance.getMappingsFor((byte)3).mRecipeList.clear();
        recipeTagMap.clear();
    }
}

