/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material;

import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Blocks;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BW_MetaGenerated_Ores
extends BW_MetaGenerated_Blocks {
    public BW_MetaGenerated_Ores(Material p_i45386_1_, Class<? extends TileEntity> tileEntity, String blockName) {
        super(p_i45386_1_, tileEntity, blockName);
    }

    @Override
    protected void doRegistrationStuff(Werkstoff w) {
        if (w != null) {
            if ((w.getGenerationFeatures().toGenerate & 8) == 0 || (w.getGenerationFeatures().blacklist & 8) != 0) {
                return;
            }
            GT_ModHandler.addValuableOre((Block)this, (int)w.getmID(), (int)1);
            GT_LanguageManager.addStringLocalization((String)(this.getUnlocalizedName() + "." + w.getmID() + ".name"), (String)(w.getDefaultName() + OrePrefixes.ore.mLocalizedMaterialPost));
        }
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean air, Block block, int[] aBlockMeta) {
        if (!air) {
            aY = Math.min(aWorld.getActualHeight(), Math.max(aY, 1));
        }
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        Block tOreBlock = WerkstoffLoader.BWOres;
        if (aMetaData < 0 || tBlock == Blocks.air && !air) {
            return false;
        }
        if (Block.getIdFromBlock((Block)tBlock) != Block.getIdFromBlock((Block)block)) {
            return false;
        }
        int aaY = aY;
        if (Arrays.stream(aBlockMeta).noneMatch(e -> e == aWorld.getBlockMetadata(aX, aaY, aZ))) {
            return false;
        }
        aWorld.setBlock(aX, aY, aZ, tOreBlock, aMetaData, 0);
        TileEntity tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof BW_MetaGeneratedOreTE) {
            ((BW_MetaGeneratedOreTE)tTileEntity).mMetaData = (short)aMetaData;
        }
        return true;
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        return Blocks.stone.getIcon(0, 0);
    }

    public IIcon getIcon(IBlockAccess p_149673_1_, int p_149673_2_, int p_149673_3_, int p_149673_4_, int p_149673_5_) {
        return Blocks.stone.getIcon(0, 0);
    }

    public int getHarvestLevel(int metadata) {
        return 3;
    }

    public String getUnlocalizedName() {
        return "bw.blockores.01";
    }

    public void getSubBlocks(Item aItem, CreativeTabs aTab, List aList) {
        for (Werkstoff tMaterial : Werkstoff.werkstoffHashSet) {
            if (tMaterial == null || (tMaterial.getGenerationFeatures().toGenerate & 8) == 0 || (tMaterial.getGenerationFeatures().blacklist & 8) != 0) continue;
            aList.add(new ItemStack(aItem, 1, (int)tMaterial.getmID()));
        }
    }

    private boolean checkForAir(IBlockAccess aWorld, int aX, int aY, int aZ) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0 || !aWorld.getBlock(aX + x, aY + y, aZ + z).isAir(aWorld, aX + x, aY + y, aZ + z)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

