/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TileEntity_ManualTrafo
extends GT_MetaTileEntity_MultiBlockBase {
    private static final byte SINGLE_UPSTEP = 0;
    private static final byte SINGLE_DOWNSTEP = 1;
    private static final byte MULTI_UPSTEP = 2;
    private static final byte MULTI_DOWNSTEP = 3;
    private byte mode;
    private byte texid = (byte)2;
    private long mCoilWicks;
    private boolean upstep = true;

    public GT_TileEntity_ManualTrafo(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ManualTrafo(String aName) {
        super(aName);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine();
            return false;
        }
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        if (this.getBaseMetaTileEntity().getTimer() % 40L == 0L) {
            this.mEfficiency = this.mEfficiency < this.getMaxEfficiency(null) ? (this.mEfficiency += 100) : this.getMaxEfficiency(null);
        }
        if (this.mode > 1) {
            return this.onRunningTickTabbedMode();
        }
        return this.drainEnergyInput(this.getInputTier() * 2L * (long)this.mEnergyHatches.size()) && this.addEnergyOutput(this.getInputTier() * 2L * (long)this.mEnergyHatches.size() * (long)this.mEfficiency / (long)this.getMaxEfficiency(null));
    }

    public boolean onRunningTickTabbedMode() {
        boolean ret = false;
        for (GT_MetaTileEntity_Hatch_Dynamo E : this.mDynamoHatches) {
            for (GT_MetaTileEntity_Hatch_Energy I : this.mEnergyHatches) {
                long vtt;
                long l = vtt = I.getEUVar() >= GT_Values.V[E.mTier] / 2L && E.getEUVar() < E.maxEUStore() ? I.getEUVar() : 0L;
                if (vtt == 0L) continue;
                long vtp = E.getEUVar() + vtt;
                long avt = Math.min(vtp, E.maxEUStore());
                E.setEUVar(avt);
                I.setEUVar(I.getEUVar() - vtt);
                ret = true;
            }
        }
        return ret;
    }

    public long getInputTier() {
        if (this.mEnergyHatches.size() > 0) {
            return GT_Utility.getTier((long)((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage());
        }
        return 0L;
    }

    public long getOutputTier() {
        if (this.mDynamoHatches.size() > 0) {
            return GT_Utility.getTier((long)((GT_MetaTileEntity_Hatch_Dynamo)this.mDynamoHatches.get(0)).getBaseMetaTileEntity().getOutputVoltage());
        }
        return 0L;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine();
            return false;
        }
        this.mode = this.mInventory[1] == null ? (byte)0 : (this.mInventory[1].getUnlocalizedName().startsWith("gt.integrated_circuit") ? (this.mInventory[1].getItemDamage() > 4 ? (byte)this.mInventory[1].getItemDamage() : (byte)0) : (byte)0);
        this.upstep = this.mode == 0 || this.mode == 2;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        this.mEfficiency = Math.max(this.mEfficiency, 100);
        return this.upstep ? this.getOutputTier() - this.getInputTier() == this.mCoilWicks : this.getInputTier() - this.getOutputTier() == this.mCoilWicks;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        byte by = this.mInventory[1] == null ? (byte)0 : (this.mInventory[1].getUnlocalizedName().startsWith("gt.integrated_circuit") ? (this.mInventory[1].getItemDamage() > 4 ? (byte)this.mInventory[1].getItemDamage() : (byte)0) : (this.mode = 0));
        if (this.mode <= 1) {
            IGregTechTileEntity tTileEntity;
            int z;
            int x;
            int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
            int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
            int y = 1;
            boolean stillcoil = true;
            block0: while (stillcoil) {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        boolean bl = stillcoil = aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(ItemRegistry.BW_BLOCKS[2]) && aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == 1;
                        if (!stillcoil) break;
                        ++this.mCoilWicks;
                        if (this.mCoilWicks % 8L != 0L) continue;
                        ++y;
                    }
                    if (!stillcoil) continue block0;
                }
            }
            if (this.mCoilWicks % 8L != 0L) {
                return false;
            }
            this.mCoilWicks /= 8L;
            int i = 1;
            while ((long)i <= this.mCoilWicks) {
                if (!aBaseMetaTileEntity.getBlockOffset(xDir, i, zDir).equals(ItemRegistry.BW_BLOCKS[2]) && aBaseMetaTileEntity.getMetaIDOffset(xDir, i, zDir) == 0) {
                    return false;
                }
                ++i;
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (xDir + x == 0 && zDir + z == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, 0, zDir + z), this.texid) || this.addEnergyInputToMachineList(tTileEntity, this.texid) || aBaseMetaTileEntity.getBlockOffset(xDir + x, 0, zDir + z) == GregTech_API.sBlockCasings1) continue;
                    return false;
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, (int)this.mCoilWicks + 1, zDir + z);
                    if (this.addMaintenanceToMachineList(tTileEntity, this.texid) || this.addDynamoToMachineList(tTileEntity, this.texid) || aBaseMetaTileEntity.getBlockOffset(xDir + x, (int)this.mCoilWicks + 1, zDir + z) == GregTech_API.sBlockCasings1) continue;
                    return false;
                }
            }
            byte outtier = ((GT_MetaTileEntity_Hatch_Dynamo)this.mDynamoHatches.get((int)0)).mTier;
            for (Object out : this.mDynamoHatches) {
                if (((GT_MetaTileEntity_Hatch_Dynamo)out).mTier == outtier) continue;
                return false;
            }
            byte intier = ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get((int)0)).mTier;
            for (GT_MetaTileEntity_Hatch_Energy in : this.mEnergyHatches) {
                if (in.mTier == intier) continue;
                return false;
            }
        } else {
            IGregTechTileEntity tTileEntity;
            int z;
            int x;
            int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 2;
            int yDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetY * 2;
            int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 2;
            int y = 1;
            boolean stillcoil = true;
            block10: while (stillcoil) {
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        boolean bl = stillcoil = aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(ItemRegistry.BW_BLOCKS[2]) && aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == 1;
                        if (!stillcoil) break;
                        ++this.mCoilWicks;
                        if (this.mCoilWicks % 8L != 0L) continue;
                        ++y;
                    }
                    if (!stillcoil) continue block10;
                }
            }
            if (this.mCoilWicks % 8L != 0L) {
                return false;
            }
            this.mCoilWicks /= 8L;
            int i = 1;
            while ((long)i <= this.mCoilWicks) {
                if (!aBaseMetaTileEntity.getBlockOffset(xDir, i, zDir).equals(ItemRegistry.BW_BLOCKS[2]) && aBaseMetaTileEntity.getMetaIDOffset(xDir, i, zDir) == 0) {
                    return false;
                }
                ++i;
            }
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    if (xDir + x == 0 && zDir + z == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, 0, zDir + z), this.texid) || this.addEnergyInputToMachineList(tTileEntity, this.texid) || aBaseMetaTileEntity.getBlockOffset(xDir + x, 0, zDir + z) == GregTech_API.sBlockCasings1) continue;
                    return false;
                }
            }
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, (int)this.mCoilWicks + 1, zDir + z);
                    if (this.addMaintenanceToMachineList(tTileEntity, this.texid) || this.addDynamoToMachineList(tTileEntity, this.texid) || aBaseMetaTileEntity.getBlockOffset(xDir + x, (int)this.mCoilWicks + 1, zDir + z) == GregTech_API.sBlockCasings1) continue;
                    return false;
                }
            }
            if (this.mDynamoHatches.size() <= 0 || this.mEnergyHatches.size() <= 0) {
                return false;
            }
            byte outtier = ((GT_MetaTileEntity_Hatch_Dynamo)this.mDynamoHatches.get((int)0)).mTier;
            for (Object out : this.mDynamoHatches) {
                if (((GT_MetaTileEntity_Hatch_Dynamo)out).mTier == outtier) continue;
                return false;
            }
            byte intier = ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get((int)0)).mTier;
            for (GT_MetaTileEntity_Hatch_Energy in : this.mEnergyHatches) {
                if (in.mTier == intier) continue;
                return false;
            }
            for (int ty = 1; ty <= y; ++ty) {
                byte leveltier;
                if (this.mInventory[1].getItemDamage() == 2) {
                    leveltier = (byte)(intier - ty);
                } else if (this.mInventory[1].getItemDamage() == 3) {
                    leveltier = (byte)(intier + ty);
                } else {
                    return false;
                }
                for (int x2 = -2; x2 <= 2; ++x2) {
                    for (int z2 = -2; z2 <= 2; ++z2) {
                        IGregTechTileEntity tTileEntity2;
                        if (x2 != -2 && z2 != -2 && x2 != 2 && z2 != 2 || this.addMaintenanceToMachineList(tTileEntity2 = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x2, ty, zDir + z2), this.texid) || this.addEnergyInputToMachineList(tTileEntity2, this.texid, leveltier) || this.addDynamoToMachineList(tTileEntity2, this.texid, leveltier) || aBaseMetaTileEntity.getBlockOffset(xDir + x2, ty, zDir + z2) == GregTech_API.sBlockCasings1) continue;
                        return false;
                    }
                }
            }
        }
        return !this.mDynamoHatches.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ManualTrafo(this.mName);
    }

    public String[] getDescription() {
        String[] dsc = StatCollector.translateToLocal((String)"tooltip.tile.manualtravo.0.name").split(";");
        String[] fdsc = new String[dsc.length + 1];
        for (int i = 0; i < dsc.length; ++i) {
            fdsc[i] = dsc[i];
            fdsc[dsc.length] = StatCollector.translateToLocal((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks";
        }
        return fdsc;
    }

    public void saveNBTData(NBTTagCompound ntag) {
        ntag.setLong("mCoilWicks", this.mCoilWicks);
        super.saveNBTData(ntag);
    }

    public void loadNBTData(NBTTagCompound ntag) {
        super.loadNBTData(ntag);
        this.mCoilWicks = ntag.getLong("mCoilWicks");
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.CASING_BLOCKS[this.texid];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.CASING_BLOCKS[this.texid];
        }
        return iTextureArray;
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex, short tier) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            if (tier == ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mTier) {
                ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
                return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
            }
            return false;
        }
        return false;
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex, short tier) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            if (tier == ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mTier) {
                ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
                return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
            }
            return false;
        }
        return false;
    }
}

