/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.classic;

import com.github.bartimaeusnek.bartworks.API.ITileAddsInformation;
import com.github.bartimaeusnek.bartworks.API.ITileDropsContent;
import com.github.bartimaeusnek.bartworks.API.ITileHasDifferentTextureSides;
import com.github.bartimaeusnek.bartworks.API.ITileWithGUI;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import gregtech.common.GT_Pollution;
import java.util.Optional;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class BW_TileEntity_HeatedWaterPump
extends TileEntity
implements ITileDropsContent,
IFluidHandler,
IFluidTank,
ITileWithGUI,
ITileAddsInformation,
ITileHasDifferentTextureSides {
    public static final int FUELSLOT = 0;
    public static final Fluid WATER = FluidRegistry.WATER;
    public ItemStack fuelstack;
    public FluidStack outputstack = new FluidStack(FluidRegistry.WATER, 0);
    public int fuel;
    public byte tick;
    public int maxfuel;
    public ItemStack fakestack = new ItemStack(Blocks.water);

    public void writeToNBT(NBTTagCompound p_145841_1_) {
        NBTTagCompound subItemStack = new NBTTagCompound();
        if (this.fuelstack != null) {
            this.fuelstack.writeToNBT(subItemStack);
        }
        p_145841_1_.setTag("ItemStack", (NBTBase)subItemStack);
        NBTTagCompound subFluidStack = new NBTTagCompound();
        this.outputstack.writeToNBT(subFluidStack);
        p_145841_1_.setTag("FluidStack", (NBTBase)subFluidStack);
        p_145841_1_.setInteger("fuel", this.fuel);
        p_145841_1_.setInteger("maxfuel", this.maxfuel);
        p_145841_1_.setByte("tick", this.tick);
        super.writeToNBT(p_145841_1_);
    }

    public void readFromNBT(NBTTagCompound p_145839_1_) {
        this.tick = p_145839_1_.getByte("tick");
        this.fuel = p_145839_1_.getInteger("fuel");
        this.maxfuel = p_145839_1_.getInteger("maxfuel");
        this.outputstack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)p_145839_1_.getCompoundTag("FluidStack"));
        if (!p_145839_1_.getCompoundTag("ItemStack").equals((Object)new NBTTagCompound())) {
            this.fuelstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)p_145839_1_.getCompoundTag("ItemStack"));
        }
        super.readFromNBT(p_145839_1_);
    }

    private boolean checkPreUpdate() {
        return this.worldObj.isRemote || (this.fuelstack == null || this.fuelstack.stackSize <= 0) && this.fuel <= 0 || this.tick == 0 && this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord) == Blocks.air;
    }

    private void fixUnderlflow() {
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    private void handleRefuel() {
        if (this.fuelstack != null && this.fuel == 0) {
            this.fuel = this.maxfuel = TileEntityFurnace.getItemBurnTime((ItemStack)this.fuelstack);
            --this.fuelstack.stackSize;
            if (this.fuelstack.stackSize <= 0) {
                this.fuelstack = null;
            }
        }
    }

    private void handleWaterGeneration() {
        if (this.fuel > 0) {
            this.tick = (byte)(this.tick + 1);
            --this.fuel;
            if (this.tick % 20 == 0) {
                if (this.outputstack.amount <= 8000 - ConfigHandler.mbWaterperSec) {
                    this.outputstack.amount += ConfigHandler.mbWaterperSec;
                }
                this.tick = 0;
            }
        }
    }

    public void updateEntity() {
        if (this.checkPreUpdate()) {
            return;
        }
        this.fixUnderlflow();
        this.handleRefuel();
        this.handleWaterGeneration();
        this.causePollution();
    }

    private void causePollution() {
        Optional.ofNullable(this.worldObj).ifPresent(e -> {
            if (e.getTotalWorldTime() % 20L == 0L) {
                Optional.ofNullable(e.getChunkFromBlockCoords(this.xCoord, this.zCoord)).ifPresent(c -> GT_Pollution.addPollution((Chunk)c, (int)5));
            }
        });
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[]{0};
    }

    public boolean canInsertItem(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)p_102007_2_) > 0;
    }

    public boolean canExtractItem(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int getSizeInventory() {
        return 2;
    }

    public ItemStack getStackInSlot(int p_70301_1_) {
        if (p_70301_1_ == 0) {
            return this.fuelstack;
        }
        return this.fakestack;
    }

    public ItemStack decrStackSize(int slot, int ammount) {
        if (slot != 0 || this.fuelstack == null || ammount > this.fuelstack.stackSize) {
            return null;
        }
        return this.fuelstack.splitStack(ammount);
    }

    public ItemStack getStackInSlotOnClosing(int p_70304_1_) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack p_70299_2_) {
        if (slot == 0) {
            this.fuelstack = p_70299_2_;
        } else {
            this.fakestack = p_70299_2_;
        }
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int p_94041_1_, ItemStack p_94041_2_) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)p_94041_2_) > 0 && p_94041_1_ == 0;
    }

    public FluidStack getFluid() {
        return this.outputstack.amount > 0 ? this.outputstack : null;
    }

    public int getFluidAmount() {
        return this.outputstack.amount;
    }

    public int getCapacity() {
        return 8000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int actualdrain = maxDrain;
        if (actualdrain > this.outputstack.amount) {
            actualdrain = this.outputstack.amount;
        }
        FluidStack ret = new FluidStack(WATER, actualdrain);
        if (ret.amount == 0) {
            ret = null;
        }
        if (doDrain) {
            this.outputstack.amount -= actualdrain;
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.outputstack, this.getWorldObj(), this.xCoord, this.yCoord, this.zCoord, (IFluidTank)this, actualdrain));
        }
        return ret;
    }

    @Override
    public int getGUIID() {
        return 3;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == WATER && this.drain(resource.amount, false) != null) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null || fluid == WATER;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.translateToLocal((String)"tooltip.tile.waterpump.0.name") + " " + ConfigHandler.mbWaterperSec + StatCollector.translateToLocal((String)"tooltip.tile.waterpump.1.name"), StatCollector.translateToLocal((String)"tooltip.tile.waterpump.2.name")};
    }

    @Override
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        ITileHasDifferentTextureSides.texture[ForgeDirection.UP.ordinal()] = par1IconRegister.registerIcon("bartworks:heatedWaterPumpTop");
        ITileHasDifferentTextureSides.texture[ForgeDirection.DOWN.ordinal()] = par1IconRegister.registerIcon("bartworks:heatedWaterPumpDown");
        for (int i = 2; i < 7; ++i) {
            ITileHasDifferentTextureSides.texture[i] = par1IconRegister.registerIcon("bartworks:heatedWaterPumpSide");
        }
    }
}

