/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.common.items.LabModule;
import com.github.bartimaeusnek.bartworks.common.items.LabParts;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.BioDNA;
import com.github.bartimaeusnek.bartworks.util.BioData;
import com.github.bartimaeusnek.bartworks.util.BioPlasmid;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BioItemList {
    private static final Item mItemBioLabParts = new LabModule(new String[]{"DNAExtractionModule", "PCRThermoclyclingModule", "PlasmidSynthesisModule", "TransformationModule", "ClonalCellularSynthesisModule"});
    public static final ItemStack[] mBioLabParts = new ItemStack[]{new ItemStack(mItemBioLabParts), new ItemStack(mItemBioLabParts, 1, 1), new ItemStack(mItemBioLabParts, 1, 2), new ItemStack(mItemBioLabParts, 1, 3), new ItemStack(mItemBioLabParts, 1, 4)};
    private static final Item vanillaBioLabParts = new LabParts(new String[]{"petriDish", "DNASampleFlask", "PlasmidCell", "DetergentPowder", "Agarose", "IncubationModule", "PlasmaMembrane"});

    private BioItemList() {
    }

    public static void registerBioItems() {
        GameRegistry.registerItem((Item)mItemBioLabParts, (String)"BioLabModules");
        GameRegistry.registerItem((Item)vanillaBioLabParts, (String)"BioLabParts");
    }

    public static Collection<ItemStack> getAllPetriDishes() {
        HashSet<ItemStack> ret = new HashSet<ItemStack>();
        for (BioCulture Culture : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            ret.add(BioItemList.getPetriDish(Culture));
        }
        return ret;
    }

    public static Collection<ItemStack> getAllDNASampleFlasks() {
        HashSet<ItemStack> ret = new HashSet<ItemStack>();
        for (BioData dna : BioData.BIO_DATA_ARRAY_LIST) {
            ret.add(BioItemList.getDNASampleFlask(BioDNA.convertDataToDNA(dna)));
        }
        return ret;
    }

    public static Collection<ItemStack> getAllPlasmidCells() {
        HashSet<ItemStack> ret = new HashSet<ItemStack>();
        for (BioData dna : BioData.BIO_DATA_ARRAY_LIST) {
            ret.add(BioItemList.getPlasmidCell(BioPlasmid.convertDataToPlasmid(dna)));
        }
        return ret;
    }

    public static ItemStack getPetriDish(BioCulture Culture) {
        if (Culture == null) {
            return new ItemStack(vanillaBioLabParts);
        }
        ItemStack ret = new ItemStack(vanillaBioLabParts);
        ret.setTagCompound(BioCulture.getNBTTagFromCulture(Culture));
        return ret;
    }

    public static ItemStack getDNASampleFlask(BioDNA dna) {
        if (dna == null) {
            return new ItemStack(vanillaBioLabParts, 1, 1);
        }
        ItemStack ret = new ItemStack(vanillaBioLabParts, 1, 1);
        ret.setTagCompound(BioData.getNBTTagFromBioData(dna));
        return ret;
    }

    public static ItemStack getPlasmidCell(BioPlasmid plasmid) {
        if (plasmid == null) {
            return new ItemStack(vanillaBioLabParts, 1, 2);
        }
        ItemStack ret = new ItemStack(vanillaBioLabParts, 1, 2);
        ret.setTagCompound(BioData.getNBTTagFromBioData(plasmid));
        return ret;
    }

    public static ItemStack getOther(int selection) {
        if (selection < 1 || selection > 4) {
            return null;
        }
        return new ItemStack(vanillaBioLabParts, 1, 2 + selection);
    }
}

