/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.blocks;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.client.renderer.RendererGlasBlock;
import com.github.bartimaeusnek.bartworks.common.blocks.BW_Blocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BW_GlasBlocks
extends BW_Blocks {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] connectedTexture;
    private final boolean connectedTex;
    private boolean fake;
    private short[][] color;

    public BW_GlasBlocks(String name, String[] texture, CreativeTabs tabs) {
        super(name, texture, tabs, Material.glass);
        this.color = new short[this.textureNames.length][3];
        this.connectedTex = false;
    }

    public BW_GlasBlocks(String name, String[] texture, short[][] color, CreativeTabs tabs, boolean connectedTex, boolean fake) {
        super(name, texture, tabs, Material.glass);
        this.color = new short[this.textureNames.length][3];
        this.connectedTex = connectedTex;
        this.color = color;
        this.fake = fake;
    }

    public short[] getColor(int meta) {
        return meta < this.texture.length ? this.color[meta] : this.color[0];
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess worldClient, int xCoord, int yCoord, int zCoord, int aSide) {
        if (worldClient.getBlock(xCoord, yCoord, zCoord) instanceof BW_GlasBlocks) {
            return false;
        }
        return super.shouldSideBeRendered(worldClient, xCoord, yCoord, zCoord, aSide);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return meta < this.texture.length ? this.texture[meta] : this.texture[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        if (!this.connectedTex) {
            this.texture = new IIcon[this.textureNames.length];
            for (int i = 0; i < this.textureNames.length; ++i) {
                this.texture[i] = par1IconRegister.registerIcon(this.textureNames[i]);
            }
            return;
        }
        this.texture = new IIcon[this.textureNames.length];
        this.connectedTexture = new IIcon[16];
        for (int i = 0; i < this.textureNames.length; ++i) {
            this.texture[i] = par1IconRegister.registerIcon(this.textureNames[i]);
            for (int j = 0; j < 16; ++j) {
                this.connectedTexture[j] = par1IconRegister.registerIcon(this.textureNames[0] + "_" + j);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess worldClient, int xCoord, int yCoord, int zCoord, int aSide) {
        if (!this.connectedTex) {
            return super.getIcon(worldClient, xCoord, yCoord, zCoord, aSide);
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)aSide);
        int sides = 0;
        switch (dir) {
            case UP: 
            case DOWN: {
                if (worldClient.getBlock(xCoord, yCoord, zCoord - 1) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 1);
                }
                if (worldClient.getBlock(xCoord, yCoord, zCoord + 1) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 2);
                }
                if (worldClient.getBlock(xCoord - 1, yCoord, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 4);
                }
                if (!(worldClient.getBlock(xCoord + 1, yCoord, zCoord) instanceof BW_GlasBlocks)) break;
                sides = (byte)(sides | 8);
                break;
            }
            case EAST: {
                if (worldClient.getBlock(xCoord, yCoord + 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 1);
                }
                if (worldClient.getBlock(xCoord, yCoord - 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 2);
                }
                if (worldClient.getBlock(xCoord, yCoord, zCoord + 1) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 4);
                }
                if (!(worldClient.getBlock(xCoord, yCoord, zCoord - 1) instanceof BW_GlasBlocks)) break;
                sides = (byte)(sides | 8);
                break;
            }
            case WEST: {
                if (worldClient.getBlock(xCoord, yCoord + 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 1);
                }
                if (worldClient.getBlock(xCoord, yCoord - 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 2);
                }
                if (worldClient.getBlock(xCoord, yCoord, zCoord - 1) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 4);
                }
                if (!(worldClient.getBlock(xCoord, yCoord, zCoord + 1) instanceof BW_GlasBlocks)) break;
                sides = (byte)(sides | 8);
                break;
            }
            case NORTH: {
                if (worldClient.getBlock(xCoord, yCoord + 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 1);
                }
                if (worldClient.getBlock(xCoord, yCoord - 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 2);
                }
                if (worldClient.getBlock(xCoord + 1, yCoord, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 4);
                }
                if (!(worldClient.getBlock(xCoord - 1, yCoord, zCoord) instanceof BW_GlasBlocks)) break;
                sides = (byte)(sides | 8);
                break;
            }
            case SOUTH: {
                if (worldClient.getBlock(xCoord, yCoord + 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 1);
                }
                if (worldClient.getBlock(xCoord, yCoord - 1, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 2);
                }
                if (worldClient.getBlock(xCoord - 1, yCoord, zCoord) instanceof BW_GlasBlocks) {
                    sides = (byte)(sides | 4);
                }
                if (!(worldClient.getBlock(xCoord + 1, yCoord, zCoord) instanceof BW_GlasBlocks)) break;
                sides = (byte)(sides | 8);
                break;
            }
        }
        return this.connectedTexture[sides];
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderBlockPass() {
        return 1;
    }

    public int getRenderType() {
        if (!this.fake && SideReference.Side.Client) {
            return RendererGlasBlock.RID;
        }
        return 0;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    protected boolean canSilkHarvest() {
        return false;
    }
}

