/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.API;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Materials;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public final class BioVatLogicAdder {

    public static class BlockMetaPair {
        final Block block;
        final Byte aByte;

        public BlockMetaPair(Block block, Byte aByte) {
            this.block = block;
            this.aByte = aByte;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockMetaPair that = (BlockMetaPair)o;
            return Objects.equals(this.getBlock(), that.getBlock()) && Objects.equals(this.getaByte(), that.getaByte());
        }

        public int hashCode() {
            return Objects.hash(this.getBlock(), this.getaByte());
        }

        public Block getBlock() {
            return this.block;
        }

        public Byte getaByte() {
            return this.aByte;
        }
    }

    public static class MaterialSvPair {
        final Materials materials;
        final Integer sievert;

        public MaterialSvPair(Materials materials, Integer sievert) {
            this.materials = materials;
            this.sievert = sievert;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterialSvPair that = (MaterialSvPair)o;
            return Objects.equals(this.getMaterials(), that.getMaterials()) && Objects.equals(this.getSievert(), that.getSievert());
        }

        public int hashCode() {
            return Objects.hash(this.getMaterials(), this.getSievert());
        }

        public Materials getMaterials() {
            return this.materials;
        }

        public Integer getSievert() {
            return this.sievert;
        }
    }

    public static class BioVatGlass {
        private static final HashMap<BlockMetaPair, Byte> glasses = new HashMap();

        public static boolean addCustomGlass(String sModname, String sUnlocBlockName, int meta, int tier) {
            boolean ret;
            Block block = GameRegistry.findBlock((String)sModname, (String)sUnlocBlockName);
            boolean bl = ret = block != null;
            if (ret) {
                glasses.put(new BlockMetaPair(block, (byte)meta), (byte)tier);
            } else {
                new IllegalArgumentException("Block: " + sUnlocBlockName + " of the Mod: " + sModname + " was NOT found!").printStackTrace();
            }
            block = null;
            return ret;
        }

        public static void addCustomGlass(@Nonnull Block block, @Nonnegative int meta, @Nonnegative int tier) {
            glasses.put(new BlockMetaPair(block, (byte)meta), (byte)tier);
        }

        public static void addCustomGlass(@Nonnull Block block, @Nonnegative int tier) {
            glasses.put(new BlockMetaPair(block, (byte)0), (byte)tier);
        }

        public static void addCustomGlass(@Nonnull BlockMetaPair blockBytePair, @Nonnegative byte tier) {
            glasses.put(blockBytePair, tier);
        }

        public static HashMap<BlockMetaPair, Byte> getGlassMap() {
            return glasses;
        }
    }

    public static class RadioHatch {
        private static final HashSet<MaterialSvPair> MaSv = new HashSet();
        private static final HashMap<ItemStack, Integer> IsSv = new HashMap();
        public static int MaxSV = 150;

        public static HashSet<MaterialSvPair> getMaSv() {
            return MaSv;
        }

        public static HashMap<ItemStack, Integer> getIsSv() {
            return IsSv;
        }

        public static void setOverrideSvForMaterial(Materials m, Integer sv) {
            MaSv.add(new MaterialSvPair(m, sv));
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, Integer sv) {
            IsSv.put(stack, sv);
        }

        public static int getMaxSv() {
            int ret = MaxSV;
            for (MaterialSvPair pair : RadioHatch.getMaSv()) {
                if (pair.getSievert() <= ret) continue;
                ret = pair.getSievert();
            }
            for (ItemStack is : IsSv.keySet()) {
                if (IsSv.get(is) <= ret) continue;
                ret = IsSv.get(is);
            }
            return ret;
        }
    }
}

