/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileInterface
extends AENetworkInvTile
implements IGridTickable,
ITileStorageMonitorable,
IStorageMonitorable,
IInventoryDestination,
IInterfaceHost,
IPriorityHost {
    private final DualityInterface duality = new DualityInterface(this.getProxy(), this);
    private ForgeDirection pointAt = ForgeDirection.UNKNOWN;

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.notifyNeighbors();
    }

    public void setSide(ForgeDirection axis) {
        if (Platform.isClient()) {
            return;
        }
        this.pointAt = this.pointAt == axis.getOpposite() ? axis : (this.pointAt == axis || this.pointAt == axis.getOpposite() ? ForgeDirection.UNKNOWN : (this.pointAt == ForgeDirection.UNKNOWN ? axis.getOpposite() : Platform.rotateAround(this.pointAt, axis)));
        if (ForgeDirection.UNKNOWN == this.pointAt) {
            this.setOrientation(this.pointAt, this.pointAt);
        } else {
            this.setOrientation(this.pointAt.offsetY != 0 ? ForgeDirection.SOUTH : ForgeDirection.UP, this.pointAt.getOpposite());
        }
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.pointAt)));
        this.markForUpdate();
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.duality.markDirty();
    }

    @Override
    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        this.duality.addDrops(drops);
    }

    @Override
    public void gridChanged() {
        this.duality.gridChanged();
    }

    @Override
    public void onReady() {
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.pointAt)));
        super.onReady();
        this.duality.initialize();
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileInterface(NBTTagCompound data) {
        data.func_74768_a("pointAt", this.pointAt.ordinal());
        this.duality.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileInterface(NBTTagCompound data) {
        int val = data.func_74762_e("pointAt");
        this.pointAt = val >= 0 && val < ForgeDirection.values().length ? ForgeDirection.values()[val] : ForgeDirection.UNKNOWN;
        this.duality.readFromNBT(data);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return this.duality.getCableConnectionType(dir);
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.duality.getLocation();
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsert(stack);
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.duality.getItemInventory();
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.duality.getFluidInventory();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.duality.tickingRequest(node, ticksSinceLastCall);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.duality.getInternalInventory();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.duality.onChangeInventory(inv, slot, mc, removed, added);
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.duality.getAccessibleSlotsFromSide(side.ordinal());
    }

    @Override
    public DualityInterface getInterfaceDuality() {
        return this.duality;
    }

    @Override
    public EnumSet<ForgeDirection> getTargets() {
        if (this.pointAt == null || this.pointAt == ForgeDirection.UNKNOWN) {
            return EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN));
        }
        return EnumSet.of(this.pointAt);
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this.duality.getMonitorable(side, src, this);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    @Override
    public boolean isBusy() {
        return this.duality.isBusy();
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestedJobs();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.duality.jobStateChange(link);
    }

    @Override
    public int getPriority() {
        return this.duality.getPriority();
    }

    @Override
    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }
}

