/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.tile.AEBaseInvTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSkyChest
extends AEBaseInvTile {
    private final int[] sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 36);
    private int playerOpen;
    private long lastEvent;
    private float lidAngle;

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileSkyChest(ByteBuf data) {
        data.writeBoolean(this.getPlayerOpen() > 0);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileSkyChest(ByteBuf data) {
        int wasOpen = this.getPlayerOpen();
        this.setPlayerOpen(data.readBoolean() ? 1 : 0);
        if (wasOpen != this.getPlayerOpen()) {
            this.setLastEvent(System.currentTimeMillis());
        }
        return false;
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void openInventory() {
        if (Platform.isClient()) {
            return;
        }
        this.setPlayerOpen(this.getPlayerOpen() + 1);
        if (this.getPlayerOpen() == 1) {
            this.getWorldObj().playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.chestopen", 0.5f, this.getWorldObj().rand.nextFloat() * 0.1f + 0.9f);
            this.markForUpdate();
        }
    }

    @Override
    public void closeInventory() {
        if (Platform.isClient()) {
            return;
        }
        this.setPlayerOpen(this.getPlayerOpen() - 1);
        if (this.getPlayerOpen() < 0) {
            this.setPlayerOpen(0);
        }
        if (this.getPlayerOpen() == 0) {
            this.getWorldObj().playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.chestclosed", 0.5f, this.getWorldObj().rand.nextFloat() * 0.1f + 0.9f);
            this.markForUpdate();
        }
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    public void setLidAngle(float lidAngle) {
        this.lidAngle = lidAngle;
    }

    public int getPlayerOpen() {
        return this.playerOpen;
    }

    private void setPlayerOpen(int playerOpen) {
        this.playerOpen = playerOpen;
    }

    public long getLastEvent() {
        return this.lastEvent;
    }

    private void setLastEvent(long lastEvent) {
        this.lastEvent = lastEvent;
    }
}

