/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.iterators.AEInvIterator;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AppEngInternalAEInventory
implements IInventory,
Iterable<ItemStack> {
    private final IAEAppEngInventory te;
    private final IAEItemStack[] inv;
    private final int size;
    private int maxStack;

    public AppEngInternalAEInventory(IAEAppEngInventory te, int s) {
        this.te = te;
        this.size = s;
        this.maxStack = 64;
        this.inv = new IAEItemStack[s];
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.size; ++x) {
            if (this.getStackInSlot(x) == null) continue;
            return false;
        }
        return true;
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public IAEItemStack getAEStackInSlot(int var1) {
        return this.inv[var1];
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.setTag(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    this.inv[x].writeToNBT(c);
                }
                target.setTag("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.getCompoundTag(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = target.getCompoundTag("#" + x);
                if (c == null) continue;
                this.inv[x] = AEItemStack.loadItemStackFromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    public int getSizeInventory() {
        return this.size;
    }

    public ItemStack getStackInSlot(int var1) {
        if (this.inv[var1] == null) {
            return null;
        }
        return this.inv[var1].getItemStack();
    }

    public ItemStack decrStackSize(int slot, int qty) {
        if (this.inv[slot] != null) {
            ItemStack split = this.getStackInSlot(slot);
            ItemStack ns = null;
            if (qty >= split.stackSize) {
                ns = this.getStackInSlot(slot);
                this.inv[slot] = null;
            } else {
                ns = split.splitStack(qty);
            }
            if (this.te != null && Platform.isServer()) {
                this.te.onChangeInventory(this, slot, InvOperation.decreaseStackSize, ns, null);
            }
            return ns;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.getStackInSlot(slot);
        this.inv[slot] = AEApi.instance().storage().createItemStack(newItemStack);
        if (this.te != null && Platform.isServer()) {
            ItemStack removed = oldStack;
            ItemStack added = newItemStack;
            if (oldStack != null && newItemStack != null && Platform.isSameItem(oldStack, newItemStack)) {
                if (oldStack.stackSize > newItemStack.stackSize) {
                    removed = removed.copy();
                    removed.stackSize -= newItemStack.stackSize;
                    added = null;
                } else if (oldStack.stackSize < newItemStack.stackSize) {
                    added = added.copy();
                    added.stackSize -= oldStack.stackSize;
                    removed = null;
                } else {
                    added = null;
                    removed = null;
                }
            }
            this.te.onChangeInventory(this, slot, InvOperation.setInventorySlotContents, removed, added);
        }
    }

    public String getInventoryName() {
        return "appeng-internal";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return this.maxStack > 64 ? 64 : this.maxStack;
    }

    public void markDirty() {
        if (this.te != null && Platform.isServer()) {
            this.te.onChangeInventory(this, -1, InvOperation.markDirty, null, null);
        }
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator(this);
    }

    public Iterator<IAEItemStack> getNewAEIterator() {
        return new AEInvIterator(this);
    }
}

