/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.settings.TickRates;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBuildCraftTransport;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.inventory.AppEngNullInventory;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import appeng.util.inv.WrapperBCPipe;
import appeng.util.inv.WrapperChainedInventory;
import appeng.util.inv.WrapperMCISidedInventory;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.Interface(iface="buildcraft.api.transport.IPipeConnection", iname=IntegrationType.BuildCraftTransport)
public class PartP2PItems
extends PartP2PTunnel<PartP2PItems>
implements IPipeConnection,
ISidedInventory,
IGridTickable {
    private final LinkedList<IInventory> which = new LinkedList();
    private int oldSize = 0;
    private boolean requested;
    private IInventory cachedInv;

    public PartP2PItems(ItemStack is) {
        super(is);
    }

    @Override
    public void onNeighborChanged() {
        this.cachedInv = null;
        PartP2PItems input = (PartP2PItems)this.getInput();
        if (input != null && this.isOutput()) {
            input.onTunnelNetworkChange();
        }
    }

    private IInventory getDestination() {
        TunnelCollection itemTunnels;
        this.requested = true;
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        LinkedList<IInventory> outs = new LinkedList<IInventory>();
        try {
            itemTunnels = this.getOutputs();
        }
        catch (GridAccessException e) {
            return new AppEngNullInventory();
        }
        for (PartP2PItems t : itemTunnels) {
            IInventory inv = t.getOutputInv();
            if (inv == null) continue;
            if (Platform.getRandomInt() % 2 == 0) {
                outs.add(inv);
                continue;
            }
            outs.add(0, inv);
        }
        this.cachedInv = new WrapperChainedInventory(outs);
        return this.cachedInv;
    }

    private IInventory getOutputInv() {
        IInventory output = null;
        if (this.getProxy().isActive()) {
            IBuildCraftTransport buildcraft;
            TileEntity te = this.getTile().getWorldObj().getTileEntity(this.getTile().xCoord + this.getSide().offsetX, this.getTile().yCoord + this.getSide().offsetY, this.getTile().zCoord + this.getSide().offsetZ);
            if (this.which.contains(this)) {
                return null;
            }
            this.which.add((IInventory)this);
            if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.BuildCraftTransport) && (buildcraft = (IBuildCraftTransport)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.BuildCraftTransport)).isPipe(te, this.getSide().getOpposite())) {
                try {
                    output = new WrapperBCPipe(te, this.getSide().getOpposite());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (output == null) {
                if (te instanceof TileEntityChest) {
                    output = Platform.GetChestInv(te);
                } else if (te instanceof ISidedInventory) {
                    output = new WrapperMCISidedInventory((ISidedInventory)te, this.getSide().getOpposite());
                } else if (te instanceof IInventory) {
                    output = (IInventory)te;
                }
            }
            this.which.pop();
        }
        return output;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ItemTunnel.getMin(), TickRates.ItemTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        boolean wasReq = this.requested;
        if (this.requested && this.cachedInv != null) {
            ((WrapperChainedInventory)this.cachedInv).cycleOrder();
        }
        this.requested = false;
        return wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSizeInventory();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSizeInventory();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSizeInventory();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.hopper.getBlockTextureFromSide(0);
    }

    @Override
    public void onTunnelNetworkChange() {
        if (!this.isOutput()) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().getSizeInventory();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        } else {
            PartP2PItems input = (PartP2PItems)this.getInput();
            if (input != null) {
                input.getHost().notifyNeighbors();
            }
        }
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        int[] slots = new int[this.getSizeInventory()];
        for (int x = 0; x < this.getSizeInventory(); ++x) {
            slots[x] = x;
        }
        return slots;
    }

    public int getSizeInventory() {
        return this.getDestination().getSizeInventory();
    }

    public ItemStack getStackInSlot(int i) {
        return this.getDestination().getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        return this.getDestination().decrStackSize(i, j);
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.getDestination().setInventorySlotContents(i, itemstack);
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return this.getDestination().getInventoryStackLimit();
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.getDestination().isItemValidForSlot(i, itemstack);
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return this.getDestination().isItemValidForSlot(i, itemstack);
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Integration.Method(iname=IntegrationType.BuildCraftTransport)
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return this.getSide() == with && type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }
}

